/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.DynamicBundle;
import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.TargetBasedSdkAdditionalData;
import com.intellij.execution.target.TargetBrowserHints;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableFunction;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSdkDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myNameTextField;
    private TextFieldWithBrowseButton myInterpreterPathTextField;
    private JBCheckBox myAssociateCheckbox;
    private JBLabel myRemoveAssociationLabel;
    private final boolean myWasAssociated;
    private boolean myAssociationRemoved = false;

    protected EditSdkDialog(Project project2, SdkModificator sdk2, final NullableFunction<? super String, String> nameValidator) {
        super(project2, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(PyBundle.message("sdk.edit.dialog.title", objectArray));
        this.myNameTextField.setText(sdk2.getName());
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                @NlsSafe String nameError = (String)nameValidator.fun((Object)EditSdkDialog.this.getName());
                EditSdkDialog.this.setErrorText(nameError, EditSdkDialog.this.myNameTextField);
                EditSdkDialog.this.setOKActionEnabled(nameError == null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/EditSdkDialog$1", "textChanged"));
            }
        });
        String homePath2 = sdk2.getHomePath();
        this.myInterpreterPathTextField.setText(homePath2);
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        String label = PyBundle.message("sdk.edit.dialog.specify.interpreter.path", new Object[0]);
        ActionListener targetListener = this.createBrowseTargetListener(project2, sdkAdditionalData, label);
        if (targetListener != null) {
            this.myInterpreterPathTextField.addActionListener(targetListener);
        } else {
            this.myInterpreterPathTextField.addBrowseFolderListener(label, null, project2, PythonSdkType.getInstance().getHomeChooserDescriptor());
        }
        this.myRemoveAssociationLabel.setVisible(false);
        PythonSdkFlavor<?> sdkFlavor = PythonSdkFlavor.getPlatformIndependentFlavor(homePath2);
        if (sdkFlavor instanceof VirtualEnvSdkFlavor || sdkFlavor instanceof CondaEnvSdkFlavor) {
            String path2;
            PythonSdkAdditionalData data = (PythonSdkAdditionalData)sdk2.getSdkAdditionalData();
            if (data != null && (path2 = data.getAssociatedModulePath()) != null) {
                this.myAssociateCheckbox.setSelected(true);
                String basePath = project2.getBasePath();
                if (basePath != null && !path2.equals(FileUtil.toSystemIndependentName((String)basePath))) {
                    this.myAssociateCheckbox.setEnabled(false);
                    this.myAssociateCheckbox.setText(PyBundle.message("sdk.edit.dialog.associate.virtual.env.with.path", FileUtil.toSystemDependentName((String)path2)));
                    this.myRemoveAssociationLabel.setVisible(true);
                }
            }
        } else {
            this.myAssociateCheckbox.setVisible(false);
        }
        this.myWasAssociated = this.myAssociateCheckbox.isSelected();
        this.init();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditSdkDialog.this.myAssociateCheckbox.setSelected(false);
                EditSdkDialog.this.myAssociateCheckbox.setEnabled(true);
                EditSdkDialog.this.myAssociateCheckbox.setText(PyBundle.message("sdk.edit.dialog.associate.virtual.env.current.project", new Object[0]));
                EditSdkDialog.this.myRemoveAssociationLabel.setVisible(false);
                EditSdkDialog.this.myAssociationRemoved = true;
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/EditSdkDialog$2", "onClick"));
            }
        }.installOn((Component)this.myRemoveAssociationLabel);
    }

    @Nullable
    private ActionListener createBrowseTargetListener(@NotNull Project project2, @NotNull SdkAdditionalData sdkAdditionalData, @NotNull @NlsContexts.DialogTitle String label) {
        TargetEnvironmentType type2;
        if (project2 == null) {
            EditSdkDialog.$$$reportNull$$$0(0);
        }
        if (sdkAdditionalData == null) {
            EditSdkDialog.$$$reportNull$$$0(1);
        }
        if (label == null) {
            EditSdkDialog.$$$reportNull$$$0(2);
        }
        if (!(sdkAdditionalData instanceof TargetBasedSdkAdditionalData)) {
            return null;
        }
        TargetEnvironmentConfiguration configuration = ((TargetBasedSdkAdditionalData)sdkAdditionalData).getTargetEnvironmentConfiguration();
        if (configuration != null && (type2 = TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)configuration)) instanceof BrowsableTargetEnvironmentType) {
            return ((BrowsableTargetEnvironmentType)type2).createBrowser(project2, label, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, (Component)this.myInterpreterPathTextField.getTextField(), () -> configuration, new TargetBrowserHints(true, null));
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @NlsSafe
    public String getName() {
        return this.myNameTextField.getText();
    }

    public String getHomePath() {
        return this.myInterpreterPathTextField.getText();
    }

    public boolean associateWithProject() {
        return this.myAssociateCheckbox.isSelected();
    }

    public boolean isAssociateChanged() {
        return this.myWasAssociated != this.associateWithProject() || this.myAssociationRemoved;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", EditSdkDialog.class).getString("form.edit.sdk.label.create.connection.pool.options.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jTextField.setColumns(100);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PyBundle", EditSdkDialog.class).getString("form.edit.sdk.interpreter.path"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myAssociateCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", EditSdkDialog.class).getString("form.edit.sdk.associate.this.virtual.environment.with.current.project"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myRemoveAssociationLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", EditSdkDialog.class).getString("form.edit.sdk.html.href.remove.association"));
        jBLabel.setVisible(true);
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkAdditionalData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/configuration/EditSdkDialog";
        objectArray[2] = "createBrowseTargetListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

