/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.google.common.cache.Cache;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.webcore.packaging.PackageManagementService;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.codeInsight.typing.PyStubPackagesAdvertiser;
import com.jetbrains.python.codeInsight.typing.PyStubPackagesAdvertiserCache;
import com.jetbrains.python.codeInsight.typing.PyStubPackagesCompatibilityInspection;
import com.jetbrains.python.codeInsight.typing.PyStubPackagesInstallingStatus;
import com.jetbrains.python.codeInsight.typing.PyStubPackagesLoaderKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.stubs.PyFromImportStatementStub;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesAdvertiser;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "ignoredPackages", "", "", "getIgnoredPackages", "()Ljava/util/List;", "setIgnoredPackages", "(Ljava/util/List;)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "Visitor", "intellij.python.community.impl"})
final class PyStubPackagesAdvertiser
extends PyInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> ignoredPackages = new ArrayList();
    @NotNull
    private static final Map<String, String> FORCED = MapsKt.emptyMap();
    @NotNull
    private static final Map<String, String> CHECKED;
    @NotNull
    private static final Key<Boolean> BALLOON_SHOWING;
    private static final NotificationGroup BALLOON_NOTIFICATIONS;

    @NotNull
    public final List<String> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    public final void setIgnoredPackages(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.ignoredPackages = list;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.stringList((String)"ignoredPackages", (String)PyPsiBundle.message("INSP.stub.packages.compatibility.ignored.packages.label", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new Visitor(this.ignoredPackages, holder, session);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"coincurve", (Object)"coincurve"), TuplesKt.to((Object)"docutils", (Object)"docutils"), TuplesKt.to((Object)"pika", (Object)"pika"), TuplesKt.to((Object)"gi", (Object)"PyGObject"), TuplesKt.to((Object)"PyQt5", (Object)"PyQt5"), TuplesKt.to((Object)"pyspark", (Object)"pyspark"), TuplesKt.to((Object)"traits", (Object)"traits")};
        CHECKED = MapsKt.mapOf((Pair[])pairArray);
        Key key = Key.create((String)"showingStubPackagesAdvertiserBalloon");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BALLOON_SHOWING = key;
        BALLOON_NOTIFICATIONS = NotificationGroupManager.getInstance().getNotificationGroup("Python Stub Packages Advertiser");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesAdvertiser$Companion;", "", "()V", "BALLOON_NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "BALLOON_SHOWING", "Lcom/intellij/openapi/util/Key;", "", "Lorg/jetbrains/annotations/NotNull;", "CHECKED", "", "", "FORCED", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ4\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J<\u0010\u001b\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0002J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J^\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010(\u001a\u00020)2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+H\u0002J^\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010(\u001a\u00020)2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+H\u0002J\u001e\u0010.\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0002JB\u0010/\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\r002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+H\u0002J<\u00101\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r002\f\u00102\u001a\b\u0012\u0004\u0012\u00020,0\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u00103\u001a\u0004\u0018\u00010\u00042\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020)H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesAdvertiser$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "ignoredPackages", "", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Ljava/util/List;Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "addStubPackagesToIgnore", "", "stubPackages", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "stubPackagesNames", "", "project", "Lcom/intellij/openapi/project/Project;", "packageManager", "Lcom/jetbrains/python/packaging/PyPackageManager;", "checkedSourcesToProcess", "", "sources", "createIgnorePackagesQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "reqs", "createInstallStubPackagesQuickFix", "args", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "forcedSourcesToProcess", "isIgnoredStubPackage", "", "name", "version", "ignoredStubPackages", "processCheckedPackages", "file", "Lcom/jetbrains/python/psi/PyFile;", "cache", "Lcom/google/common/cache/Cache;", "Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesAdvertiserCache$Companion$StubPackagesForSource;", "processForcedPackages", "run", "splitIntoNotCachedAndCached", "Lkotlin/Pair;", "toRequirementsAndExtraArgs", "cached", "topLevelPackagesWithoutStubs", "ref", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "qName", "Lcom/intellij/psi/util/QualifiedName;", "visitPyFile", "node", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyStubPackagesAdvertiser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyStubPackagesAdvertiser.kt\ncom/jetbrains/python/codeInsight/typing/PyStubPackagesAdvertiser$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,333:1\n1611#2:334\n1855#2:335\n1856#2:337\n1612#2:338\n1611#2:339\n1855#2:340\n1856#2:342\n1612#2:343\n1603#2,9:346\n1855#2:355\n1856#2:357\n1612#2:358\n857#2,2:359\n857#2,2:361\n1855#2,2:363\n1620#2,3:365\n1549#2:368\n1620#2,3:369\n1747#2,3:372\n1#3:336\n1#3:341\n1#3:356\n1247#4,2:344\n*S KotlinDebug\n*F\n+ 1 PyStubPackagesAdvertiser.kt\ncom/jetbrains/python/codeInsight/typing/PyStubPackagesAdvertiser$Visitor\n*L\n72#1:334\n72#1:335\n72#1:337\n72#1:338\n73#1:339\n73#1:340\n73#1:342\n73#1:343\n103#1:346,9\n103#1:355\n103#1:357\n103#1:358\n204#1:359,2\n206#1:361,2\n220#1:363,2\n263#1:365,3\n322#1:368\n322#1:369,3\n329#1:372,3\n72#1:336\n73#1:341\n103#1:356\n84#1:344,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final List<String> ignoredPackages;

        public Visitor(@NotNull List<String> ignoredPackages, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter(ignoredPackages, (String)"ignoredPackages");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super(holder, PyInspectionVisitor.getContext(session));
            this.ignoredPackages = ignoredPackages;
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            String it$iv;
            boolean bl;
            StubBasedPsiElement<PyFromImportStatementStub> it;
            boolean bl2;
            Object element$iv;
            Object element$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyFile(node);
            Set sources = new LinkedHashSet();
            List<PyFromImportStatement> list = node.getFromImports();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFromImports(...)");
            Iterable $this$mapNotNullTo$iv = list;
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = element$iv$iv = iterator.next();
                bl2 = false;
                it = (PyFromImportStatement)element$iv;
                boolean bl3 = false;
                if (this.topLevelPackagesWithoutStubs(it.getImportSource(), it.getImportSourceQName()) == null) continue;
                bl = false;
                ((Collection)sources).add(it$iv);
            }
            List<PyImportElement> list2 = node.getImportTargets();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getImportTargets(...)");
            $this$mapNotNullTo$iv = list2;
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = element$iv$iv = iterator.next();
                bl2 = false;
                it = (PyImportElement)element$iv;
                boolean bl4 = false;
                if (this.topLevelPackagesWithoutStubs(it.getImportReferenceExpression(), it.getImportedQName()) == null) continue;
                bl = false;
                ((Collection)sources).add(it$iv);
            }
            if (!((Collection)sources).isEmpty()) {
                this.run(node, sources);
            }
        }

        private final String topLevelPackagesWithoutStubs(PyReferenceExpression ref, QualifiedName qName) {
            if (qName == null) {
                return null;
            }
            if (ref != null) {
                boolean bl;
                block4: {
                    ResolveResult[] resolveResultArray = ref.getReference(this.getResolveContext()).multiResolve(false);
                    Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                    Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])resolveResultArray), (Function1)topLevelPackagesWithoutStubs.1.INSTANCE);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!PyStubPackages.isInStubPackage(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                if (bl) {
                    return null;
                }
            }
            return qName.getFirstComponent();
        }

        /*
         * WARNING - void declaration
         */
        private final void run(PyFile file, Set<String> sources) {
            void $this$mapNotNullTo$iv$iv;
            List installedPackages2;
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            if (module == null) {
                return;
            }
            Module module2 = module;
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(module2);
            if (sdk2 == null) {
                return;
            }
            Sdk sdk3 = sdk2;
            PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk3);
            Intrinsics.checkNotNullExpressionValue((Object)pyPackageManager, (String)"getInstance(...)");
            PyPackageManager packageManager = pyPackageManager;
            List list = packageManager.getPackages();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if ((installedPackages2 = list).isEmpty()) {
                return;
            }
            PackageManagementService packageManagementService = PyPackageManagers.getInstance().getManagementService(file.getProject(), sdk3);
            List availablePackages = packageManagementService.getAllPackagesCached();
            if (availablePackages.isEmpty()) {
                return;
            }
            Iterable $this$mapNotNull$iv = this.ignoredPackages;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PyRequirement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (packageManager.parseRequirement(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List ignoredStubPackages = (List)destination$iv$iv;
            Cache<String, PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource> cache = ((PyStubPackagesAdvertiserCache)ApplicationManager.getApplication().getService(PyStubPackagesAdvertiserCache.class)).forSdk(sdk3);
            Set<String> forcedToLoad = this.processForcedPackages(file, sources, module2, sdk3, packageManager, ignoredStubPackages, cache);
            Set<String> checkedToLoad = this.processCheckedPackages(file, sources, module2, sdk3, packageManager, ignoredStubPackages, cache);
            Set set = SetsKt.plus(forcedToLoad, (Iterable)checkedToLoad);
            Map map = MapsKt.plus((Map)FORCED, (Map)CHECKED);
            Intrinsics.checkNotNull((Object)availablePackages);
            Intrinsics.checkNotNull((Object)packageManagementService);
            PyStubPackagesLoaderKt.loadStubPackagesForSources(set, map, installedPackages2, availablePackages, packageManagementService, sdk3);
        }

        private final Set<String> processForcedPackages(PyFile file, Set<String> sources, Module module, Sdk sdk2, PyPackageManager packageManager, List<? extends PyRequirement> ignoredStubPackages, Cache<String, PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource> cache) {
            Pair<Set<String>, List<PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource>> pair = this.splitIntoNotCachedAndCached(this.forcedSourcesToProcess(sources), cache);
            Set sourcesToLoad = (Set)pair.component1();
            List cached = (List)pair.component2();
            Pair<List<PyRequirement>, List<String>> pair2 = this.toRequirementsAndExtraArgs(cached, ignoredStubPackages);
            List reqs = (List)pair2.component1();
            List args2 = (List)pair2.component2();
            if (!((Collection)reqs).isEmpty()) {
                String string = PyPackageUtil.requirementsToString(reqs);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requirementsToString(...)");
                String reqsToString = string;
                Object[] objectArray = new Object[]{reqs.size(), reqsToString};
                String string2 = PyBundle.message("code.insight.stub.forced.packages.are.not.installed.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String message = string2;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this.createInstallStubPackagesQuickFix(reqs, args2, module, sdk2, packageManager), this.createIgnorePackagesQuickFix(reqs, packageManager)};
                this.registerProblem((PsiElement)file, message, localQuickFixArray);
            }
            return sourcesToLoad;
        }

        private final Set<String> processCheckedPackages(PyFile file, Set<String> sources, Module module, Sdk sdk2, PyPackageManager packageManager, List<? extends PyRequirement> ignoredStubPackages, Cache<String, PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource> cache) {
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Project project3 = project2;
            if (Intrinsics.areEqual((Object)project3.getUserData(BALLOON_SHOWING), (Object)true)) {
                return SetsKt.emptySet();
            }
            Pair<Set<String>, List<PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource>> pair = this.splitIntoNotCachedAndCached(this.checkedSourcesToProcess(sources), cache);
            Set sourcesToLoad = (Set)pair.component1();
            List cached = (List)pair.component2();
            Pair<List<PyRequirement>, List<String>> pair2 = this.toRequirementsAndExtraArgs(cached, ignoredStubPackages);
            List reqs = (List)pair2.component1();
            List args2 = (List)pair2.component2();
            if (!((Collection)reqs).isEmpty()) {
                boolean plural = reqs.size() > 1;
                String string = PyPackageUtil.requirementsToString(reqs);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requirementsToString(...)");
                String reqsToString = string;
                project3.putUserData(BALLOON_SHOWING, (Object)true);
                Object[] objectArray = new Object[]{reqs.size(), reqsToString};
                String string2 = PyBundle.message("code.insight.stub.checked.packages.are.not.installed.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String descriptionTemplate = string2;
                ProblemDescriptorImpl problemDescriptor = new ProblemDescriptorImpl((PsiElement)file, (PsiElement)file, descriptionTemplate, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, null, true);
                NotificationGroup notificationGroup = BALLOON_NOTIFICATIONS;
                String string3 = PyBundle.message("code.insight.type.hints.are.not.installed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                String string4 = PyBundle.message("code.insight.install.type.hints.content", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                notificationGroup.createNotification(string3, string4, NotificationType.INFORMATION).setSuggestionType(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)(plural ? PyBundle.message("code.insight.install.type.hints.action", new Object[0]) : PyBundle.message("python.packaging.install", new Object[0]) + " " + reqsToString), () -> Visitor.processCheckedPackages$lambda$4(this, reqs, args2, module, sdk2, packageManager, project3, problemDescriptor))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)PyBundle.message("code.insight.ignore.type.hints", new Object[0]), () -> Visitor.processCheckedPackages$lambda$5(this, reqs, packageManager, project3, problemDescriptor))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)PyBundle.message("notification.action.edit.settings", new Object[0]), () -> Visitor.processCheckedPackages$lambda$6(project3))).setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST).whenExpired(() -> Visitor.processCheckedPackages$lambda$7(project3)).notify(project3);
            }
            return sourcesToLoad;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> forcedSourcesToProcess(Set<String> sources) {
            void var3_3;
            void $this$filterTo$iv;
            Iterable iterable = sources;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!FORCED.containsKey(it)) continue;
                destination$iv.add(element$iv);
            }
            return (Set)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> checkedSourcesToProcess(Set<String> sources) {
            void var3_3;
            void $this$filterTo$iv;
            Iterable iterable = sources;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!CHECKED.containsKey(it)) continue;
                destination$iv.add(element$iv);
            }
            return (Set)var3_3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Pair<Set<String>, List<PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource>> splitIntoNotCachedAndCached(Set<String> sources, Cache<String, PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource> cache) {
            if (sources.isEmpty()) {
                return TuplesKt.to((Object)SetsKt.emptySet(), (Object)CollectionsKt.emptyList());
            }
            Set notCached = new LinkedHashSet();
            List cached = new ArrayList();
            Cache<String, PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource> cache2 = cache;
            synchronized (cache2) {
                boolean bl = false;
                Iterable $this$forEach$iv = sources;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String source = (String)element$iv;
                    boolean bl2 = false;
                    PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource it = (PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource)cache.getIfPresent((Object)source);
                    boolean bl3 = false;
                    if (it == null) {
                        notCached.add(source);
                        cache.put((Object)source, (Object)PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource.Companion.getEMPTY());
                        continue;
                    }
                    cached.add(it);
                }
                Unit unit = Unit.INSTANCE;
            }
            return TuplesKt.to((Object)notCached, (Object)cached);
        }

        private final Pair<List<PyRequirement>, List<String>> toRequirementsAndExtraArgs(List<PyStubPackagesAdvertiserCache.Companion.StubPackagesForSource> cached, List<? extends PyRequirement> ignoredStubPackages) {
            if (cached.isEmpty()) {
                return TuplesKt.to((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
            }
            List requirements2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)cached), (Function1)toRequirementsAndExtraArgs.requirements.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Pair<? extends String, ? extends List<? extends String>>>, Boolean>(this, ignoredStubPackages){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ List<PyRequirement> $ignoredStubPackages;
                {
                    this.this$0 = $receiver;
                    this.$ignoredStubPackages = $ignoredStubPackages;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Map.Entry<String, ? extends Pair<String, ? extends List<String>>> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Visitor.access$isIgnoredStubPackage(this.this$0, it.getKey(), (String)it.getValue().getFirst(), this.$ignoredStubPackages);
                }
            })), (Function1)toRequirementsAndExtraArgs.requirements.3.INSTANCE));
            if (requirements2.isEmpty()) {
                return TuplesKt.to((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
            }
            Object[] objectArray = new String[]{"--no-deps"};
            Sequence args2 = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)cached), (Function1)toRequirementsAndExtraArgs.args.1.INSTANCE));
            return TuplesKt.to((Object)requirements2, (Object)SequencesKt.toList((Sequence)args2));
        }

        /*
         * WARNING - void declaration
         */
        private final LocalQuickFix createInstallStubPackagesQuickFix(List<? extends PyRequirement> reqs, List<String> args2, Module module, Sdk sdk2, PyPackageManager packageManager) {
            void destination$iv;
            void $this$mapTo$iv;
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Project project3 = project2;
            Iterable iterable = reqs;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                PyRequirement pyRequirement = (PyRequirement)item$iv;
                void var15_14 = destination$iv;
                boolean bl = false;
                var15_14.add(it.getName());
            }
            Set stubPkgNamesToInstall = (Set)destination$iv;
            PyPackageManagerUI.Listener installationListener2 = new PyPackageManagerUI.Listener(project3, stubPkgNamesToInstall, sdk2, this, packageManager){
                final /* synthetic */ Project $project;
                final /* synthetic */ Set<String> $stubPkgNamesToInstall;
                final /* synthetic */ Sdk $sdk;
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ PyPackageManager $packageManager;
                {
                    this.$project = $project;
                    this.$stubPkgNamesToInstall = $stubPkgNamesToInstall;
                    this.$sdk = $sdk;
                    this.this$0 = $receiver;
                    this.$packageManager = $packageManager;
                }

                public void started() {
                    ((PyStubPackagesInstallingStatus)this.$project.getService(PyStubPackagesInstallingStatus.class)).markAsInstalling((Collection<String>)this.$stubPkgNamesToInstall);
                }

                /*
                 * WARNING - void declaration
                 */
                public void finished(@Nullable List<ExecutionException> exceptions) {
                    Collection collection;
                    Collection $this$mapTo$iv$iv;
                    void $this$map$iv;
                    PyStubPackagesInstallingStatus status = (PyStubPackagesInstallingStatus)this.$project.getService(PyStubPackagesInstallingStatus.class);
                    Iterable iterable = PyStubPackagesCompatibilityInspection.Companion.findIncompatibleRuntimeToStubPackages(this.$sdk, (Function1<? super PyPackage, Boolean>)((Function1)new Function1<PyPackage, Boolean>(this.$stubPkgNamesToInstall){
                        final /* synthetic */ Set<String> $stubPkgNamesToInstall;
                        {
                            this.$stubPkgNamesToInstall = $stubPkgNamesToInstall;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull PyPackage it) {
                            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                            return this.$stubPkgNamesToInstall.contains(it.getName());
                        }
                    }));
                    boolean $i$f$map2 = false;
                    void var6_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((PyPackage)((Object)it.getSecond()));
                    }
                    List stubPkgsToUninstall2 = (List)destination$iv$iv;
                    if (!((Collection)stubPkgsToUninstall2).isEmpty()) {
                        void destination$iv;
                        void $this$mapTo$iv;
                        Iterable $i$f$map2 = stubPkgsToUninstall2;
                        $this$mapTo$iv$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv : $this$mapTo$iv) {
                            void it;
                            Object item$iv$iv;
                            item$iv$iv = (PyPackage)((Object)item$iv);
                            collection = destination$iv;
                            boolean bl = false;
                            collection.add(it.getName());
                        }
                        Set stubPkgNamesToUninstall = (Set)destination$iv;
                        PyPackageManagerUI.Listener uninstallationListener2 = new PyPackageManagerUI.Listener(status, stubPkgNamesToUninstall, stubPkgsToUninstall2, this.this$0, this.$project, this.$packageManager){
                            final /* synthetic */ PyStubPackagesInstallingStatus $status;
                            final /* synthetic */ Set<String> $stubPkgNamesToUninstall;
                            final /* synthetic */ List<PyPackage> $stubPkgsToUninstall;
                            final /* synthetic */ Visitor this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ PyPackageManager $packageManager;
                            {
                                this.$status = $status;
                                this.$stubPkgNamesToUninstall = $stubPkgNamesToUninstall;
                                this.$stubPkgsToUninstall = $stubPkgsToUninstall;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$packageManager = $packageManager;
                            }

                            public void started() {
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void finished(@Nullable List<ExecutionException> exceptions) {
                                void $this$mapTo$iv$iv;
                                this.$status.unmarkAsInstalling((Collection<String>)this.$stubPkgNamesToUninstall);
                                Iterable $this$map$iv = this.$stubPkgsToUninstall;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    PyPackage pyPackage = (PyPackage)((Object)item$iv$iv);
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    String string = it.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                    String string2 = it.getVersion();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersion(...)");
                                    collection.add(PyRequirementsKt.pyRequirement(string, PyRequirementRelation.EQ, string2));
                                }
                                List reqsToIgnore = (List)destination$iv$iv;
                                Visitor.access$addStubPackagesToIgnore(this.this$0, reqsToIgnore, this.$stubPkgNamesToUninstall, this.$project, this.$packageManager);
                            }
                        };
                        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)stubPkgNamesToUninstall, null, null, null, (int)0, null, (Function1)createInstallStubPackagesQuickFix.installationListener.finished.content.1.INSTANCE, (int)31, null), stubPkgNamesToUninstall.size()};
                        String string = PyBundle.message("code.insight.stub.packages.ignored.notification.content", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        String content2 = string;
                        PyStubPackagesAdvertiser.access$getBALLOON_NOTIFICATIONS$cp().createNotification(content2, NotificationType.WARNING).notify(this.$project);
                        new PyPackageManagerUI(this.$project, this.$sdk, uninstallationListener2).uninstall(stubPkgsToUninstall2);
                        this.$stubPkgNamesToInstall.removeAll(stubPkgNamesToUninstall);
                    }
                    status.unmarkAsInstalling((Collection<String>)this.$stubPkgNamesToInstall);
                }
            };
            Object[] objectArray = new Object[]{reqs.size()};
            String string = PyBundle.message("code.insight.stub.packages.install.requirements.fix.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String name2 = string;
            return new PyPackageRequirementsInspection.PyInstallRequirementsFix(name2, module, sdk2, reqs, args2, installationListener2);
        }

        private final LocalQuickFix createIgnorePackagesQuickFix(List<? extends PyRequirement> reqs, PyPackageManager packageManager) {
            return new LocalQuickFix(reqs, this, packageManager){
                final /* synthetic */ List<PyRequirement> $reqs;
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ PyPackageManager $packageManager;
                {
                    this.$reqs = $reqs;
                    this.this$0 = $receiver;
                    this.$packageManager = $packageManager;
                }

                @NotNull
                public String getFamilyName() {
                    Object[] objectArray = new Object[]{this.$reqs.size()};
                    String string = PyBundle.message("code.insight.ignore.packages.qfix", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                /*
                 * WARNING - void declaration
                 */
                public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                    void var12_12;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    Iterable iterable = this.$reqs;
                    Collection collection = new LinkedHashSet<E>();
                    List<PyRequirement> list = this.$reqs;
                    Visitor visitor2 = this.this$0;
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void it;
                        PyRequirement pyRequirement = (PyRequirement)item$iv;
                        var12_12 = destination$iv;
                        boolean bl = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        var12_12.add(string);
                    }
                    var12_12 = destination$iv;
                    Visitor.access$addStubPackagesToIgnore(visitor2, list, (Set)var12_12, project2, this.$packageManager);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final void addStubPackagesToIgnore(List<? extends PyRequirement> stubPackages, Set<String> stubPackagesNames, Project project2, PyPackageManager packageManager) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.ignoredPackages.removeIf(arg_0 -> Visitor.addStubPackagesToIgnore$lambda$14((Function1)new Function1<String, Boolean>(stubPackagesNames, packageManager){
                final /* synthetic */ Set<String> $stubPackagesNames;
                final /* synthetic */ PyPackageManager $packageManager;
                {
                    this.$stubPackagesNames = $stubPackagesNames;
                    this.$packageManager = $packageManager;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PyRequirement pyRequirement = this.$packageManager.parseRequirement(it);
                    return CollectionsKt.contains((Iterable)this.$stubPackagesNames, (Object)(pyRequirement != null ? pyRequirement.getName() : null));
                }
            }, arg_0));
            Iterable iterable = stubPackages;
            List<String> list = this.ignoredPackages;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyRequirement pyRequirement = (PyRequirement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getPresentableText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableText(...)");
                collection.add(string);
            }
            list.addAll((List)destination$iv$iv);
            ProjectInspectionProfileManager.Companion.getInstance(project2).fireProfileChanged();
        }

        private final boolean isIgnoredStubPackage(String name2, String version2, List<? extends PyRequirement> ignoredStubPackages) {
            boolean bl;
            block3: {
                PyPackage stubPackage = new PyPackage(name2, version2);
                Iterable $this$any$iv = ignoredStubPackages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PyRequirement it = (PyRequirement)element$iv;
                        boolean bl2 = false;
                        if (!stubPackage.matches(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final void processCheckedPackages$lambda$4(Visitor this$0, List $reqs, List $args, Module $module, Sdk $sdk, PyPackageManager $packageManager, Project $project, ProblemDescriptorImpl $problemDescriptor) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$reqs, (String)"$reqs");
            Intrinsics.checkNotNullParameter((Object)$args, (String)"$args");
            Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
            Intrinsics.checkNotNullParameter((Object)$sdk, (String)"$sdk");
            Intrinsics.checkNotNullParameter((Object)$packageManager, (String)"$packageManager");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$problemDescriptor, (String)"$problemDescriptor");
            this$0.createInstallStubPackagesQuickFix($reqs, $args, $module, $sdk, $packageManager).applyFix($project, (CommonProblemDescriptor)$problemDescriptor);
        }

        private static final void processCheckedPackages$lambda$5(Visitor this$0, List $reqs, PyPackageManager $packageManager, Project $project, ProblemDescriptorImpl $problemDescriptor) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$reqs, (String)"$reqs");
            Intrinsics.checkNotNullParameter((Object)$packageManager, (String)"$packageManager");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$problemDescriptor, (String)"$problemDescriptor");
            this$0.createIgnorePackagesQuickFix($reqs, $packageManager).applyFix($project, (CommonProblemDescriptor)$problemDescriptor);
        }

        private static final void processCheckedPackages$lambda$6(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            InspectionProfileImpl profile = ProjectInspectionProfileManager.Companion.getInstance($project).getCurrentProfile();
            EditInspectionToolsSettingsAction.editToolSettings((Project)$project, (InspectionProfileImpl)profile, (String)Reflection.getOrCreateKotlinClass(PyStubPackagesAdvertiser.class).getSimpleName());
        }

        private static final void processCheckedPackages$lambda$7(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            $project.putUserData(BALLOON_SHOWING, (Object)false);
        }

        private static final boolean addStubPackagesToIgnore$lambda$14(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$isIgnoredStubPackage(Visitor $this, String name2, String version2, List ignoredStubPackages) {
            return $this.isIgnoredStubPackage(name2, version2, ignoredStubPackages);
        }

        public static final /* synthetic */ void access$addStubPackagesToIgnore(Visitor $this, List stubPackages, Set stubPackagesNames, Project project2, PyPackageManager packageManager) {
            $this.addStubPackagesToIgnore(stubPackages, stubPackagesNames, project2, packageManager);
        }
    }
}

