/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.ReferencesCodeVisionProvider;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.codeVision.PyCodeVisionUsageCollector;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/codeInsight/codeVision/PyReferencesCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/ReferencesCodeVisionProvider;", "()V", "id", "", "getId", "()Ljava/lang/String;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "acceptsElement", "", "element", "Lcom/intellij/psi/PsiElement;", "acceptsFile", "file", "Lcom/intellij/psi/PsiFile;", "getHint", "getVisionInfo", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "logClickToFUS", "", "hint", "Companion", "intellij.python.community.impl"})
public final class PyReferencesCodeVisionProvider
extends ReferencesCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "python.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof PyFile;
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        if (element instanceof PyClass && PyUtil.isTopLevel(element)) {
            return true;
        }
        if (element instanceof PyFunction) {
            PyClass containingClass;
            if (!(PyUtil.isTopLevel(element) || (containingClass = ((PyFunction)element).getContainingClass()) != null && PyUtil.isTopLevel(containingClass))) {
                return false;
            }
            String string = ((PyFunction)element).getName();
            if (string == null) {
                return false;
            }
            String elementName = string;
            return !PyUtilCore.isSpecialName(elementName);
        }
        return false;
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(element instanceof PsiNamedElement)) {
            return null;
        }
        String string = ((PsiNamedElement)element).getName();
        if (string == null) {
            return null;
        }
        String elementName = string;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)((PsiNamedElement)element).getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.getInstance((Project)((PsiNamedElement)element).getProject()).isCheapEnoughToSearch(elementName, scope, file, null);
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(...)");
        PsiSearchHelper.SearchCostResult costSearchOutsideCurrentFile = searchCostResult;
        if (costSearchOutsideCurrentFile == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return null;
        }
        AtomicInteger usagesCount = new AtomicInteger();
        AtomicInteger dynamicUsagesCount = new AtomicInteger();
        int limit = AdvancedSettings.Companion.getInt("python.code.vision.usages.limit");
        ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, (SearchScope)scope, false)).allowParallelProcessing().forEach(arg_0 -> PyReferencesCodeVisionProvider.getVisionInfo$lambda$0(element, dynamicUsagesCount, usagesCount, limit, arg_0));
        int result2 = usagesCount.get();
        int dynamicResult = dynamicUsagesCount.get();
        if (result2 == 0 && dynamicResult == 0) {
            return null;
        }
        if (dynamicResult == 0 || result2 > limit) {
            Object[] objectArray = new Object[]{Math.min(result2, limit), result2 > limit ? 1 : 0};
            String string2 = PyBundle.message("inlay.hints.usages.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(result2), result2 <= limit);
        }
        Object[] objectArray = new Object[]{result2, dynamicResult};
        String string3 = PyBundle.message("inlay.hints.usages.with.dynamic.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return new CodeVisionProviderBase.CodeVisionInfo(string3, Integer.valueOf(result2), false, 4, null);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        PyCodeVisionUsageCollector.INSTANCE.logClickToFUS(element);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static final boolean getVisionInfo$lambda$0(PsiElement $element, AtomicInteger $dynamicUsagesCount, AtomicInteger $usagesCount, int $limit, PsiReference it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)$dynamicUsagesCount, (String)"$dynamicUsagesCount");
        Intrinsics.checkNotNullParameter((Object)$usagesCount, (String)"$usagesCount");
        if (it == null) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)((PsiNamedElement)$element).getReference(), (Object)it)) {
            bl = true;
        } else {
            if (new UsageInfo(it).isDynamicUsage()) {
                $dynamicUsagesCount.incrementAndGet();
            }
            bl = $usagesCount.incrementAndGet() <= $limit;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/codeInsight/codeVision/PyReferencesCodeVisionProvider$Companion;", "", "()V", "ID", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

