/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstArgumentList;
import com.jetbrains.python.ast.PyAstAssignmentStatement;
import com.jetbrains.python.ast.PyAstCompoundStatement;
import com.jetbrains.python.ast.PyAstDecoratable;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstQualifiedNameOwner;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.PyAstTargetExpression;
import com.jetbrains.python.ast.PyAstTypeDeclarationStatement;
import com.jetbrains.python.ast.PyAstTypeParameterListOwner;
import com.jetbrains.python.ast.PyAstTypedElement;
import com.jetbrains.python.ast.PyAstWithAncestors;
import com.jetbrains.python.ast.controlFlow.AstScopeOwner;
import com.jetbrains.python.ast.docstring.DocStringUtilCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstClass
extends PsiNameIdentifierOwner,
PyAstCompoundStatement,
PyAstDocStringOwner,
AstScopeOwner,
PyAstDecoratable,
PyAstTypedElement,
PyAstQualifiedNameOwner,
PyAstStatementListContainer,
PyAstWithAncestors,
PyAstTypeParameterListOwner {
    public static final PyAstClass[] EMPTY_ARRAY;
    public static final ArrayFactory<PyAstClass> ARRAY_FACTORY;

    @Nullable
    default public String getName() {
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    @Nullable
    default public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @Nullable
    default public ASTNode getNameNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    @Override
    @NotNull
    default public PyAstStatementList getStatementList() {
        PyAstStatementList statementList = (PyAstStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        if (!1.$assertionsDisabled && statementList == null) {
            throw new AssertionError((Object)("Statement list missing for class " + this.getText()));
        }
        PyAstStatementList pyAstStatementList = statementList;
        if (pyAstStatementList == null) {
            PyAstClass.$$$reportNull$$$0(0);
        }
        return pyAstStatementList;
    }

    @Nullable
    default public PyAstArgumentList getSuperClassExpressionList() {
        PyAstArgumentList argList = (PyAstArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyAstArgumentList.class);
        if (argList != null && argList.getFirstChild() != null) {
            return argList;
        }
        return null;
    }

    public PyAstExpression @NotNull [] getSuperClassExpressions();

    default public List<? extends PyAstTargetExpression> getClassAttributes() {
        ArrayList<PyAstTargetExpression> result2 = new ArrayList<PyAstTargetExpression>();
        for (PsiElement psiElement : this.getStatementList().getChildren()) {
            PyAstExpression target;
            if (psiElement instanceof PyAstAssignmentStatement) {
                PyAstExpression[] targets;
                PyAstAssignmentStatement assignmentStatement = (PyAstAssignmentStatement)psiElement;
                for (PyAstExpression target2 : targets = assignmentStatement.getTargets()) {
                    if (!(target2 instanceof PyAstTargetExpression)) continue;
                    result2.add((PyAstTargetExpression)target2);
                }
                continue;
            }
            if (!(psiElement instanceof PyAstTypeDeclarationStatement) || !((target = ((PyAstTypeDeclarationStatement)psiElement).getTarget()) instanceof PyAstTargetExpression)) continue;
            result2.add((PyAstTargetExpression)target);
        }
        return result2;
    }

    @Nullable
    default public List<String> getOwnSlots() {
        PyAstTargetExpression slots = (PyAstTargetExpression)ContainerUtil.find(this.getClassAttributes(), target -> "__slots__".equals(target.getName()));
        if (slots != null) {
            PyAstExpression value = slots.findAssignedValue();
            return value instanceof PyAstStringLiteralExpression ? Collections.singletonList(((PyAstStringLiteralExpression)value).getStringValue()) : PyUtilCore.strListValue(value);
        }
        return null;
    }

    @Override
    @Nullable
    default public String getDocStringValue() {
        return DocStringUtilCore.getDocStringValue(this);
    }

    @Override
    @Nullable
    default public PyAstStringLiteralExpression getDocStringExpression() {
        return DocStringUtilCore.findDocStringExpression(this.getStatementList());
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyClass(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY_ARRAY = new PyAstClass[0];
        ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PyAstClass[count];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/ast/PyAstClass", "getStatementList"));
    }
}

