/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.minor.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.plugin.minor.facet.MinorPythonFacet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.icons.PythonPsiApiIcons;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MinorPythonFacetType
extends FacetType<MinorPythonFacet, PythonFacetConfiguration> {
    @NonNls
    private static final String ID = "Python";

    public static MinorPythonFacetType getInstance() {
        return (MinorPythonFacetType)MinorPythonFacetType.findInstance(MinorPythonFacetType.class);
    }

    MinorPythonFacetType() {
        super(MinorPythonFacet.ID, ID, PyBundle.message("python.facet.name", new Object[0]));
    }

    public PythonFacetConfiguration createDefaultConfiguration() {
        PythonFacetConfiguration result2 = new PythonFacetConfiguration();
        List sdks2 = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
        if (sdks2.size() > 0) {
            result2.setSdk((Sdk)sdks2.get(0));
        }
        return result2;
    }

    public MinorPythonFacet createFacet(@NotNull Module module, String name2, @NotNull PythonFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            MinorPythonFacetType.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            MinorPythonFacetType.$$$reportNull$$$0(1);
        }
        return new MinorPythonFacet((FacetType)this, module, name2, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return !moduleType.getId().equals("PYTHON_MODULE");
    }

    public Icon getIcon() {
        return PythonPsiApiIcons.Python;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/community/plugin/minor/facet/MinorPythonFacetType";
        objectArray[2] = "createFacet";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PythonFacetConfiguration
    extends PythonFacetSettings
    implements FacetConfiguration {
        private static final String SDK_NAME = "sdkName";

        public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
            return new FacetEditorTab[0];
        }

        public void readExternal(Element element) throws InvalidDataException {
            String sdkName = element.getAttributeValue(SDK_NAME);
            this.mySdk = StringUtil.isEmpty((String)sdkName) ? null : ProjectJdkTable.getInstance().findJdk(sdkName, PythonSdkType.getInstance().getName());
        }

        public void writeExternal(Element element) throws WriteExternalException {
            element.setAttribute(SDK_NAME, this.mySdk == null ? "" : this.mySdk.getName());
        }
    }
}

