/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.documentation;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceEntityBasicApiData;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceURLProvider;
import com.intellij.python.community.impl.huggingFace.documentation.HuggingFaceHtmlBuilder;
import com.intellij.python.community.impl.huggingFace.service.PyHuggingFaceBundle;
import com.jetbrains.python.PythonLanguage;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0087@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceHtmlBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "modelDataApiContent", "Lcom/intellij/python/community/impl/huggingFace/api/HuggingFaceEntityBasicApiData;", "modelCardContent", "", "entityKind", "Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/community/impl/huggingFace/api/HuggingFaceEntityBasicApiData;Ljava/lang/String;Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;)V", "build", "customHeader", "Lcom/intellij/openapi/util/text/HtmlChunk;", "(Lcom/intellij/openapi/util/text/HtmlChunk;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fixCodeBlocks", "htmlText", "generateCardHeader", "modelInfo", "Companion", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHuggingFaceHtmlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuggingFaceHtmlBuilder.kt\ncom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceHtmlBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,108:1\n37#2,2:109\n*S KotlinDebug\n*F\n+ 1 HuggingFaceHtmlBuilder.kt\ncom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceHtmlBuilder\n*L\n70#1:109,2\n*E\n"})
public final class HuggingFaceHtmlBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HuggingFaceEntityBasicApiData modelDataApiContent;
    @NotNull
    private final String modelCardContent;
    @NotNull
    private final HuggingFaceEntityKind entityKind;
    @NotNull
    private static final String NBHP = "&#8209;";
    @NotNull
    private static final HtmlChunk.Element DOWNLOADS_ICON;
    @NotNull
    private static final HtmlChunk.Element LIKES_ICON;
    @NotNull
    private static final Regex PRE_TAG_REGEX;
    @NotNull
    private static final String BR_TAG_REPLACEMENT;

    public HuggingFaceHtmlBuilder(@NotNull Project project2, @NotNull HuggingFaceEntityBasicApiData modelDataApiContent, @Nls @NotNull String modelCardContent, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelDataApiContent, (String)"modelDataApiContent");
        Intrinsics.checkNotNullParameter((Object)modelCardContent, (String)"modelCardContent");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        this.project = project2;
        this.modelDataApiContent = modelDataApiContent;
        this.modelCardContent = modelCardContent;
        this.entityKind = entityKind;
    }

    /*
     * Unable to fully structure code
     */
    @NlsSafe
    @Nullable
    public final Object build(@Nullable HtmlChunk var1_1, @NotNull Continuation<? super String> var2_2) {
        if (!(var2_2 instanceof build.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ HuggingFaceHtmlBuilder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.build(null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                cardHeaderChunk = customHeader == null ? this.generateCardHeader(this.modelDataApiContent) : var1_1;
                $continuation.L$0 = this;
                $continuation.L$1 = cardHeaderChunk;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ HuggingFaceHtmlBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return DocMarkdownToHtmlConverter.convert((Project)HuggingFaceHtmlBuilder.access$getProject$p(this.this$0), (String)HuggingFaceHtmlBuilder.access$getModelCardContent$p(this.this$0), (Language)PythonLanguage.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                cardHeaderChunk = (HtmlChunk)$continuation.L$1;
                this = (HuggingFaceHtmlBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                convertedHtml = (String)v0;
                v1 = HtmlChunk.div().setClass("content").child(HtmlChunk.raw((String)convertedHtml));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"child(...)");
                wrappedBodyContent = v1;
                var8_9 = new HtmlChunk[]{cardHeaderChunk, wrappedBodyContent};
                v2 = HtmlChunk.tag((String)"body").children(var8_9);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"children(...)");
                bodyChunk = v2;
                v3 = HtmlChunk.tag((String)"html").child((HtmlChunk)bodyChunk);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"child(...)");
                htmlContent = v3;
                v4 = htmlContent.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toString(...)");
                htmlString = v4;
                fixedCodeBlocksString = this.fixCodeBlocks(htmlString);
                return fixedCodeBlocksString;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object build$default(HuggingFaceHtmlBuilder huggingFaceHtmlBuilder, HtmlChunk htmlChunk, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            htmlChunk = null;
        }
        return huggingFaceHtmlBuilder.build(htmlChunk, (Continuation<? super String>)continuation);
    }

    private final String fixCodeBlocks(String htmlText) {
        return PRE_TAG_REGEX.replace((CharSequence)htmlText, (Function1)fixCodeBlocks.1.INSTANCE);
    }

    private final HtmlChunk generateCardHeader(HuggingFaceEntityBasicApiData modelInfo) {
        List list;
        HtmlChunk[] htmlChunkArray;
        String cardTitle = StringsKt.replace$default((String)modelInfo.getItemId(), (String)"-", (String)NBHP, (boolean)false, (int)4, null);
        HtmlChunk.Element element = HtmlChunk.tag((String)"h3").child(HtmlChunk.raw((String)cardTitle));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        HtmlChunk.Element modelNameWithIconRow = element;
        if (this.entityKind == HuggingFaceEntityKind.MODEL) {
            modelPurpose = modelInfo.getPipelineTag();
            htmlChunkArray = new HtmlChunk[]{HtmlChunk.text((String)modelPurpose), HtmlChunk.nbsp((int)2)};
            list = CollectionsKt.listOf((Object[])htmlChunkArray);
        } else {
            modelPurpose = new HtmlChunk[]{HtmlChunk.text((String)PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.dataset", new Object[0])), HtmlChunk.nbsp((int)2)};
            list = CollectionsKt.listOf((Object[])modelPurpose);
        }
        List conditionalChunks = list;
        SpreadBuilder spreadBuilder = new SpreadBuilder(9);
        Collection $this$toTypedArray$iv = conditionalChunks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new HtmlChunk[0]));
        Object[] objectArray = new Object[]{modelInfo.getHumanReadableLastUpdated()};
        spreadBuilder.add((Object)HtmlChunk.text((String)PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.updated.suffix", objectArray)));
        spreadBuilder.add((Object)HtmlChunk.nbsp((int)2));
        spreadBuilder.add((Object)DOWNLOADS_ICON);
        spreadBuilder.add((Object)HtmlChunk.text((String)modelInfo.getHumanReadableDownloads()));
        spreadBuilder.add((Object)HtmlChunk.nbsp((int)2));
        spreadBuilder.add((Object)LIKES_ICON);
        spreadBuilder.add((Object)HtmlChunk.raw((String)modelInfo.getHumanReadableLikes()));
        spreadBuilder.add((Object)HtmlChunk.nbsp());
        htmlChunkArray = DocumentationMarkup.GRAYED_ELEMENT.children((HtmlChunk[])spreadBuilder.toArray((Object[])new HtmlChunk[spreadBuilder.size()]));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunkArray, (String)"children(...)");
        HtmlChunk[] modelInfoRow = htmlChunkArray;
        HtmlChunk.Element element2 = HtmlChunk.tag((String)"a").attr("href", HuggingFaceURLProvider.INSTANCE.getEntityCardLink(modelInfo.getItemId(), this.entityKind).toString()).child(HtmlChunk.text((String)PyHuggingFaceBundle.INSTANCE.getMessage("python.hugging.face.open.on.link.text", new Object[0]))).wrapWith("p");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"wrapWith(...)");
        HtmlChunk.Element linkRow = element2;
        HtmlChunk[] htmlChunkArray2 = new HtmlChunk[]{modelNameWithIconRow, modelInfoRow, linkRow};
        HtmlChunk.Element element3 = HtmlChunk.div().setClass("definition").children(htmlChunkArray2);
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"children(...)");
        HtmlChunk.Element headerContainer = element3;
        return (HtmlChunk)headerContainer;
    }

    public static final /* synthetic */ Project access$getProject$p(HuggingFaceHtmlBuilder $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$getModelCardContent$p(HuggingFaceHtmlBuilder $this) {
        return $this.modelCardContent;
    }

    public static final /* synthetic */ String access$getBR_TAG_REPLACEMENT$cp() {
        return BR_TAG_REPLACEMENT;
    }

    static {
        HtmlChunk.Element element = HtmlChunk.tag((String)"icon").attr("src", "AllIcons.Plugins.Downloads");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attr(...)");
        DOWNLOADS_ICON = element;
        HtmlChunk.Element element2 = HtmlChunk.tag((String)"icon").attr(".src", "AllIcons.Plugins.Rating");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"attr(...)");
        LIKES_ICON = element2;
        Object[] objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        PRE_TAG_REGEX = new Regex("<pre><code>(.*?)</code></pre>", SetsKt.setOf((Object[])objectArray));
        BR_TAG_REPLACEMENT = "<wbr>" + System.lineSeparator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceHtmlBuilder$Companion;", "", "()V", "BR_TAG_REPLACEMENT", "", "DOWNLOADS_ICON", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "LIKES_ICON", "NBHP", "PRE_TAG_REGEX", "Lkotlin/text/Regex;", "intellij.python.community.impl.huggingFace"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

