/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.annotation.HuggingFaceIdentifierPsiElement;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceDatasetsCache;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceModelsCache;
import com.intellij.python.community.impl.huggingFace.service.PyHuggingFaceBundle;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPlainStringElementImpl;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/community/impl/huggingFace/HuggingFaceUtil;", "", "()V", "extractStringAndKindFromStringLiteralExpression", "Lkotlin/Pair;", "", "Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "stringValue", "extractStringValueAndEntityKindFromElement", "element", "Lcom/intellij/psi/PsiElement;", "extractTextFromPyTargetExpression", "pyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "humanReadableNumber", "rawNumber", "", "isHuggingFaceDataset", "", "text", "isHuggingFaceEntity", "isHuggingFaceModel", "isWhatHuggingFaceEntity", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHuggingFaceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuggingFaceUtil.kt\ncom/intellij/python/community/impl/huggingFace/HuggingFaceUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class HuggingFaceUtil {
    @NotNull
    public static final HuggingFaceUtil INSTANCE = new HuggingFaceUtil();

    private HuggingFaceUtil() {
    }

    @Nullable
    public final HuggingFaceEntityKind isWhatHuggingFaceEntity(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.isHuggingFaceModel(text) ? HuggingFaceEntityKind.MODEL : (this.isHuggingFaceDataset(text) ? HuggingFaceEntityKind.DATASET : null);
    }

    private final boolean isHuggingFaceModel(String text) {
        return HuggingFaceModelsCache.INSTANCE.isInCache(text);
    }

    private final boolean isHuggingFaceDataset(String text) {
        return HuggingFaceDatasetsCache.INSTANCE.isInCache(text);
    }

    public final boolean isHuggingFaceEntity(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.isHuggingFaceModel(text) || this.isHuggingFaceDataset(text);
    }

    @NlsSafe
    @NotNull
    public final String extractTextFromPyTargetExpression(@NotNull PyTargetExpression pyTargetExpression) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)pyTargetExpression, (String)"pyTargetExpression");
        PsiElement parent = pyTargetExpression.getParent();
        if (parent instanceof PyAssignmentStatement) {
            PyExpression pyExpression = ((PyAssignmentStatement)parent).getAssignedValue();
            Object object2 = pyExpression instanceof PyStringLiteralExpression ? (PyStringLiteralExpression)pyExpression : null;
            if (object2 == null || (object2 = object2.getStringValue()) == null) {
                object2 = PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.default.value", new Object[0]);
            }
            Object object3 = object2;
            Intrinsics.checkNotNull((Object)object3);
            object = object3;
        } else {
            object = PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.default.value", new Object[0]);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<String, HuggingFaceEntityKind> extractStringAndKindFromStringLiteralExpression(String stringValue) {
        String string;
        String string2 = stringValue;
        HuggingFaceEntityKind entityKind = string2 != null ? this.isWhatHuggingFaceEntity(string2) : null;
        String string3 = stringValue;
        String string4 = string3;
        if (string3 == null) return null;
        String it = string = string4;
        boolean bl = false;
        if (entityKind == null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string5 = string;
        string4 = string5;
        if (string5 == null) return null;
        it = string4;
        boolean bl3 = false;
        HuggingFaceEntityKind huggingFaceEntityKind = entityKind;
        Intrinsics.checkNotNull((Object)((Object)huggingFaceEntityKind));
        Pair pair = new Pair((Object)it, (Object)huggingFaceEntityKind);
        return pair;
    }

    @Nullable
    public final Pair<String, HuggingFaceEntityKind> extractStringValueAndEntityKindFromElement(@NotNull PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent = element.getParent();
        if (parent instanceof PyAssignmentStatement) {
            if (element instanceof PyTargetExpression) {
                PyExpression pyExpression = ((PyAssignmentStatement)parent).getAssignedValue();
                PyStringLiteralExpression pyStringLiteralExpression = pyExpression instanceof PyStringLiteralExpression ? (PyStringLiteralExpression)pyExpression : null;
                String stringValue = pyStringLiteralExpression != null ? pyStringLiteralExpression.getStringValue() : null;
                object = this.extractStringAndKindFromStringLiteralExpression(stringValue);
            } else {
                object = null;
            }
        } else {
            PsiElement psiElement;
            object = parent instanceof PyStringLiteralExpression ? ((psiElement = element) instanceof HuggingFaceIdentifierPsiElement ? new Pair<String, HuggingFaceEntityKind>((Object)((HuggingFaceIdentifierPsiElement)element).getEntityName(), (Object)((HuggingFaceIdentifierPsiElement)element).getEntityKind()) : (psiElement instanceof PyPlainStringElementImpl ? this.extractStringAndKindFromStringLiteralExpression(((PyStringLiteralExpression)parent).getStringValue()) : null)) : (parent instanceof PyArgumentList ? (element instanceof PyStringLiteralExpression ? this.extractStringAndKindFromStringLiteralExpression(((PyStringLiteralExpression)element).getStringValue()) : null) : null);
        }
        return object;
    }

    @NotNull
    public final String humanReadableNumber(int rawNumber) {
        int i;
        if (rawNumber < 1000) {
            return String.valueOf(rawNumber);
        }
        String[] stringArray = new String[]{"K", "M", "B", "T"};
        String[] suffixes = stringArray;
        double count = rawNumber;
        for (i = 0; i < suffixes.length && count >= 1000.0; count /= (double)1000, ++i) {
        }
        String string = "%.1f%s";
        Object[] objectArray = new Object[]{count, suffixes[i - 1]};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

