/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.settings;

import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.Utils;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigExportProviderEP;
import org.editorconfig.settings.EditorConfigListener;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/editorconfig/settings/EditorConfigConfigurable;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsProvider;", "Lcom/intellij/application/options/GeneralCodeStyleOptionsProvider;", "()V", "myEnabled", "Ljavax/swing/JCheckBox;", "apply", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "createComponent", "Ljavax/swing/JComponent;", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "disposeUIResources", "hasSettingsPage", "", "isModified", "reset", "intellij.editorconfig"})
public final class EditorConfigConfigurable
extends CodeStyleSettingsProvider
implements GeneralCodeStyleOptionsProvider {
    private JCheckBox myEnabled;

    @NotNull
    public JComponent createComponent() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ EditorConfigConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EditorConfigConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        EditorConfigConfigurable.access$setMyEnabled$p(this.this$0, (JCheckBox)Cell.comment$default((Cell)$this$row.checkBox(EditorConfigBundle.message("config.enable")), (String)EditorConfigBundle.message("config.warning"), (int)0, null, (int)6, null).getComponent());
                        if (EditorConfigExportProviderEP.shouldShowExportButton()) {
                            $this$row.button(EditorConfigBundle.message("config.export"), (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                final /* synthetic */ EditorConfigConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull ActionEvent it) {
                                    Project project;
                                    Component parent;
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    JCheckBox jCheckBox = EditorConfigConfigurable.access$getMyEnabled$p(this.this$0);
                                    if (jCheckBox == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"myEnabled");
                                        jCheckBox = null;
                                    }
                                    if ((parent = UIUtil.findUltimateParent((Component)jCheckBox)) instanceof IdeFrame && (project = ((IdeFrame)parent).getProject()) != null) {
                                        if (EditorConfigExportProviderEP.tryExportViaProviders(project)) {
                                            return;
                                        }
                                        Utils.INSTANCE.export(project);
                                    }
                                }
                            });
                        }
                    }
                }), (int)1, null);
            }
        }));
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JCheckBox jCheckBox = this.myEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEnabled");
            jCheckBox = null;
        }
        return jCheckBox.isSelected() != ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED;
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        boolean newValue;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JCheckBox jCheckBox = this.myEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEnabled");
            jCheckBox = null;
        }
        ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED = newValue = jCheckBox.isSelected();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus bus = messageBus;
        Topic<EditorConfigListener> topic = EditorConfigSettings.EDITOR_CONFIG_ENABLED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"EDITOR_CONFIG_ENABLED_TOPIC");
        ((EditorConfigListener)bus.syncPublisher(topic)).valueChanged(newValue);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JCheckBox jCheckBox = this.myEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEnabled");
            jCheckBox = null;
        }
        jCheckBox.setSelected(((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED);
    }

    public void disposeUIResources() {
    }

    public boolean isModified() {
        return false;
    }

    public void apply() {
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new EditorConfigSettings(settings);
    }

    public static final /* synthetic */ void access$setMyEnabled$p(EditorConfigConfigurable $this, JCheckBox jCheckBox) {
        $this.myEnabled = jCheckBox;
    }

    public static final /* synthetic */ JCheckBox access$getMyEnabled$p(EditorConfigConfigurable $this) {
        return $this.myEnabled;
    }
}

