/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import dk.brics.automaton.Automaton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.core.EditorConfigAutomatonBuilder;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Log", "Lcom/intellij/openapi/diagnostic/Logger;", "isEquivalentTo", "", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "other", "isSubcaseOf", "general", "Lorg/editorconfig/language/psi/EditorConfigPattern;", "generalAutomaton", "Ldk/brics/automaton/Automaton;", "matches", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "string", "", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigGlobUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigGlobUtils.kt\norg/editorconfig/language/util/EditorConfigGlobUtilsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n11#2:52\n*S KotlinDebug\n*F\n+ 1 EditorConfigGlobUtils.kt\norg/editorconfig/language/util/EditorConfigGlobUtilsKt\n*L\n50#1:52\n*E\n"})
public final class EditorConfigGlobUtilsKt {
    @NotNull
    private static final Logger Log;

    public static final boolean isSubcaseOf(@NotNull EditorConfigHeader $this$isSubcaseOf, @NotNull EditorConfigHeader general) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubcaseOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (!$this$isSubcaseOf.isValidGlob()) {
            return false;
        }
        if (!general.isValidGlob()) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($this$isSubcaseOf);
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(general);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean isEquivalentTo(@NotNull EditorConfigHeader $this$isEquivalentTo, @NotNull EditorConfigHeader other) {
        Intrinsics.checkNotNullParameter((Object)$this$isEquivalentTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!$this$isEquivalentTo.getHeader().isValidGlob()) {
            return false;
        }
        if (!other.getHeader().isValidGlob()) {
            return false;
        }
        Automaton thisAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($this$isEquivalentTo);
        Automaton otherAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(other);
        return Intrinsics.areEqual((Object)thisAutomaton, (Object)otherAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $this$isSubcaseOf, @NotNull EditorConfigPattern general) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubcaseOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (!general.getHeader().isValidGlob()) {
            return false;
        }
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton(general);
        return EditorConfigGlobUtilsKt.isSubcaseOf($this$isSubcaseOf, generalAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $this$isSubcaseOf, @NotNull Automaton generalAutomaton) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubcaseOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)generalAutomaton, (String)"generalAutomaton");
        if (!$this$isSubcaseOf.getHeader().isValidGlob()) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton($this$isSubcaseOf);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $this$matches, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Log.assertTrue($this$matches.getHeader().isValidGlob());
        EditorConfigHeader editorConfigHeader = $this$matches.getSection().getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
        return EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderRunAutomaton(editorConfigHeader).run(string);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $this$matches, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Log.assertTrue($this$matches.getHeader().isValidGlob());
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return EditorConfigGlobUtilsKt.matches($this$matches, string);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigHeader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Log = logger;
    }
}

