/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.language.codeinsight.completion.providers.EditorConfigCompletionProviderUtil;
import org.editorconfig.language.extensions.EditorConfigOptionDescriptorProvider;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigOptionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigQualifiedKeyDescriptor;
import org.editorconfig.language.services.EditorConfigOptionDescriptorManager;
import org.editorconfig.language.services.impl.EditorConfigOptionDescriptorManagerImpl;
import org.editorconfig.language.services.impl.EditorConfigOptionDescriptorStorage;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.editorconfig.language.util.EditorConfigTemplateUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigOptionDescriptorManagerImpl;", "Lorg/editorconfig/language/services/EditorConfigOptionDescriptorManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedAllDumbDescriptors", "Ljava/lang/ref/Reference;", "", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigOptionDescriptor;", "cachedDumbQualifiedKeys", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigQualifiedKeyDescriptor;", "cachedDumbSimpleKeys", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "cachedSmartQualifiedKeys", "cachedSmartSimpleKeys", "declarationDescriptorsCache", "", "", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigDeclarationDescriptor;", "fullySupportedDescriptors", "Lorg/editorconfig/language/services/impl/EditorConfigOptionDescriptorStorage;", "partiallySupportedDescriptors", "requiredDeclarationDescriptorsCache", "getDeclarationDescriptors", "id", "getOptionDescriptor", "key", "Lcom/intellij/psi/PsiElement;", "parts", "smart", "", "getOptionDescriptors", "getQualifiedKeyDescriptors", "getRequiredDeclarationDescriptors", "getSimpleKeyDescriptors", "loadDescriptors", "", "Companion", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigOptionDescriptorManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigOptionDescriptorManagerImpl.kt\norg/editorconfig/language/services/impl/EditorConfigOptionDescriptorManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1855#2,2:145\n1360#2:148\n1446#2,5:149\n766#2:154\n857#2,2:155\n1#3:147\n*S KotlinDebug\n*F\n+ 1 EditorConfigOptionDescriptorManagerImpl.kt\norg/editorconfig/language/services/impl/EditorConfigOptionDescriptorManagerImpl\n*L\n63#1:145,2\n115#1:148\n115#1:149,5\n124#1:154\n124#1:155,2\n*E\n"})
public final class EditorConfigOptionDescriptorManagerImpl
implements EditorConfigOptionDescriptorManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EditorConfigOptionDescriptorStorage fullySupportedDescriptors;
    @NotNull
    private EditorConfigOptionDescriptorStorage partiallySupportedDescriptors;
    @NotNull
    private final Map<String, List<EditorConfigDeclarationDescriptor>> requiredDeclarationDescriptorsCache;
    @NotNull
    private final Map<String, List<EditorConfigDeclarationDescriptor>> declarationDescriptorsCache;
    @NotNull
    private Reference<List<EditorConfigQualifiedKeyDescriptor>> cachedSmartQualifiedKeys;
    @NotNull
    private Reference<List<EditorConfigQualifiedKeyDescriptor>> cachedDumbQualifiedKeys;
    @NotNull
    private Reference<List<EditorConfigDescriptor>> cachedSmartSimpleKeys;
    @NotNull
    private Reference<List<EditorConfigDescriptor>> cachedDumbSimpleKeys;
    @NotNull
    private Reference<List<EditorConfigOptionDescriptor>> cachedAllDumbDescriptors;
    @NotNull
    private static final Logger logger;

    public EditorConfigOptionDescriptorManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.fullySupportedDescriptors = new EditorConfigOptionDescriptorStorage(CollectionsKt.emptyList());
        this.partiallySupportedDescriptors = new EditorConfigOptionDescriptorStorage(CollectionsKt.emptyList());
        this.requiredDeclarationDescriptorsCache = new LinkedHashMap();
        this.declarationDescriptorsCache = new LinkedHashMap();
        this.cachedSmartQualifiedKeys = new SoftReference<Object>(null);
        this.cachedDumbQualifiedKeys = new SoftReference<Object>(null);
        this.cachedSmartSimpleKeys = new SoftReference<Object>(null);
        this.cachedDumbSimpleKeys = new SoftReference<Object>(null);
        this.cachedAllDumbDescriptors = new SoftReference<Object>(null);
        this.loadDescriptors(project);
    }

    @TestOnly
    public final void loadDescriptors(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        long start = System.currentTimeMillis();
        List fullySupportedDescriptors = new ArrayList();
        List partiallySupportedDescriptors = new ArrayList();
        Iterable $this$forEach$iv = EditorConfigOptionDescriptorProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorConfigOptionDescriptorProvider p0 = (EditorConfigOptionDescriptorProvider)element$iv;
            boolean bl = false;
            EditorConfigOptionDescriptorManagerImpl.loadDescriptors$loadDescriptors(project, fullySupportedDescriptors, partiallySupportedDescriptors, p0);
        }
        this.fullySupportedDescriptors = new EditorConfigOptionDescriptorStorage(fullySupportedDescriptors);
        this.partiallySupportedDescriptors = new EditorConfigOptionDescriptorStorage(partiallySupportedDescriptors);
        this.requiredDeclarationDescriptorsCache.clear();
        this.declarationDescriptorsCache.clear();
        this.cachedSmartQualifiedKeys.clear();
        this.cachedDumbQualifiedKeys.clear();
        this.cachedSmartSimpleKeys.clear();
        this.cachedDumbSimpleKeys.clear();
        this.cachedAllDumbDescriptors.clear();
        logger.debug("Loading EditorConfig option descriptors took " + (System.currentTimeMillis() - start) + " ms");
    }

    @Override
    @Nullable
    public EditorConfigOptionDescriptor getOptionDescriptor(@NotNull PsiElement key, @NotNull List<String> parts, boolean smart) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        EditorConfigOptionDescriptor editorConfigOptionDescriptor = this.fullySupportedDescriptors.get(key, parts);
        if (editorConfigOptionDescriptor != null) {
            EditorConfigOptionDescriptor it = editorConfigOptionDescriptor;
            boolean bl = false;
            return it;
        }
        if (smart) {
            return null;
        }
        return this.partiallySupportedDescriptors.get(key, parts);
    }

    @Override
    @NotNull
    public List<EditorConfigDescriptor> getSimpleKeyDescriptors(boolean smart) {
        List<EditorConfigDescriptor> cached;
        Reference<List<EditorConfigDescriptor>> cache = smart ? this.cachedSmartSimpleKeys : this.cachedDumbSimpleKeys;
        List<EditorConfigDescriptor> list = cached = cache.get();
        if (list != null) {
            return list;
        }
        List result2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getOptionDescriptors(true)), (Function1)((Function1)getSimpleKeyDescriptors.result.1.INSTANCE)), (Function1)((Function1)new Function1<EditorConfigDescriptor, Boolean>((Object)EditorConfigCompletionProviderUtil.INSTANCE){

            @NotNull
            public final Boolean invoke(@NotNull EditorConfigDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((EditorConfigCompletionProviderUtil)this.receiver).isSimple(p0);
            }
        })));
        SoftReference<List> newCache = new SoftReference<List>(result2);
        if (smart) {
            this.cachedSmartSimpleKeys = newCache;
        } else {
            this.cachedDumbSimpleKeys = newCache;
        }
        return result2;
    }

    private final List<EditorConfigOptionDescriptor> getOptionDescriptors(boolean smart) {
        if (smart) {
            return this.fullySupportedDescriptors.getAllDescriptors();
        }
        List<EditorConfigOptionDescriptor> cached = this.cachedAllDumbDescriptors.get();
        if (cached != null) {
            return cached;
        }
        List result2 = CollectionsKt.plus((Collection)this.fullySupportedDescriptors.getAllDescriptors(), (Iterable)this.partiallySupportedDescriptors.getAllDescriptors());
        this.cachedAllDumbDescriptors = new SoftReference<List>(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<EditorConfigDeclarationDescriptor> getDeclarationDescriptors(@NotNull String id) {
        void $this$flatMapTo$iv$iv;
        List<EditorConfigDeclarationDescriptor> cachedResult;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<EditorConfigDeclarationDescriptor> list = cachedResult = this.declarationDescriptorsCache.get(id);
        if (list != null) {
            return list;
        }
        List<EditorConfigOptionDescriptor> allDescriptors = this.getOptionDescriptors(false);
        Iterable $this$flatMap$iv = allDescriptors;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EditorConfigOptionDescriptor it = (EditorConfigOptionDescriptor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = EditorConfigDescriptorUtil.INSTANCE.collectDeclarations(it, id);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List declarationDescriptors = (List)destination$iv$iv;
        this.declarationDescriptorsCache.put(id, declarationDescriptors);
        return declarationDescriptors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<EditorConfigDeclarationDescriptor> getRequiredDeclarationDescriptors(@NotNull String id) {
        void $this$filterTo$iv$iv;
        List<EditorConfigDeclarationDescriptor> cachedResult;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<EditorConfigDeclarationDescriptor> list = cachedResult = this.requiredDeclarationDescriptorsCache.get(id);
        if (list != null) {
            return list;
        }
        List<EditorConfigDeclarationDescriptor> declarationDescriptors = this.getDeclarationDescriptors(id);
        Iterable $this$filter$iv = declarationDescriptors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorConfigDeclarationDescriptor p0 = (EditorConfigDeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!p0.isRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List required = (List)destination$iv$iv;
        this.requiredDeclarationDescriptorsCache.put(id, required);
        return required;
    }

    @Override
    @NotNull
    public List<EditorConfigQualifiedKeyDescriptor> getQualifiedKeyDescriptors(boolean smart) {
        Reference<List<EditorConfigQualifiedKeyDescriptor>> cache = smart ? this.cachedSmartQualifiedKeys : this.cachedDumbQualifiedKeys;
        List<EditorConfigQualifiedKeyDescriptor> list = cache.get();
        if (list != null) {
            List<EditorConfigQualifiedKeyDescriptor> it = list;
            boolean bl = false;
            return it;
        }
        List result2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getOptionDescriptors(smart)), (Function1)getQualifiedKeyDescriptors.result.1.INSTANCE), (Function1)((Function1)new Function1<EditorConfigQualifiedKeyDescriptor, Boolean>((Object)EditorConfigTemplateUtil.INSTANCE){

            @NotNull
            public final Boolean invoke(@NotNull EditorConfigQualifiedKeyDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((EditorConfigTemplateUtil)this.receiver).startsWithVariable(p0);
            }
        })), (Function1)((Function1)new Function1<EditorConfigQualifiedKeyDescriptor, Boolean>((Object)EditorConfigTemplateUtil.INSTANCE){

            @NotNull
            public final Boolean invoke(@NotNull EditorConfigQualifiedKeyDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((EditorConfigTemplateUtil)this.receiver).checkStructuralConsistency(p0);
            }
        })));
        SoftReference<List> newCache = new SoftReference<List>(result2);
        if (smart) {
            this.cachedSmartQualifiedKeys = newCache;
        } else {
            this.cachedDumbQualifiedKeys = newCache;
        }
        return result2;
    }

    private static final void loadDescriptors$loadDescriptors(Project $project, List<EditorConfigOptionDescriptor> fullySupportedDescriptors, List<EditorConfigOptionDescriptor> partiallySupportedDescriptors, EditorConfigOptionDescriptorProvider provider) {
        boolean requiresFullSupport = provider.requiresFullSupport();
        List<EditorConfigOptionDescriptor> loadedDescriptors = provider.getOptionDescriptors($project);
        List<EditorConfigOptionDescriptor> destination = requiresFullSupport ? fullySupportedDescriptors : partiallySupportedDescriptors;
        destination.addAll((Collection<EditorConfigOptionDescriptor>)loadedDescriptors);
    }

    static {
        Logger logger = Logger.getInstance(EditorConfigOptionDescriptorManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EditorConfigOptionDescriptorManagerImpl.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigOptionDescriptorManagerImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.editorconfig"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

