/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.data.IgnoredStorage;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;

public class AnnotationIgnoredMethodFilter
extends CoverageFilter {
    private boolean myShouldIgnore;

    /*
     * WARNING - void declaration
     */
    public boolean isApplicable(InstrumentationData context) {
        void var1_1;
        List<Pattern> annotations = context.get(Key.PROJECT_DATA).getAnnotationsToIgnore();
        return annotations != null && !var1_1.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        void var3_3;
        String annotationName = ClassNameUtil.convertVMNameToFQN(descriptor);
        if (!this.myShouldIgnore && ClassNameUtil.matchesPatterns((String)var3_3, this.myContext.get(Key.PROJECT_DATA).getAnnotationsToIgnore())) {
            this.myContext.setIgnoreSection(true);
            this.myShouldIgnore = true;
        }
        return super.visitAnnotation((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitCode() {
        String originalSig;
        int index;
        super.visitCode();
        IgnoredStorage ignoredStorage = this.myContext.get(Key.PROJECT_DATA).getIgnoredStorage();
        String methodName = this.myContext.getMethodName();
        if (!this.myShouldIgnore && methodName.endsWith("$default") && (index = (originalSig = KotlinDefaultArgsBranchFilter.getOriginalNameAndDesc(methodName, this.myContext.getMethodDesc())).indexOf(40)) > 0) {
            void var3_3;
            String originalName = originalSig.substring(0, index);
            String originalDesc = originalSig.substring(index);
            if (ignoredStorage.isMethodIgnored(this.myContext.get(Key.CLASS_NAME), originalName, (String)var3_3)) {
                this.myContext.setIgnoreSection(true);
                this.myShouldIgnore = true;
            }
        }
        if (this.myShouldIgnore) {
            void var2_2;
            void var1_1;
            var1_1.addIgnoredMethod(this.myContext.get(Key.CLASS_NAME), (String)var2_2, this.myContext.getMethodDesc());
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
    }
}

