/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.RectanglePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.LearningUiHighlightingManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltraining/ui/LearningHighlightPainter;", "Lcom/intellij/openapi/ui/AbstractPainter;", "startDate", "Ljava/util/Date;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "bounds", "Ljava/awt/Rectangle;", "(Ljava/util/Date;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Ljava/awt/Rectangle;)V", "previous", "", "pulsationOffset", "", "executePaint", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "needsRepaint", "", "intellij.featuresTrainer"})
public final class LearningHighlightPainter
extends AbstractPainter {
    @NotNull
    private final Date startDate;
    @NotNull
    private final LearningUiHighlightingManager.HighlightingOptions options;
    @NotNull
    private final Rectangle bounds;
    private final int pulsationOffset;
    private long previous;

    public LearningHighlightPainter(@NotNull Date startDate, @NotNull LearningUiHighlightingManager.HighlightingOptions options, @NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.startDate = startDate;
        this.options = options;
        this.bounds = bounds;
        this.pulsationOffset = this.options.getUsePulsation() ? 20 : 0;
    }

    public void executePaint(@Nullable Component component2, @Nullable Graphics2D g) {
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = g;
        Rectangle r = this.bounds;
        Color oldColor = g2d.getColor();
        long time = new Date().getTime();
        long delta = time - this.startDate.getTime();
        this.previous = time;
        int shift = this.pulsationOffset != 0 && delta / (long)1000 % (long)4 == 2L ? (int)Math.abs((delta / (long)25 + (long)20) % (long)40 - (long)20) : 0;
        double alphaCycle = (double)LearningHighlightPainter.executePaint$cyclicNumber(1000, delta) / (double)1000;
        Color color = ColorUtil.withAlpha((Color)Color.magenta, (double)0.8);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"withAlpha(...)");
        Color magenta = color;
        Color color2 = ColorUtil.withAlpha((Color)Color.orange, (double)0.8);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"withAlpha(...)");
        Color orange = color2;
        Color color3 = ColorUtil.withAlpha((Color)((Color)new JBColor(new Color(0, 0, shift * 10), new Color(255 - shift * 10, 255 - shift * 10, 255))), (double)((0.3 + 0.7 * (double)shift / 20.0) * alphaCycle));
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"withAlpha(...)");
        Color background = color3;
        float gradientShift = delta / (long)20;
        GradientPaint gp = new GradientPaint(gradientShift + 0.0f, gradientShift + 0.0f, magenta, gradientShift + (float)r.height, gradientShift + (float)r.height, orange, true);
        int x = r.x + this.pulsationOffset - shift;
        int y2 = r.y + this.pulsationOffset - shift;
        int width = r.width - (this.pulsationOffset - shift) * 2;
        int height = r.height - (this.pulsationOffset - shift) * 2;
        RectanglePainter.paint((Graphics2D)g2d, (int)x, (int)y2, (int)width, (int)height, (int)2, (Paint)(this.options.getHighlightInside() ? background : null), (Paint)(this.options.getHighlightBorder() ? gp : null));
        g2d.setColor(oldColor);
    }

    public boolean needsRepaint() {
        return true;
    }

    private static final int executePaint$cyclicNumber(int amplitude, long change) {
        return (int)Math.abs(change % (long)(2 * amplitude) - (long)amplitude);
    }
}

