/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.TipAndTrickManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.exceptons.NoSdkException;
import training.project.ProjectUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00060\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltraining/learn/NewLearnProjectUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createLearnProject", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "langSupport", "Ltraining/lang/LangSupport;", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "showDialogOpenLearnProject", "", "project", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nNewLearnProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewLearnProjectUtil.kt\ntraining/learn/NewLearnProjectUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n11#2:62\n*S KotlinDebug\n*F\n+ 1 NewLearnProjectUtil.kt\ntraining/learn/NewLearnProjectUtil\n*L\n18#1:62\n*E\n"})
public final class NewLearnProjectUtil {
    @NotNull
    public static final NewLearnProjectUtil INSTANCE = new NewLearnProjectUtil();
    @NotNull
    private static final Logger LOG;

    private NewLearnProjectUtil() {
    }

    public final void createLearnProject(@Nullable Project projectToClose, @NotNull LangSupport langSupport2, @Nullable Sdk selectedSdk, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        if (langSupport2.getUseUserProjects()) {
            throw new IllegalStateException(("Language support for " + langSupport2.getPrimaryLanguage() + " cannot create learning project.").toString());
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        ProjectUtils.INSTANCE.importOrOpenProject(langSupport2, projectToClose, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(langSupport2, selectedSdk, unitTestMode, postInitCallback){
            final /* synthetic */ LangSupport $langSupport;
            final /* synthetic */ Sdk $selectedSdk;
            final /* synthetic */ boolean $unitTestMode;
            final /* synthetic */ Function1<Project, Unit> $postInitCallback;
            {
                this.$langSupport = $langSupport;
                this.$selectedSdk = $selectedSdk;
                this.$unitTestMode = $unitTestMode;
                this.$postInitCallback = $postInitCallback;
                super(1);
            }

            public final void invoke(@NotNull Project newProject) {
                Intrinsics.checkNotNullParameter((Object)newProject, (String)"newProject");
                TipAndTrickManager.Companion.getDISABLE_TIPS_FOR_PROJECT().set((UserDataHolder)newProject, (Object)true);
                CodeStyle.setMainProjectSettings((Project)newProject, (CodeStyleSettings)CodeStyleSettings.getDefaults());
                try {
                    Sdk sdkForProject = this.$langSupport.getSdkForProject(newProject, this.$selectedSdk);
                    if (sdkForProject != null) {
                        this.$langSupport.applyProjectSdk(sdkForProject, newProject);
                    }
                }
                catch (NoSdkException e) {
                    NewLearnProjectUtil.access$getLOG$p().error((Throwable)e);
                }
                if (!this.$unitTestMode) {
                    newProject.save();
                }
                newProject.save();
                this.$postInitCallback.invoke((Object)newProject);
            }
        }));
    }

    public final boolean showDialogOpenLearnProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getFullProductName(), (String)"getFullProductName(...)");
        return Messages.showOkCancelDialog((Project)project, (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.title", new Object[0]), (String)LearnBundle.INSTANCE.message("dialog.learnProjectWarning.ok", new Object[0]), (String)Messages.getCancelButton(), null) == 0;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NewLearnProjectUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

