/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.util.IterableUtil;

public abstract class AbstractComparisonStrategy
implements ComparisonStrategy {
    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        if (IterableUtil.isNullOrEmpty(iterable)) {
            return Collections.EMPTY_SET;
        }
        Set<Object> duplicates = this.newSetUsingComparisonStrategy();
        Set<Object> noDuplicates = this.newSetUsingComparisonStrategy();
        for (Object element2 : iterable) {
            if (noDuplicates.contains(element2)) {
                duplicates.add(element2);
                continue;
            }
            noDuplicates.add(element2);
        }
        return duplicates;
    }

    protected abstract Set<Object> newSetUsingComparisonStrategy();

    @Override
    public boolean arrayContains(Object array, Object value) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element2 = Array.get(array, i);
            if (!this.areEqual(element2, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        return !this.areEqual(actual, other) && !this.isGreaterThan(actual, other);
    }

    @Override
    public boolean isLessThanOrEqualTo(Object actual, Object other) {
        return this.areEqual(actual, other) || this.isLessThan(actual, other);
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Object actual, Object other) {
        return this.areEqual(actual, other) || this.isGreaterThan(actual, other);
    }

    @Override
    public boolean isStandard() {
        return false;
    }
}

