/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.commands.CorruptIndexesCommand;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/performancePlugin/commands/CorruptIndexesCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "corruptFile", "", "file", "Ljava/io/File;", "corruptFilesInDir", "dir", "Ljava/nio/file/Path;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCorruptIndexesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorruptIndexesCommand.kt\ncom/jetbrains/performancePlugin/commands/CorruptIndexesCommand\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,53:1\n37#2,2:54\n1313#3,2:56\n11#4:58\n*S KotlinDebug\n*F\n+ 1 CorruptIndexesCommand.kt\ncom/jetbrains/performancePlugin/commands/CorruptIndexesCommand\n*L\n24#1:54,2\n44#1:56,2\n19#1:58\n*E\n"})
public final class CorruptIndexesCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%corruptIndex";
    @NotNull
    private static final Logger LOG;

    public CorruptIndexesCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Object object = string;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] args = thisCollection$iv.toArray(new String[0]);
        Path path = switch (args.length) {
            case 2 -> Paths.get(args[1], new String[0]);
            case 3 -> {
                String[] var6_7 = new String[]{args[2]};
                yield Paths.get(args[1], var6_7);
            }
            default -> throw new IllegalStateException("There are more than 2 args".toString());
        };
        if (path.toFile().isFile()) {
            LOG.info("Corrupting file: " + path);
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.corruptFile(file);
        } else {
            LOG.info("Corrupting files in dir: " + path);
            Intrinsics.checkNotNull((Object)path);
            this.corruptFilesInDir(path);
        }
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void corruptFilesInDir(Path dir) {
        Sequence listOfFiles2;
        File file = dir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Sequence $this$forEach$iv = listOfFiles2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file)), (Function1)corruptFilesInDir.listOfFiles.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.corruptFile(it);
        }
    }

    private final void corruptFile(File file) {
        LOG.info("Corrupting file: " + file.getAbsolutePath());
        FilesKt.writeBytes((File)file, (byte[])RandomKt.Random((int)42).nextBytes(0x6400000));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CorruptIndexesCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/CorruptIndexesCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

