/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/commands/CodeAnalysisCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCodeAnalysisCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeAnalysisCommand.kt\ncom/jetbrains/performancePlugin/commands/CodeAnalysisCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n11#2:112\n*S KotlinDebug\n*F\n+ 1 CodeAnalysisCommand.kt\ncom/jetbrains/performancePlugin/commands/CodeAnalysisCommand\n*L\n24#1:112\n*E\n"})
public final class CodeAnalysisCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%codeAnalysis";
    @NotNull
    private static final Logger LOG;

    public CodeAnalysisCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
        String[] stringArray = new String[]{" "};
        List commandArgs = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String commandType = (String)commandArgs.get(0);
        DumbService.Companion.getInstance(project2).waitForSmartMode();
        MessageBusConnection busConnection = project2.getMessageBus().connect();
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        busConnection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(project2, busConnection, commandType, actionCallback, context, this, commandArgs){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $busConnection;
            final /* synthetic */ String $commandType;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            final /* synthetic */ PlaybackContext $context;
            final /* synthetic */ CodeAnalysisCommand this$0;
            final /* synthetic */ List<String> $commandArgs;
            {
                this.$project = $project;
                this.$busConnection = $busConnection;
                this.$commandType = $commandType;
                this.$actionCallback = $actionCallback;
                this.$context = $context;
                this.this$0 = $receiver;
                this.$commandArgs = $commandArgs;
            }

            /*
             * WARNING - void declaration
             */
            public void daemonFinished() {
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.$project);
                Intrinsics.checkNotNull((Object)daemonCodeAnalyzer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
                DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)daemonCodeAnalyzer;
                Editor editor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                if (!(editor != null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(editor.getDocument());
                if (!(psiFile != null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (myDaemonCodeAnalyzer.isErrorAnalyzingFinished(psiFile)) {
                    this.$busConnection.disconnect();
                    String string = this.$commandType;
                    if (Intrinsics.areEqual((Object)string, (Object)"CHECK_ON_RED_CODE")) {
                        List list = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHighlights(...)");
                        List errorsOnHighlighting = list;
                        if (errorsOnHighlighting.size() > 0) {
                            StringBuilder errorMessages = new StringBuilder("Analysis on red code detected some errors: " + errorsOnHighlighting.size());
                            Iterable $this$forEach$iv = errorsOnHighlighting;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                HighlightInfo it = (HighlightInfo)element$iv;
                                boolean bl = false;
                                errorMessages.append("\n").append(it.getDescription());
                            }
                            this.$actionCallback.reject(errorMessages.toString());
                        } else {
                            this.$context.message("Analysis on red code performed successfully", this.this$0.getLine());
                            this.$actionCallback.setDone();
                        }
                    } else if (Intrinsics.areEqual((Object)string, (Object)"WARNINGS_ANALYSIS")) {
                        List list = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.WARNING, (Project)this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHighlights(...)");
                        List warningsOnHighlighting = list;
                        if (warningsOnHighlighting.size() > 0) {
                            List list2;
                            Object object;
                            boolean warning2;
                            StringBuilder warnings = new StringBuilder("Highlighting detected some warnings: " + warningsOnHighlighting.size());
                            for (HighlightInfo warning2 : warningsOnHighlighting) {
                                warnings.append("\n").append(warning2.getDescription());
                            }
                            CodeAnalysisCommand.access$getLOG$cp().info(warnings.toString());
                            boolean bl = warning2 = this.$commandArgs.size() > 1;
                            if (warning2) {
                                object = new String[]{","};
                                list2 = StringsKt.split$default((CharSequence)this.$commandArgs.get(1), (String[])object, (boolean)false, (int)0, (int)6, null);
                            } else if (!warning2) {
                                list2 = CollectionsKt.emptyList();
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            List args = list2;
                            if (!((Collection)args).isEmpty()) {
                                void $this$forEach$iv;
                                Iterable warning2 = args;
                                object = this.$actionCallback;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    boolean found = false;
                                    for (HighlightInfo warning3 : warningsOnHighlighting) {
                                        String string2 = warning3.getDescription();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
                                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    object.reject("Highlighting did not detect the warning " + it);
                                }
                            }
                            if (!this.$actionCallback.isRejected()) {
                                this.$actionCallback.setDone();
                            }
                        } else {
                            this.$actionCallback.reject("Highlighting did not detect any warning");
                        }
                    } else {
                        throw new IllegalStateException(("Wrong type of code analysis: " + this.$commandType).toString());
                    }
                }
            }
        });
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CodeAnalysisCommand._execute$lambda$0(project2, context, this));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static final void _execute$lambda$0(Project $project, PlaybackContext $context, CodeAnalysisCommand this$0) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        PsiManager.getInstance((Project)$project).dropPsiCaches();
        $context.message("Code highlighting started", this$0.getLine());
        DaemonCodeAnalyzer.getInstance((Project)$project).restart();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeAnalysisCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/CodeAnalysisCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

