/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoRequireDirective;
import com.goide.vgo.project.VgoDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0007\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0005\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDependencies", "", "Lcom/goide/vgo/mod/psi/VgoModuleSpec;", "modFile", "Lcom/intellij/psi/PsiFile;", "getModuleRoot", "project", "Lcom/intellij/openapi/project/Project;", "dependency", "Lcom/goide/vgo/project/VgoDependency;", "ifClassesLoaded", "", "condition", "Lkotlin/Function0;", "isEnabled", "module", "Lcom/intellij/openapi/module/Module;", "file", "report", "", "", "toPackage", "Lorg/jetbrains/security/package/Package;", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/packageChecker/go/UtilsKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n430#2:65\n430#2:69\n1360#3:66\n1446#3,2:67\n1448#3,3:70\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/packageChecker/go/UtilsKt\n*L\n34#1:65\n35#1:69\n35#1:66\n35#1:67,2\n35#1:70,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Package toPackage(@NotNull VgoDependency $this$toPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        String string = $this$toPackage.getVersion();
        if (string == null) {
            return null;
        }
        String version = string;
        String string2 = $this$toPackage.getImportPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getImportPath(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return new Package(PackageType.go, null, string3, version, null, null, null, 112, null);
    }

    @Nullable
    public static final Package toPackage(@NotNull VgoModuleSpec $this$toPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        PsiElement psiElement = $this$toPackage.getModuleVersion();
        if (psiElement == null) {
            return null;
        }
        PsiElement version = psiElement;
        String string = $this$toPackage.getIdentifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = version.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return new Package(PackageType.go, null, string2, string3, null, null, null, 112, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VgoModuleSpec> getDependencies(@NotNull PsiFile modFile) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)modFile, (String)"modFile");
        PsiElement $this$childrenOfType$iv = (PsiElement)modFile;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, VgoRequireDirective.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VgoRequireDirective it = (VgoRequireDirective)element$iv$iv;
            boolean bl = false;
            PsiElement $this$childrenOfType$iv2 = (PsiElement)it;
            boolean $i$f$childrenOfType2 = false;
            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv2, VgoModuleSpec.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PsiFile getModuleRoot(@NotNull Project project, @NotNull VgoDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        VirtualFile virtualFile = dependency.getRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = root.findChild("go.mod");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile modFile = virtualFile2;
        return PsiManager.getInstance((Project)project).findFile(modFile);
    }

    public static final boolean isEnabled(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)new Function0<Boolean>(file2){
            final /* synthetic */ PsiFile $file;
            {
                this.$file = $file;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (this.$file instanceof VgoFile && Intrinsics.areEqual((Object)((VgoFile)this.$file).getName(), (Object)"go.mod")) {
                    boolean bl2;
                    Module module = GoUtil.module((PsiElement)((PsiElement)this.$file));
                    if (module != null) {
                        Module it = module;
                        boolean bl3 = false;
                        bl2 = UtilsKt.isEnabled(it);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    public static final boolean isEnabled(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return GoSdkService.getInstance((Project)this.$module.getProject()).isGoModule(this.$module) && VgoProjectSettings.getInstance((Project)this.$module.getProject()).isIntegrationEnabled();
            }
        }));
    }

    public static final boolean ifClassesLoaded(@NotNull Function0<Boolean> condition) {
        boolean bl;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        try {
            bl = (Boolean)condition.invoke();
        }
        catch (NoClassDefFoundError e) {
            UtilsKt.report(e);
            bl = false;
        }
        catch (ClassNotFoundException e) {
            UtilsKt.report(e);
            bl = false;
        }
        return bl;
    }

    private static final void report(Throwable $this$report) {
        LOG.warn("Unable to load classes, probably due to dynamically loaded Go plugin, please restart IDE: " + $this$report.getMessage(), $this$report);
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.security.extension.go");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

