/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.util.ChangesSelection;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.collaboration.util.ComputedResultKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHIssueComment;
import org.jetbrains.plugins.github.api.data.GHNode;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRPersistentInteractionState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.ui.GHApiLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRDetailsFull;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRDetailsTimelineViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRNewCommentViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineGroupedCommits;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergingModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineViewModelKt;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.UpdateableGHPRTimelineCommentViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.UpdateableGHPRTimelineReviewViewModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020FH\u0002J\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020\rH\u0016J\b\u0010N\u001a\u00020KH\u0016J\b\u0010O\u001a\u00020KH\u0016J\u0010\u0010P\u001a\u00020K2\u0006\u0010Q\u001a\u00020RH\u0002J\u0014\u0010S\u001a\u00020B*\u00020\u00052\u0006\u0010I\u001a\u00020FH\u0002J\u0014\u0010N\u001a\u00020K*\u00020B2\u0006\u0010I\u001a\u00020FH\u0002R\u001e\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010-R\u001c\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010-R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020\r0:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020>0:\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010<R \u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0A0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010-R\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModelImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;)V", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getAvatarIconsProvider", "()Lcom/intellij/collaboration/ui/icon/IconsProvider;", "commentVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRNewCommentViewModel;", "getCommentVm", "()Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRNewCommentViewModel;", "commentsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "cs", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "getCurrentUser", "()Lorg/jetbrains/plugins/github/api/data/GHUser;", "detailsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "detailsVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRDetailsTimelineViewModel;", "getDetailsVm", "()Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRDetailsTimelineViewModel;", "ghostUser", "getGhostUser", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "getHtmlImageLoader", "()Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "interactionState", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;", "isLoading", "Lkotlinx/coroutines/flow/StateFlow;", "", "()Lkotlinx/coroutines/flow/StateFlow;", "loadingError", "", "getLoadingError", "loadingErrorHandler", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "getLoadingErrorHandler", "()Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "reviewData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "showCommitRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "getShowCommitRequests", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "showDiffRequests", "Lcom/intellij/collaboration/util/ChangesSelection;", "getShowDiffRequests", "timelineItems", "", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineItem;", "getTimelineItems", "timelineLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "getItemID", "", "data", "requestMore", "", "showCommit", "oid", "update", "updateAll", "updateLastSeen", "lastSeenMillis", "", "createItemFromDTO", "intellij.vcs.github"})
public final class GHPRTimelineViewModelImpl
implements GHPRTimelineViewModel {
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRDataContext dataContext;
    @NotNull
    private final GHPRDataProvider dataProvider;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRDetailsDataProvider detailsData;
    @NotNull
    private final GHPRReviewDataProvider reviewData;
    @NotNull
    private final GHPRCommentsDataProvider commentsData;
    @NotNull
    private final GHPRPersistentInteractionState interactionState;
    @NotNull
    private final GHUser ghostUser;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private final GHPRDetailsTimelineViewModel detailsVm;
    @NotNull
    private final GHListLoader<org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem> timelineLoader;
    @NotNull
    private final GHLoadingErrorHandler loadingErrorHandler;
    @Nullable
    private final GHPRNewCommentViewModel commentVm;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final StateFlow<List<GHPRTimelineItem>> timelineItems;
    @NotNull
    private final StateFlow<Boolean> isLoading;
    @NotNull
    private final StateFlow<Throwable> loadingError;
    @NotNull
    private final MutableSharedFlow<String> showCommitRequests;
    @NotNull
    private final MutableSharedFlow<ChangesSelection> showDiffRequests;

    public GHPRTimelineViewModelImpl(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GHPRDataContext dataContext, @NotNull GHPRDataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        this.project = project;
        this.dataContext = dataContext;
        this.dataProvider = dataProvider;
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)new CoroutineName("GitHub Pull Request Timeline View Model")), (boolean)false, (int)2, null);
        this.securityService = this.dataContext.getSecurityService();
        this.detailsData = this.dataProvider.getDetailsData();
        this.reviewData = this.dataProvider.getReviewData();
        this.commentsData = this.dataProvider.getCommentsData();
        this.interactionState = this.dataContext.getInteractionState();
        this.ghostUser = this.securityService.getGhostUser();
        this.currentUser = this.securityService.getCurrentUser();
        this.detailsVm = new GHPRDetailsTimelineViewModel(this.project, parentCs, this.dataContext, this.dataProvider);
        this.timelineLoader = this.dataProvider.acquireTimelineLoader(CoroutineUtilKt.nestedDisposable((CoroutineScope)this.cs));
        this.loadingErrorHandler = new GHApiLoadingErrorHandler(this.project, this.securityService.getAccount(), (Function0<Unit>)((Function0)new Function0<Unit>(this.timelineLoader){

            public final void invoke() {
                ((GHListLoader)this.receiver).reset();
            }
        }));
        this.commentVm = this.securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.READ) ? new GHPRNewCommentViewModel(this.project, parentCs, this.commentsData) : null;
        this.htmlImageLoader = this.dataContext.getHtmlImageLoader();
        this.avatarIconsProvider = this.dataContext.getAvatarIconsProvider();
        this.isLoading = FlowKt.stateIn((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GHPRTimelineViewModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$callbackFlow = (ProducerScope)this.L$0;
                        v0 = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"newDisposable(...)");
                        disposable = v0;
                        GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).addLoadingStateChangeListener(disposable, (Function0<Unit>)((Function0)new Function0<Unit>((ProducerScope<? super Boolean>)$this$callbackFlow, this.this$0){
                            final /* synthetic */ ProducerScope<Boolean> $$this$callbackFlow;
                            final /* synthetic */ GHPRTimelineViewModelImpl this$0;
                            {
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.$$this$callbackFlow.trySend-JP2dKIU((Object)GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).getLoading());
                                if (!GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).canLoadMore() && !GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).getLoading()) {
                                    GHPRTimelineViewModelImpl.access$updateLastSeen(this.this$0, System.currentTimeMillis());
                                }
                            }
                        }));
                        this.L$0 = $this$callbackFlow;
                        this.L$1 = disposable;
                        this.label = 1;
                        v1 = $this$callbackFlow.send((Object)Boxing.boxBoolean((boolean)GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).getLoading()), (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        disposable = (Disposable)this.L$1;
                        $this$callbackFlow = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 2;
                        v2 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(disposable){
                            final /* synthetic */ Disposable $disposable;
                            {
                                this.$disposable = $disposable;
                                super(0);
                            }

                            public final void invoke() {
                                Disposer.dispose((Disposable)this.$disposable);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)this.timelineLoader.getLoading());
        this.loadingError = FlowKt.stateIn((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Throwable>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GHPRTimelineViewModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$callbackFlow = (ProducerScope)this.L$0;
                        v0 = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"newDisposable(...)");
                        disposable = v0;
                        GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).addErrorChangeListener(disposable, (Function0<Unit>)((Function0)new Function0<Unit>((ProducerScope<? super Throwable>)$this$callbackFlow, this.this$0){
                            final /* synthetic */ ProducerScope<Throwable> $$this$callbackFlow;
                            final /* synthetic */ GHPRTimelineViewModelImpl this$0;
                            {
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.$$this$callbackFlow.trySend-JP2dKIU((Object)GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).getError());
                            }
                        }));
                        this.L$0 = $this$callbackFlow;
                        this.L$1 = disposable;
                        this.label = 1;
                        v1 = $this$callbackFlow.send((Object)GHPRTimelineViewModelImpl.access$getTimelineLoader$p(this.this$0).getError(), (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        disposable = (Disposable)this.L$1;
                        $this$callbackFlow = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 2;
                        v2 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(disposable){
                            final /* synthetic */ Disposable $disposable;
                            {
                                this.$disposable = $disposable;
                                super(0);
                            }

                            public final void invoke() {
                                Disposer.dispose((Disposable)this.$disposable);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super Throwable> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)this.timelineLoader.getError());
        this.showCommitRequests = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.showDiffRequests = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        final GHPRTimelineMergingModel timelineModel = new GHPRTimelineMergingModel();
        timelineModel.add(this.timelineLoader.getLoadedData());
        MutableStateFlow itemsFromModel = StateFlowKt.MutableStateFlow((Object)GHPRTimelineViewModelKt.access$getItemsList(timelineModel));
        this.timelineItems = FlowKt.stateIn((Flow)CoroutineUtilKt.mapDataToModel((Flow)((Flow)itemsFromModel), (Function1)((Function1)new Function1<org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem, Object>((Object)this){

            @NotNull
            public final Object invoke(@NotNull org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((GHPRTimelineViewModelImpl)this.receiver).getItemID(p0);
            }
        }), (Function2)((Function2)new Function2<CoroutineScope, org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem, GHPRTimelineItem>(){

            @NotNull
            public final GHPRTimelineItem invoke(@NotNull CoroutineScope $this$mapDataToModel, @NotNull org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem it) {
                Intrinsics.checkNotNullParameter((Object)$this$mapDataToModel, (String)"$this$mapDataToModel");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.createItemFromDTO($this$mapDataToModel, it);
            }
        }), (Function3)((Function3)new Function3<GHPRTimelineItem, org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ GHPRTimelineViewModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GHPRTimelineItem $this$mapDataToModel = (GHPRTimelineItem)this.L$0;
                        org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem it = (org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem)this.L$1;
                        this.this$0.update($this$mapDataToModel, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull GHPRTimelineItem p1, @NotNull org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem p2, @Nullable Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)CollectionsKt.emptyList());
        this.timelineLoader.addDataListener(CoroutineUtilKt.nestedDisposable((CoroutineScope)this.cs), new GHListLoader.ListDataListener((MutableStateFlow<List<org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem>>)itemsFromModel){
            final /* synthetic */ MutableStateFlow<List<org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem>> $itemsFromModel;
            {
                this.$itemsFromModel = $itemsFromModel;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onDataAdded(int startIdx) {
                Long latestLoadedItemTime;
                void $this$mapNotNullTo$iv$iv;
                List loadedData = timelineLoader.getLoadedData();
                List addedData = loadedData.subList(startIdx, loadedData.size());
                timelineModel.add(addedData);
                this.$itemsFromModel.setValue((Object)GHPRTimelineViewModelKt.access$getItemsList(timelineModel));
                Iterable $this$mapNotNull$iv = loadedData;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Date it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem it = (org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getCreatedAt() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Date date = (Date)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                Long l = latestLoadedItemTime = date != null ? Long.valueOf(date.getTime()) : null;
                this.updateLastSeen(l != null ? l : System.currentTimeMillis());
            }

            @Override
            public void onDataUpdated(int idx) {
                org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem newItem = (org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem)timelineLoader.getLoadedData().get(idx);
                timelineModel.update(idx, newItem);
                this.$itemsFromModel.setValue((Object)GHPRTimelineViewModelKt.access$getItemsList(timelineModel));
                this.updateLastSeen(System.currentTimeMillis());
            }

            @Override
            public void onDataRemoved(int idx) {
                timelineModel.remove(idx);
                this.$itemsFromModel.setValue((Object)GHPRTimelineViewModelKt.access$getItemsList(timelineModel));
                this.updateLastSeen(System.currentTimeMillis());
            }

            @Override
            public void onAllDataRemoved() {
                timelineModel.removeAll();
                this.$itemsFromModel.setValue((Object)GHPRTimelineViewModelKt.access$getItemsList(timelineModel));
                GHListLoader.loadMore$default(timelineLoader, false, 1, null);
            }
        });
    }

    @Override
    @NotNull
    public GHUser getGhostUser() {
        return this.ghostUser;
    }

    @Override
    @NotNull
    public GHUser getCurrentUser() {
        return this.currentUser;
    }

    @Override
    @NotNull
    public GHPRDetailsTimelineViewModel getDetailsVm() {
        return this.detailsVm;
    }

    @Override
    @NotNull
    public GHLoadingErrorHandler getLoadingErrorHandler() {
        return this.loadingErrorHandler;
    }

    @Override
    @Nullable
    public GHPRNewCommentViewModel getCommentVm() {
        return this.commentVm;
    }

    @Override
    @NotNull
    public AsyncHtmlImageLoader getHtmlImageLoader() {
        return this.htmlImageLoader;
    }

    @Override
    @NotNull
    public IconsProvider<String> getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    @Override
    @NotNull
    public StateFlow<List<GHPRTimelineItem>> getTimelineItems() {
        return this.timelineItems;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isLoading() {
        return this.isLoading;
    }

    @Override
    @NotNull
    public StateFlow<Throwable> getLoadingError() {
        return this.loadingError;
    }

    @NotNull
    public final MutableSharedFlow<String> getShowCommitRequests() {
        return this.showCommitRequests;
    }

    @NotNull
    public final MutableSharedFlow<ChangesSelection> getShowDiffRequests() {
        return this.showDiffRequests;
    }

    private final void updateLastSeen(long lastSeenMillis) {
        Object object = (GHPRDetailsFull)ComputedResultKt.getOrNull-dyXsKJo((Result)((ComputedResult)this.getDetailsVm().getDetails().getValue()).unbox-impl());
        if (object == null || (object = ((GHPRDetailsFull)object).getId()) == null) {
            return;
        }
        Object prId = object;
        this.interactionState.updateStateFor((GHPRIdentifier)prId, (Function1<? super GHPRPersistentInteractionState.PRState, GHPRPersistentInteractionState.PRState>)((Function1)new Function1<GHPRPersistentInteractionState.PRState, GHPRPersistentInteractionState.PRState>((GHPRIdentifier)prId, lastSeenMillis){
            final /* synthetic */ GHPRIdentifier $prId;
            final /* synthetic */ long $lastSeenMillis;
            {
                this.$prId = $prId;
                this.$lastSeenMillis = $lastSeenMillis;
                super(1);
            }

            @NotNull
            public final GHPRPersistentInteractionState.PRState invoke(@Nullable GHPRPersistentInteractionState.PRState st) {
                long l = this.$lastSeenMillis;
                Object object = st;
                long l2 = object != null && (object = ((GHPRPersistentInteractionState.PRState)object).getLastSeen()) != null ? (Long)object : 0L;
                return new GHPRPersistentInteractionState.PRState(this.$prId, Math.max(l, l2));
            }
        }));
    }

    private final Object getItemID(org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem data2) {
        return data2 instanceof GHNode ? ((GHNode)((Object)data2)).getId() : data2;
    }

    private final GHPRTimelineItem createItemFromDTO(CoroutineScope $this$createItemFromDTO, org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem data2) {
        GHPRTimelineItem gHPRTimelineItem;
        org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem gHPRTimelineItem2 = data2;
        if (gHPRTimelineItem2 instanceof GHIssueComment) {
            gHPRTimelineItem = new UpdateableGHPRTimelineCommentViewModel(this.project, $this$createItemFromDTO, this.dataContext, this.dataProvider.getCommentsData(), (GHIssueComment)data2);
        } else if (gHPRTimelineItem2 instanceof GHPullRequestReview) {
            UpdateableGHPRTimelineReviewViewModel updateableGHPRTimelineReviewViewModel;
            UpdateableGHPRTimelineReviewViewModel it = updateableGHPRTimelineReviewViewModel = new UpdateableGHPRTimelineReviewViewModel(this.project, $this$createItemFromDTO, this.dataContext, this.dataProvider, (GHPullRequestReview)data2);
            boolean bl = false;
            CoroutineUtilKt.launchNow$default((CoroutineScope)$this$createItemFromDTO, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, this, null){
                int label;
                final /* synthetic */ UpdateableGHPRTimelineReviewViewModel $it;
                final /* synthetic */ GHPRTimelineViewModelImpl this$0;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$it.getShowDiffRequests().collect((FlowCollector)this.this$0.getShowDiffRequests(), (Continuation)this);
                            if (object3 != object2) throw new KotlinNothingValueException();
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            gHPRTimelineItem = updateableGHPRTimelineReviewViewModel;
        } else {
            gHPRTimelineItem = gHPRTimelineItem2 instanceof GHPullRequestCommitShort ? (GHPRTimelineItem)new GHPRTimelineItem.Commits(CollectionsKt.listOf((Object)data2)) : (gHPRTimelineItem2 instanceof GHPRTimelineGroupedCommits ? (GHPRTimelineItem)new GHPRTimelineItem.Commits(((GHPRTimelineGroupedCommits)data2).getItems()) : (gHPRTimelineItem2 instanceof GHPRTimelineEvent ? (GHPRTimelineItem)new GHPRTimelineItem.Event((GHPRTimelineEvent)data2) : (GHPRTimelineItem)new GHPRTimelineItem.Unknown("")));
        }
        return gHPRTimelineItem;
    }

    private final void update(GHPRTimelineItem $this$update, org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem data2) {
        if ($this$update instanceof UpdateableGHPRTimelineCommentViewModel && data2 instanceof GHIssueComment) {
            ((UpdateableGHPRTimelineCommentViewModel)$this$update).update((GHIssueComment)data2);
        }
    }

    @Override
    public void requestMore() {
        GHListLoader.loadMore$default(this.timelineLoader, false, 1, null);
    }

    @Override
    public void update() {
        if (!((Collection)this.timelineLoader.getLoadedData()).isEmpty()) {
            this.timelineLoader.loadMore(true);
        }
    }

    @Override
    public void updateAll() {
        this.detailsData.reloadDetails();
        this.timelineLoader.loadMore(true);
        this.reviewData.resetReviewThreads();
    }

    @Override
    public void showCommit(@NotNull String oid) {
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        this.showCommitRequests.tryEmit((Object)oid);
    }
}

