/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.codereview.list.ReviewListViewModel;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.CollectionListModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRPersistentInteractionState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRListPersistentSearchHistory;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRListSearchValue;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRSearchHistoryModel;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRSearchPanelViewModel;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponentBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010C\u001a\u00020\u000bH\u0016J\u0006\u0010D\u001a\u00020\u000bJ\u0006\u0010E\u001a\u00020\u000bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001dR\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020%0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001dR\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020%0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020%0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001dR\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020%0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\u00070\u0012\u00a2\u0006\u0002\b8\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010?\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\u00a8\u0006F"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRListViewModel;", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;)V", "_focusRequests", "Lkotlinx/coroutines/channels/Channel;", "", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getAvatarIconsProvider", "()Lcom/intellij/collaboration/ui/icon/IconsProvider;", "cs", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "error", "Lkotlinx/coroutines/flow/SharedFlow;", "", "getError", "()Lkotlinx/coroutines/flow/SharedFlow;", "errorState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "focusRequests", "Lkotlinx/coroutines/flow/Flow;", "getFocusRequests$intellij_vcs_github", "()Lkotlinx/coroutines/flow/Flow;", "hasUpdates", "", "getHasUpdates", "hasUpdatesState", "interactionStateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;", "listModel", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "getListModel", "()Ljavax/swing/ListModel;", "loading", "getLoading", "loadingState", "outdated", "getOutdated", "outdatedState", "repository", "Lcom/intellij/openapi/util/NlsSafe;", "getRepository", "()Ljava/lang/String;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "searchHistoryModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRSearchHistoryModel;", "searchVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRSearchPanelViewModel;", "getSearchVm", "()Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRSearchPanelViewModel;", "refresh", "requestFocus", "requestMore", "intellij.vcs.github"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGHPRListViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRListViewModel.kt\norg/jetbrains/plugins/github/pullrequest/GHPRListViewModel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,129:1\n31#2,2:130\n31#2,2:132\n*S KotlinDebug\n*F\n+ 1 GHPRListViewModel.kt\norg/jetbrains/plugins/github/pullrequest/GHPRListViewModel\n*L\n37#1:130,2\n99#1:132,2\n*E\n"})
public final class GHPRListViewModel
implements ReviewListViewModel {
    @NotNull
    private final GHPRDataContext dataContext;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GHPRPersistentInteractionState interactionStateService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHPRListLoader listLoader;
    @NotNull
    private final GithubAccount account;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private final String repository;
    @NotNull
    private final ListModel<GHPullRequestShort> listModel;
    @NotNull
    private final MutableStateFlow<Boolean> loadingState;
    @NotNull
    private final SharedFlow<Boolean> loading;
    @NotNull
    private final MutableStateFlow<Throwable> errorState;
    @NotNull
    private final SharedFlow<Throwable> error;
    @NotNull
    private final MutableStateFlow<Boolean> outdatedState;
    @NotNull
    private final SharedFlow<Boolean> outdated;
    @NotNull
    private final MutableStateFlow<Boolean> hasUpdatesState;
    @NotNull
    private final SharedFlow<Boolean> hasUpdates;
    @NotNull
    private final GHPRSearchHistoryModel searchHistoryModel;
    @NotNull
    private final GHPRSearchPanelViewModel searchVm;
    @NotNull
    private final Channel<Unit> _focusRequests;
    @NotNull
    private final Flow<Unit> focusRequests;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;

    /*
     * WARNING - void declaration
     */
    public GHPRListViewModel(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GHPRDataContext dataContext) {
        void model2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.dataContext = dataContext;
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<GHPRPersistentInteractionState> serviceClass$iv = GHPRPersistentInteractionState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.interactionStateService = (GHPRPersistentInteractionState)((Object)object);
        this.repositoryDataService = this.dataContext.getRepositoryDataService();
        this.listLoader = this.dataContext.getListLoader();
        this.account = this.dataContext.getSecurityService().getAccount();
        this.currentUser = this.dataContext.getSecurityService().getCurrentUser();
        this.repository = this.repositoryDataService.getRepositoryCoordinates().getRepositoryPath().getRepository();
        ComponentManager $i$f$service22 = $this$service$iv = new CollectionListModel(this.listLoader.getLoadedData());
        GHPRListViewModel gHPRListViewModel = this;
        boolean bl = false;
        this.listLoader.addDataListener(CoroutineUtilKt.nestedDisposable((CoroutineScope)this.cs), new GHListLoader.ListDataListener(this, (CollectionListModel<GHPullRequestShort>)model2){
            final /* synthetic */ GHPRListViewModel this$0;
            final /* synthetic */ CollectionListModel<GHPullRequestShort> $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
            }

            public void onDataAdded(int startIdx) {
                List loadedData = GHPRListViewModel.access$getListLoader$p(this.this$0).getLoadedData();
                this.$model.add(((ArrayList)loadedData).subList(startIdx, ((ArrayList)loadedData).size()));
            }

            public void onDataUpdated(int idx) {
                this.$model.setElementAt(((ArrayList)GHPRListViewModel.access$getListLoader$p(this.this$0).getLoadedData()).get(idx), idx);
            }

            public void onDataRemoved(int idx) {
                this.$model.remove(idx);
            }

            public void onAllDataRemoved() {
                this.$model.removeAll();
            }
        });
        gHPRListViewModel.listModel = (ListModel)$this$service$iv;
        this.loadingState = StateFlowKt.MutableStateFlow((Object)false);
        this.loading = FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this.loadingState));
        this.errorState = StateFlowKt.MutableStateFlow(null);
        this.error = FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this.errorState));
        this.outdatedState = StateFlowKt.MutableStateFlow((Object)false);
        this.outdated = FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this.outdatedState));
        this.hasUpdatesState = StateFlowKt.MutableStateFlow((Object)false);
        this.hasUpdates = FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this.hasUpdatesState));
        Disposable listenersDisposable = CoroutineUtilKt.nestedDisposable((CoroutineScope)this.cs);
        this.listLoader.addLoadingStateChangeListener(listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                loadingState.setValue((Object)listLoader.getLoading());
                if (!listLoader.getLoading()) {
                    boolean bl;
                    MutableStateFlow mutableStateFlow;
                    block4: {
                        void $this$any$iv;
                        Iterable<GHPullRequestShort> iterable = GHCloneDialogExtensionComponentBase.Companion.getItems$intellij_vcs_github(this.getListModel());
                        GHPRListViewModel gHPRListViewModel = this;
                        mutableStateFlow = hasUpdatesState;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                GHPullRequestShort it = (GHPullRequestShort)element$iv;
                                boolean bl2 = false;
                                if (!(!gHPRListViewModel.interactionStateService.isSeen(it, gHPRListViewModel.currentUser))) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    boolean bl3 = bl;
                    mutableStateFlow.setValue((Object)bl3);
                }
            }
        }));
        this.listLoader.addErrorChangeListener(listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                errorState.setValue((Object)listLoader.getError());
            }
        }));
        this.dataContext.getListUpdatesChecker().addOutdatedStateChangeListener(listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                outdatedState.setValue((Object)dataContext.getListUpdatesChecker().getOutdated());
            }
        }));
        this.listLoader.addDataListener(listenersDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onAllDataRemoved() {
                GHListLoader.loadMore$default(listLoader, false, 1, null);
            }
        });
        $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GHPRListPersistentSearchHistory> serviceClass$iv2 = GHPRListPersistentSearchHistory.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
        }
        this.searchHistoryModel = new GHPRSearchHistoryModel((GHPRListPersistentSearchHistory)((Object)object2));
        this.searchVm = new GHPRSearchPanelViewModel(this.cs, project, this.repositoryDataService, this.searchHistoryModel, this.dataContext.getSecurityService().getCurrentUser());
        this._focusRequests = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        this.focusRequests = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._focusRequests));
        this.avatarIconsProvider = this.dataContext.getAvatarIconsProvider();
        CoroutineUtilKt.launchNow$default((CoroutineScope)this.cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GHPRListViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getSearchVm().getSearchState()), (Function2)((Function2)new Function2<GHPRListSearchValue, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ GHPRListViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        GHPRListSearchValue it = (GHPRListSearchValue)this.L$0;
                                        this.this$0.listLoader.setSearchQuery(it.toQuery());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull GHPRListSearchValue p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final GithubAccount getAccount() {
        return this.account;
    }

    @NotNull
    public final String getRepository() {
        return this.repository;
    }

    @NotNull
    public final ListModel<GHPullRequestShort> getListModel() {
        return this.listModel;
    }

    @NotNull
    public final SharedFlow<Boolean> getLoading() {
        return this.loading;
    }

    @NotNull
    public final SharedFlow<Throwable> getError() {
        return this.error;
    }

    @NotNull
    public final SharedFlow<Boolean> getOutdated() {
        return this.outdated;
    }

    @NotNull
    public final SharedFlow<Boolean> getHasUpdates() {
        return this.hasUpdates;
    }

    @NotNull
    public final GHPRSearchPanelViewModel getSearchVm() {
        return this.searchVm;
    }

    @NotNull
    public final Flow<Unit> getFocusRequests$intellij_vcs_github() {
        return this.focusRequests;
    }

    @NotNull
    public final IconsProvider<String> getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    public void refresh() {
        this.listLoader.reset();
        this.repositoryDataService.resetData();
    }

    public final void requestMore() {
        if (this.listLoader.canLoadMore()) {
            GHListLoader.loadMore$default(this.listLoader, false, 1, null);
        }
    }

    public final void requestFocus() {
        this._focusRequests.trySend-JP2dKIU((Object)Unit.INSTANCE);
    }
}

