"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import io
import json
import re
import ssl
from urllib.parse import urlencode

import aiohttp

from influxdb_client.rest import ApiException
from influxdb_client.rest import _BaseRESTClient
from influxdb_client.rest import _UTF_8_encoding


async def _on_request_start(session, trace_config_ctx, params):
    _BaseRESTClient.log_request(params.method, params.url)
    _BaseRESTClient.log_headers(params.headers, '>>>')


async def _on_request_chunk_sent(session, context, params):
    if params.chunk:
        _BaseRESTClient.log_body(params.chunk, '>>>')


async def _on_request_end(session, trace_config_ctx, params):
    _BaseRESTClient.log_response(params.response.status)
    _BaseRESTClient.log_headers(params.headers, '<<<')

    response_content = params.response.content
    data = bytearray()
    while True:
        chunk = await response_content.read(100)
        if not chunk:
            break
        data += chunk
    if data:
        _BaseRESTClient.log_body(data.decode(_UTF_8_encoding), '<<<')
        response_content.unread_data(data=data)


class RESTResponseAsync(io.IOBase):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech
    Do not edit the class manually.
    """

    def __init__(self, resp, data):
        """Initialize with HTTP response."""
        self.aiohttp_response = resp
        self.status = resp.status
        self.reason = resp.reason
        self.data = data

    def getheaders(self):
        """Return a CIMultiDictProxy of the response headers."""
        return self.aiohttp_response.headers

    def getheader(self, name, default=None):
        """Return a given response header."""
        return self.aiohttp_response.headers.get(name, default)


class RESTClientObjectAsync(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech
    Do not edit the class manually.
    """

    def __init__(self, configuration, pools_size=4, maxsize=None, **kwargs):
        """Initialize REST client."""
        # maxsize is number of requests to host that are allowed in parallel
        if maxsize is None:
            maxsize = configuration.connection_pool_maxsize

        if configuration.ssl_context is None:
            ssl_context = ssl.create_default_context(cafile=configuration.ssl_ca_cert)
            if configuration.cert_file:
                ssl_context.load_cert_chain(
                    certfile=configuration.cert_file, keyfile=configuration.cert_key_file,
                    password=configuration.cert_key_password
                )

            if not configuration.verify_ssl:
                ssl_context.check_hostname = False
                ssl_context.verify_mode = ssl.CERT_NONE
        else:
            ssl_context = configuration.ssl_context

        connector = aiohttp.TCPConnector(
            limit=maxsize,
            ssl=ssl_context
        )

        self.proxy = configuration.proxy
        self.proxy_headers = configuration.proxy_headers
        self.allow_redirects = kwargs.get('allow_redirects', True)
        self.max_redirects = kwargs.get('max_redirects', 10)

        # configure tracing
        trace_config = aiohttp.TraceConfig()
        trace_config.on_request_start.append(_on_request_start)
        trace_config.on_request_chunk_sent.append(_on_request_chunk_sent)
        trace_config.on_request_end.append(_on_request_end)

        # timeout
        if isinstance(configuration.timeout, (int, float,)):  # noqa: E501,F821
            timeout = aiohttp.ClientTimeout(total=configuration.timeout / 1_000)
        elif isinstance(configuration.timeout, aiohttp.ClientTimeout):
            timeout = configuration.timeout
        else:
            timeout = aiohttp.client.DEFAULT_TIMEOUT

        # https pool manager
        _client_session_type = kwargs.get('client_session_type', aiohttp.ClientSession)
        _client_session_kwargs = kwargs.get('client_session_kwargs', {})
        self.pool_manager = _client_session_type(
            connector=connector,
            timeout=timeout,
            trace_configs=[trace_config] if configuration.debug else None,
            **_client_session_kwargs
        )

    async def close(self):
        """Dispose connection pool manager."""
        await self.pool_manager.close()

    async def request(self, method, url, query_params=None, headers=None,
                      body=None, post_params=None, _preload_content=True,
                      _request_timeout=None):
        """Execute request.

        :param method: http request method
        :param url: http request url
        :param query_params: query parameters in the url
        :param headers: http request headers
        :param body: request json body, for `application/json`
        :param post_params: request post parameters,
                            `application/x-www-form-urlencoded`
                            and `multipart/form-data`
        :param _preload_content: this is a non-applicable field for
                                 the AiohttpClient.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        """
        method = method.upper()
        assert method in ['GET', 'HEAD', 'DELETE', 'POST', 'PUT',
                          'PATCH', 'OPTIONS']

        if post_params and body:
            raise ValueError(
                "body parameter cannot be used with post_params parameter."
            )

        post_params = post_params or {}
        headers = headers or {}

        if 'Content-Type' not in headers:
            headers['Content-Type'] = 'application/json'

        args = {
            "method": method,
            "url": url,
            "headers": headers,
            "allow_redirects": self.allow_redirects,
            "max_redirects": self.max_redirects
        }

        if self.proxy:
            args["proxy"] = self.proxy
        if self.proxy_headers:
            args["proxy_headers"] = self.proxy_headers

        if query_params:
            args["url"] += '?' + urlencode(query_params)

        # For `POST`, `PUT`, `PATCH`, `OPTIONS`, `DELETE`
        if method in ['POST', 'PUT', 'PATCH', 'OPTIONS', 'DELETE']:
            if re.search('json', headers['Content-Type'], re.IGNORECASE):
                if body is not None:
                    body = json.dumps(body)
                args["data"] = body
            elif headers['Content-Type'] == 'application/x-www-form-urlencoded':  # noqa: E501
                args["data"] = aiohttp.FormData(post_params)
            elif headers['Content-Type'] == 'multipart/form-data':
                # must del headers['Content-Type'], or the correct
                # Content-Type which generated by aiohttp
                del headers['Content-Type']
                data = aiohttp.FormData()
                for param in post_params:
                    k, v = param
                    if isinstance(v, tuple) and len(v) == 3:
                        data.add_field(k,
                                       value=v[1],
                                       filename=v[0],
                                       content_type=v[2])
                    else:
                        data.add_field(k, v)
                args["data"] = data

            # Pass a `bytes` parameter directly in the body to support
            # other content types than Json when `body` argument is provided
            # in serialized form
            elif isinstance(body, bytes):
                args["data"] = body
            else:
                # Cannot generate the request from given parameters
                msg = """Cannot prepare a request message for provided
                         arguments. Please check that your arguments match
                         declared content type."""
                raise ApiException(status=0, reason=msg)

        r = await self.pool_manager.request(**args)
        if _preload_content:

            data = await r.read()
            r = RESTResponseAsync(r, data)

            if not 200 <= r.status <= 299:
                raise ApiException(http_resp=r)

        return r

    async def GET(self, url, headers=None, query_params=None,
                  _preload_content=True, _request_timeout=None):
        """Perform GET HTTP request."""
        return (await self.request("GET", url,
                                   headers=headers,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   query_params=query_params))

    async def HEAD(self, url, headers=None, query_params=None,
                   _preload_content=True, _request_timeout=None):
        """Perform HEAD HTTP request."""
        return (await self.request("HEAD", url,
                                   headers=headers,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   query_params=query_params))

    async def OPTIONS(self, url, headers=None, query_params=None,
                      post_params=None, body=None, _preload_content=True,
                      _request_timeout=None):
        """Perform OPTIONS HTTP request."""
        return (await self.request("OPTIONS", url,
                                   headers=headers,
                                   query_params=query_params,
                                   post_params=post_params,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   body=body))

    async def DELETE(self, url, headers=None, query_params=None, body=None,
                     _preload_content=True, _request_timeout=None):
        """Perform DELETE HTTP request."""
        return (await self.request("DELETE", url,
                                   headers=headers,
                                   query_params=query_params,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   body=body))

    async def POST(self, url, headers=None, query_params=None,
                   post_params=None, body=None, _preload_content=True,
                   _request_timeout=None):
        """Perform POST HTTP request."""
        return (await self.request("POST", url,
                                   headers=headers,
                                   query_params=query_params,
                                   post_params=post_params,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   body=body))

    async def PUT(self, url, headers=None, query_params=None, post_params=None,
                  body=None, _preload_content=True, _request_timeout=None):
        """Perform PUT HTTP request."""
        return (await self.request("PUT", url,
                                   headers=headers,
                                   query_params=query_params,
                                   post_params=post_params,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   body=body))

    async def PATCH(self, url, headers=None, query_params=None,
                    post_params=None, body=None, _preload_content=True,
                    _request_timeout=None):
        """Perform PATCH HTTP request."""
        return (await self.request("PATCH", url,
                                   headers=headers,
                                   query_params=query_params,
                                   post_params=post_params,
                                   _preload_content=_preload_content,
                                   _request_timeout=_request_timeout,
                                   body=body))
