<?php
/**
 * DBRPsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * DBRPsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DBRPsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteDBRPID
     *
     * Delete a database retention policy
     *
     * @param  string $dbrp_id The database retention policy mapping (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDBRPID($dbrp_id, $zap_trace_span = null, $org_id = null, $org = null)
    {
        $this->deleteDBRPIDWithHttpInfo($dbrp_id, $zap_trace_span, $org_id, $org);
    }

    /**
     * Operation deleteDBRPIDWithHttpInfo
     *
     * Delete a database retention policy
     *
     * @param  string $dbrp_id The database retention policy mapping (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDBRPIDWithHttpInfo($dbrp_id, $zap_trace_span = null, $org_id = null, $org = null)
    {
        $request = $this->deleteDBRPIDRequest($dbrp_id, $zap_trace_span, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDBRPID'
     *
     * @param  string $dbrp_id The database retention policy mapping (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDBRPIDRequest($dbrp_id, $zap_trace_span = null, $org_id = null, $org = null)
    {
        // verify the required parameter 'dbrp_id' is set
        if ($dbrp_id === null || (is_array($dbrp_id) && count($dbrp_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dbrp_id when calling deleteDBRPID'
            );
        }

        $resourcePath = '/api/v2/dbrps/{dbrpID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dbrp_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dbrpID' . '}',
                ObjectSerializer::toPathValue($dbrp_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDBRPs
     *
     * List database retention policy mappings
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID to filter on (optional)
     * @param  string $org Specifies the organization name to filter on (optional)
     * @param  string $id Specifies the mapping ID to filter on (optional)
     * @param  string $bucket_id Specifies the bucket ID to filter on (optional)
     * @param  bool $default Specifies filtering on default (optional)
     * @param  string $db Specifies the database to filter on (optional)
     * @param  string $rp Specifies the retention policy to filter on (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\DBRPs|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getDBRPs($zap_trace_span = null, $org_id = null, $org = null, $id = null, $bucket_id = null, $default = null, $db = null, $rp = null)
    {
        list($response) = $this->getDBRPsWithHttpInfo($zap_trace_span, $org_id, $org, $id, $bucket_id, $default, $db, $rp);
        return $response;
    }

    /**
     * Operation getDBRPsWithHttpInfo
     *
     * List database retention policy mappings
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID to filter on (optional)
     * @param  string $org Specifies the organization name to filter on (optional)
     * @param  string $id Specifies the mapping ID to filter on (optional)
     * @param  string $bucket_id Specifies the bucket ID to filter on (optional)
     * @param  bool $default Specifies filtering on default (optional)
     * @param  string $db Specifies the database to filter on (optional)
     * @param  string $rp Specifies the retention policy to filter on (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\DBRPs|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDBRPsWithHttpInfo($zap_trace_span = null, $org_id = null, $org = null, $id = null, $bucket_id = null, $default = null, $db = null, $rp = null)
    {
        $request = $this->getDBRPsRequest($zap_trace_span, $org_id, $org, $id, $bucket_id, $default, $db, $rp);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\DBRPs';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDBRPs'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID to filter on (optional)
     * @param  string $org Specifies the organization name to filter on (optional)
     * @param  string $id Specifies the mapping ID to filter on (optional)
     * @param  string $bucket_id Specifies the bucket ID to filter on (optional)
     * @param  bool $default Specifies filtering on default (optional)
     * @param  string $db Specifies the database to filter on (optional)
     * @param  string $rp Specifies the retention policy to filter on (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDBRPsRequest($zap_trace_span = null, $org_id = null, $org = null, $id = null, $bucket_id = null, $default = null, $db = null, $rp = null)
    {

        $resourcePath = '/api/v2/dbrps';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // query params
        if ($bucket_id !== null) {
            $queryParams['bucketID'] = ObjectSerializer::toQueryValue($bucket_id);
        }
        // query params
        if ($default !== null) {
            $queryParams['default'] = ObjectSerializer::toQueryValue($default);
        }
        // query params
        if ($db !== null) {
            $queryParams['db'] = ObjectSerializer::toQueryValue($db);
        }
        // query params
        if ($rp !== null) {
            $queryParams['rp'] = ObjectSerializer::toQueryValue($rp);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDBRPsID
     *
     * Retrieve a database retention policy mapping
     *
     * @param  string $dbrp_id The database retention policy mapping ID (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\DBRPGet|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getDBRPsID($dbrp_id, $zap_trace_span = null, $org_id = null, $org = null)
    {
        list($response) = $this->getDBRPsIDWithHttpInfo($dbrp_id, $zap_trace_span, $org_id, $org);
        return $response;
    }

    /**
     * Operation getDBRPsIDWithHttpInfo
     *
     * Retrieve a database retention policy mapping
     *
     * @param  string $dbrp_id The database retention policy mapping ID (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\DBRPGet|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDBRPsIDWithHttpInfo($dbrp_id, $zap_trace_span = null, $org_id = null, $org = null)
    {
        $request = $this->getDBRPsIDRequest($dbrp_id, $zap_trace_span, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\DBRPGet';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDBRPsID'
     *
     * @param  string $dbrp_id The database retention policy mapping ID (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDBRPsIDRequest($dbrp_id, $zap_trace_span = null, $org_id = null, $org = null)
    {
        // verify the required parameter 'dbrp_id' is set
        if ($dbrp_id === null || (is_array($dbrp_id) && count($dbrp_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dbrp_id when calling getDBRPsID'
            );
        }

        $resourcePath = '/api/v2/dbrps/{dbrpID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dbrp_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dbrpID' . '}',
                ObjectSerializer::toPathValue($dbrp_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDBRPID
     *
     * Update a database retention policy mapping
     *
     * @param  string $dbrp_id The database retention policy mapping. (required)
     * @param  \InfluxDB2\Model\DBRPUpdate $dbrp_update Database retention policy update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\DBRPGet|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDBRPID($dbrp_id, $dbrp_update, $zap_trace_span = null, $org_id = null, $org = null)
    {
        list($response) = $this->patchDBRPIDWithHttpInfo($dbrp_id, $dbrp_update, $zap_trace_span, $org_id, $org);
        return $response;
    }

    /**
     * Operation patchDBRPIDWithHttpInfo
     *
     * Update a database retention policy mapping
     *
     * @param  string $dbrp_id The database retention policy mapping. (required)
     * @param  \InfluxDB2\Model\DBRPUpdate $dbrp_update Database retention policy update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\DBRPGet|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDBRPIDWithHttpInfo($dbrp_id, $dbrp_update, $zap_trace_span = null, $org_id = null, $org = null)
    {
        $request = $this->patchDBRPIDRequest($dbrp_id, $dbrp_update, $zap_trace_span, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\DBRPGet';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDBRPID'
     *
     * @param  string $dbrp_id The database retention policy mapping. (required)
     * @param  \InfluxDB2\Model\DBRPUpdate $dbrp_update Database retention policy update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id Specifies the organization ID of the mapping (optional)
     * @param  string $org Specifies the organization name of the mapping (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDBRPIDRequest($dbrp_id, $dbrp_update, $zap_trace_span = null, $org_id = null, $org = null)
    {
        // verify the required parameter 'dbrp_id' is set
        if ($dbrp_id === null || (is_array($dbrp_id) && count($dbrp_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dbrp_id when calling patchDBRPID'
            );
        }
        // verify the required parameter 'dbrp_update' is set
        if ($dbrp_update === null || (is_array($dbrp_update) && count($dbrp_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dbrp_update when calling patchDBRPID'
            );
        }

        $resourcePath = '/api/v2/dbrps/{dbrpID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dbrp_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dbrpID' . '}',
                ObjectSerializer::toPathValue($dbrp_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($dbrp_update)) {
            $_tempBody = $dbrp_update;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDBRP
     *
     * Add a database retention policy mapping
     *
     * @param  \InfluxDB2\Model\DBRPCreate $dbrp_create The database retention policy mapping to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\DBRP|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postDBRP($dbrp_create, $zap_trace_span = null)
    {
        list($response) = $this->postDBRPWithHttpInfo($dbrp_create, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDBRPWithHttpInfo
     *
     * Add a database retention policy mapping
     *
     * @param  \InfluxDB2\Model\DBRPCreate $dbrp_create The database retention policy mapping to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\DBRP|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDBRPWithHttpInfo($dbrp_create, $zap_trace_span = null)
    {
        $request = $this->postDBRPRequest($dbrp_create, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\DBRP';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDBRP'
     *
     * @param  \InfluxDB2\Model\DBRPCreate $dbrp_create The database retention policy mapping to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDBRPRequest($dbrp_create, $zap_trace_span = null)
    {
        // verify the required parameter 'dbrp_create' is set
        if ($dbrp_create === null || (is_array($dbrp_create) && count($dbrp_create) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dbrp_create when calling postDBRP'
            );
        }

        $resourcePath = '/api/v2/dbrps';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($dbrp_create)) {
            $_tempBody = $dbrp_create;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
