"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class IndexService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getIndexFields", async (_context, request, response) => {
      try {
        var _indexResponse$index;

        const {
          index
        } = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const indexResponse = await callWithRequest('indices.getFieldMapping', {
          index,
          fields: ['*']
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: Object.keys(((_indexResponse$index = indexResponse[index]) === null || _indexResponse$index === void 0 ? void 0 : _indexResponse$index.mappings) || {})
          }
        });
      } catch (error) {
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "getIndices", async (_context, request, response) => {
      try {
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const params = {
          format: 'json'
        };
        const getIndicesResponse = await callWithRequest('cat.indices', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              indices: getIndicesResponse
            }
          }
        });
      } catch (error) {
        console.error('Security Analytics - IndexService - getIndices:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "updateAliases", async (_context, request, response) => {
      try {
        const actions = request.body;
        const params = {
          body: actions
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        await callWithRequest('indices.updateAliases', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true
          }
        });
      } catch (error) {
        console.error('Security Analytics - IndexService - createAliases:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend POST Detectors API.
   */


}

exports.default = IndexService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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