"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class DetectorService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "createDetector", async (_context, request, response) => {
      try {
        const detector = request.body;
        const params = {
          body: detector
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const createDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.CREATE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - createDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "getDetector", async (_context, request, response) => {
      try {
        const {
          detectorId
        } = request.params;
        const params = {
          detectorId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.GET_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - getDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "searchDetectors", async (_context, request, response) => {
      try {
        const {
          query
        } = request.body;
        const params = {
          body: {
            size: 10000,
            query
          }
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const searchDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.SEARCH_DETECTORS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - searchDetectors:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "deleteDetector", async (_context, request, response) => {
      try {
        const {
          detectorId
        } = request.params;
        const params = {
          detectorId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const deleteDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.DELETE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - deleteDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "updateDetector", async (_context, request, response) => {
      try {
        const detector = request.body;
        const {
          detectorId
        } = request.params;
        const params = {
          body: detector,
          detectorId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const updateDetectorResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.UPDATE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - updateDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend POST Detectors API.
   */

  /**
   * Calls backend GET Detector API.
   */

  /**
   * Calls backend Search Detector API.
   */

  /**
   * Calls backend DELETE Detector API.
   */

  /**
   * Calls backend PUT Detectors API.
   */


}

exports.default = DetectorService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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