"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFindingsMethods = addFindingsMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addFindingsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_FINDINGS] = createAction({
    url: {
      fmt: `${_constants.API.GET_FINDINGS}?detector_id=<%=detectorId%>&sortOrder=<%=sortOrder%>&size=<%=size%>`,
      req: {
        detectorId: {
          type: 'string',
          required: false
        },
        sortOrder: {
          type: 'string',
          required: false
        },
        size: {
          type: 'number',
          required: false
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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