"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sqlPlugin;

var _constants = require("../../services/utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function sqlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.sql = components.clientAction.namespaceFactory();
  const sql = Client.prototype.sql.prototype;
  sql.translateSQL = ca({
    url: {
      fmt: `${_constants.SQL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.translatePPL = ca({
    url: {
      fmt: `${_constants.PPL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlQuery = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.pplQuery = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.sqlJson = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_JSON}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplJson = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_JSON}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlCsv = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplCsv = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlText = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplText = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sparkSqlQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sparkSqlGetQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}/<%=jobId%>`,
      req: {
        jobId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  sql.datasourcesGetQuery = ca({
    url: {
      fmt: `${_constants.DATASOURCES_GET_QUERY}`
    },
    needBody: false,
    method: 'GET'
  });
  sql.asyncDeleteQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}/<%=jobId%>`,
      req: {
        jobId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'DELETE'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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