"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;

require("core-js/modules/es.typed-array.set.js");

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat) => {
      try {
        const queryRequest = {
          query: request.body
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.error(err);
        return {
          data: {
            ok: false,
            resp: err.response,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryInternal(request, 'ppl.sqlQuery', 'json');
    });

    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryInternal(request, 'ppl.pplQuery', 'json');
    });

    this.client = client;
  }

}

exports.QueryService = QueryService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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