/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

'use strict'

const result = { body: null, statusCode: null, headers: null, warnings: null }
const kConfigurationError = Symbol('configuration error')

function handleError (err, callback) {
  if (callback) {
    process.nextTick(callback, err, result)
    return { then: noop, catch: noop, abort: noop }
  }
  return Promise.reject(err)
}

function snakeCaseKeys (acceptedQuerystring, snakeCase, querystring) {
  const target = {}
  const keys = Object.keys(querystring)
  for (let i = 0, len = keys.length; i < len; i++) {
    const key = keys[i]
    target[snakeCase[key] || key] = querystring[key]
  }
  return target
}

function normalizeArguments (params, options, callback) {
  if (typeof options === 'function') {
    callback = options
    options = {}
  }
  if (typeof params === 'function' || params == null) {
    callback = params
    params = {}
    options = {}
  }
  return [params, options, callback]
}

function noop () { }

module.exports = { handleError, snakeCaseKeys, normalizeArguments, noop, kConfigurationError }
