/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.ImageIcon;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.DownSampler;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.HRule;
import org.rrd4j.graph.HSpan;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.LegendComposer;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.Line;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.PlotElement;
import org.rrd4j.graph.PrintText;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;
import org.rrd4j.graph.Source;
import org.rrd4j.graph.SourcedPlotElement;
import org.rrd4j.graph.Stack;
import org.rrd4j.graph.TimeAxis;
import org.rrd4j.graph.VRule;
import org.rrd4j.graph.VSpan;
import org.rrd4j.graph.ValueAxis;
import org.rrd4j.graph.ValueAxisLogarithmic;
import org.rrd4j.graph.ValueAxisMrtg;
import org.rrd4j.graph.ValueScaler;

public class RrdGraph
implements RrdGraphConstants {
    private static final double[] SENSIBLE_VALUES = new double[]{1000.0, 900.0, 800.0, 750.0, 700.0, 600.0, 500.0, 400.0, 300.0, 250.0, 200.0, 125.0, 100.0, 90.0, 80.0, 75.0, 70.0, 60.0, 50.0, 40.0, 30.0, 25.0, 20.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.5, 3.0, 2.5, 2.0, 1.8, 1.5, 1.2, 1.0, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.0, -1.0};
    private static final int SYMBOLS_CENTER = 8;
    private static final char[] SYMBOLS = new char[]{'y', 'z', 'a', 'f', 'p', 'n', '\u00b5', 'm', ' ', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    final RrdGraphDef gdef;
    final ImageParameters im;
    private DataProcessor dproc;
    ImageWorker worker;
    Mapper mapper;
    private final RrdGraphInfo info = new RrdGraphInfo();
    private final String signature;
    private final ImageWriter writer;
    private final ImageWriteParam param;

    public RrdGraph(RrdGraphDef gdef) throws IOException {
        this.gdef = gdef;
        this.signature = gdef.getSignature();
        this.im = new ImageParameters();
        this.worker = new ImageWorker(1, 1);
        this.writer = ImageIO.getImageWritersByFormatName(gdef.imageFormat).next();
        this.param = this.getImageParams();
        try {
            this.createGraph();
        }
        finally {
            this.worker.dispose();
            this.worker = null;
            this.dproc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdGraph(RrdGraphDef gdef, ImageWriter writer, ImageWriteParam param) throws IOException {
        this.gdef = gdef;
        this.signature = gdef.getSignature();
        this.im = new ImageParameters();
        this.worker = new ImageWorker(1, 1);
        this.writer = writer;
        this.param = param;
        try {
            this.createGraph();
        }
        finally {
            this.worker.dispose();
            this.worker = null;
            this.dproc = null;
        }
    }

    public RrdGraphInfo getRrdGraphInfo() {
        return this.info;
    }

    private ImageWriteParam getImageParams() {
        ImageWriteParam iwp = this.writer.getDefaultWriteParam();
        ImageWriterSpi imgProvider = this.writer.getOriginatingProvider();
        if (!imgProvider.isFormatLossless()) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(this.gdef.imageQuality);
        }
        if (iwp.canWriteProgressive()) {
            iwp.setProgressiveMode(this.gdef.interlaced ? 1 : 0);
        }
        return iwp;
    }

    private void createGraph() throws IOException {
        boolean lazy = this.lazyCheck();
        if (!lazy || this.gdef.printStatementCount() != 0) {
            this.fetchData();
            this.resolveTextElements();
            if (this.gdef.shouldPlot() && !lazy) {
                this.initializeLimits();
                this.calculatePlotValues();
                this.findMinMaxValues();
                this.identifySiUnit();
                this.expandValueRange();
                this.removeOutOfRangeRules();
                this.removeOutOfRangeSpans();
                this.mapper = new Mapper(this);
                this.placeLegends();
                this.createImageWorker();
                this.drawBackground();
                this.drawData();
                this.drawGrid();
                this.drawAxis();
                this.drawText();
                this.drawLegend();
                this.drawRules();
                this.drawSpans();
                this.gator();
                this.drawOverlay();
                this.saveImage();
            }
        }
        this.collectInfo();
    }

    private void collectInfo() {
        this.info.filename = this.gdef.filename;
        this.info.width = this.im.xgif;
        this.info.height = this.im.ygif;
        for (CommentText comment : this.gdef.comments) {
            PrintText pt;
            if (!(comment instanceof PrintText) || !(pt = (PrintText)comment).isPrint()) continue;
            this.info.addPrintLine(pt.resolvedText);
        }
        if (this.gdef.imageInfo != null) {
            this.info.imgInfo = Util.sprintf(this.gdef.locale, this.gdef.imageInfo, this.gdef.filename, this.im.xgif, this.im.ygif);
        }
    }

    private void saveImage() throws IOException {
        this.info.stream = !"-".equals(this.gdef.filename) ? this.worker.saveImage(this.gdef.filename, this.writer, this.param) : this.worker.getImageBytes(this.writer, this.param);
    }

    private void drawOverlay() throws IOException {
        if (this.gdef.overlayImage != null) {
            this.worker.loadImage(this.gdef.overlayImage, 0, 0, this.im.xgif, this.im.ygif);
        }
    }

    private void gator() {
        if (!this.gdef.onlyGraph && this.gdef.showSignature) {
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            Font font = this.gdef.getFont(FONTTAG_WATERMARK);
            int x = (int)((double)(this.im.xgif - 2) - this.worker.getFontAscent(font));
            int y = 4;
            this.worker.transform(x, y, 1.5707963267948966);
            this.worker.drawString(this.signature, 0, 0, font, Color.LIGHT_GRAY);
            this.worker.reset();
            this.worker.setTextAntiAliasing(false);
        }
    }

    private void drawRules() {
        this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
        for (PlotElement pe : this.gdef.plotElements) {
            if (pe instanceof HRule) {
                HRule hr = (HRule)pe;
                if (!(hr.value >= this.im.minval) || !(hr.value <= this.im.maxval)) continue;
                int y = this.mapper.ytr(hr.value);
                this.worker.drawLine(this.im.xorigin, y, this.im.xorigin + this.im.xsize, y, hr.color, hr.stroke);
                continue;
            }
            if (!(pe instanceof VRule)) continue;
            VRule vr = (VRule)pe;
            if (vr.timestamp < this.im.start || vr.timestamp > this.im.end) continue;
            int x = this.mapper.xtr(vr.timestamp);
            this.worker.drawLine(x, this.im.yorigin, x, this.im.yorigin - this.im.ysize, vr.color, vr.stroke);
        }
        this.worker.reset();
    }

    private void drawSpans() {
        this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
        for (PlotElement pe : this.gdef.plotElements) {
            if (pe instanceof HSpan) {
                HSpan hr = (HSpan)pe;
                int ys = this.mapper.ytr(hr.start);
                int ye = this.mapper.ytr(hr.end);
                int height = ys - ye;
                this.worker.fillRect(this.im.xorigin, ys - height, this.im.xsize, height, hr.color);
                continue;
            }
            if (!(pe instanceof VSpan)) continue;
            VSpan vr = (VSpan)pe;
            int xs = this.mapper.xtr(vr.start);
            int xe = this.mapper.xtr(vr.end);
            this.worker.fillRect(xs, this.im.yorigin - this.im.ysize, xe - xs, this.im.ysize, vr.color);
        }
        this.worker.reset();
    }

    private void drawText() {
        if (!this.gdef.onlyGraph) {
            int y;
            int x;
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            if (this.gdef.title != null) {
                x = this.im.xgif / 2 - (int)(this.worker.getStringWidth(this.gdef.title, this.gdef.getFont(FONTTAG_TITLE)) / 2.0);
                y = 12 + (int)this.worker.getFontAscent(this.gdef.getFont(FONTTAG_TITLE));
                this.worker.drawString(this.gdef.title, x, y, this.gdef.getFont(FONTTAG_TITLE), this.gdef.getColor(ElementsNames.font));
            }
            if (this.gdef.verticalLabel != null) {
                x = 10;
                y = this.im.yorigin - this.im.ysize / 2 + (int)this.worker.getStringWidth(this.gdef.verticalLabel, this.gdef.getFont(FONTTAG_UNIT)) / 2;
                int ascent = (int)this.worker.getFontAscent(this.gdef.getFont(FONTTAG_UNIT));
                this.worker.transform(x, y, -1.5707963267948966);
                this.worker.drawString(this.gdef.verticalLabel, 0, ascent, this.gdef.getFont(FONTTAG_UNIT), this.gdef.getColor(ElementsNames.font));
                this.worker.reset();
            }
            this.worker.setTextAntiAliasing(false);
        }
    }

    private void drawGrid() {
        if (!this.gdef.onlyGraph) {
            boolean ok;
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            Paint shade1 = this.gdef.getColor(ElementsNames.shadea);
            Paint shade2 = this.gdef.getColor(ElementsNames.shadeb);
            BasicStroke borderStroke = new BasicStroke(1.0f);
            this.worker.drawLine(0, 0, this.im.xgif - 1, 0, shade1, borderStroke);
            this.worker.drawLine(1, 1, this.im.xgif - 2, 1, shade1, borderStroke);
            this.worker.drawLine(0, 0, 0, this.im.ygif - 1, shade1, borderStroke);
            this.worker.drawLine(1, 1, 1, this.im.ygif - 2, shade1, borderStroke);
            this.worker.drawLine(this.im.xgif - 1, 0, this.im.xgif - 1, this.im.ygif - 1, shade2, borderStroke);
            this.worker.drawLine(0, this.im.ygif - 1, this.im.xgif - 1, this.im.ygif - 1, shade2, borderStroke);
            this.worker.drawLine(this.im.xgif - 2, 1, this.im.xgif - 2, this.im.ygif - 2, shade2, borderStroke);
            this.worker.drawLine(1, this.im.ygif - 2, this.im.xgif - 2, this.im.ygif - 2, shade2, borderStroke);
            if (this.gdef.drawXGrid) {
                new TimeAxis(this).draw();
            }
            if (this.gdef.drawYGrid && !(ok = this.gdef.altYMrtg ? new ValueAxisMrtg(this).draw() : (this.gdef.logarithmic ? new ValueAxisLogarithmic(this).draw() : new ValueAxis(this).draw()))) {
                String msg = "No Data Found";
                this.worker.drawString(msg, this.im.xgif / 2 - (int)this.worker.getStringWidth(msg, this.gdef.getFont(FONTTAG_TITLE)) / 2, (2 * this.im.yorigin - this.im.ysize) / 2, this.gdef.getFont(FONTTAG_TITLE), this.gdef.getColor(ElementsNames.font));
            }
            this.worker.setTextAntiAliasing(false);
        }
    }

    private void drawData() {
        this.worker.setAntiAliasing(this.gdef.antiAliasing);
        this.worker.clip(this.im.xorigin, this.im.yorigin - this.gdef.height - 1, this.gdef.width, this.gdef.height + 2);
        double areazero = this.mapper.ytr(this.im.minval > 0.0 ? this.im.minval : (this.im.maxval < 0.0 ? this.im.maxval : 0.0));
        double[] x = this.gdef.downsampler == null ? this.xtr(this.dproc.getTimestamps()) : null;
        double[] lastY = null;
        for (PlotElement plotElement : this.gdef.plotElements) {
            double[] y;
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            SourcedPlotElement source = (SourcedPlotElement)plotElement;
            if (this.gdef.downsampler != null) {
                DownSampler.DataSet set = this.gdef.downsampler.downsize(this.dproc.getTimestamps(), source.getValues());
                x = this.xtr(set.timestamps);
                y = this.ytr(set.values);
            } else {
                y = this.ytr(source.getValues());
            }
            if (Line.class.isAssignableFrom(source.getClass())) {
                this.worker.drawPolyline(x, y, source.color, (Stroke)((Line)source).stroke);
            } else if (Area.class.isAssignableFrom(source.getClass())) {
                if (source.parent == null) {
                    this.worker.fillPolygon(x, areazero, y, source.color);
                } else {
                    this.worker.fillPolygon(x, lastY, y, source.color);
                    this.worker.drawPolyline(x, lastY, source.getParentColor(), (Stroke)new BasicStroke(0.0f));
                }
            } else if (source instanceof Stack) {
                Stack stack = (Stack)source;
                float width = stack.getParentLineWidth();
                if (width >= 0.0f) {
                    this.worker.drawPolyline(x, y, stack.color, (Stroke)new BasicStroke(width));
                } else {
                    this.worker.fillPolygon(x, lastY, y, stack.color);
                    this.worker.drawPolyline(x, lastY, stack.getParentColor(), (Stroke)new BasicStroke(0.0f));
                }
            } else {
                throw new IllegalStateException("Unknown plot source: " + source.getClass().getName());
            }
            lastY = y;
        }
        this.worker.reset();
        this.worker.setAntiAliasing(false);
    }

    private void drawAxis() {
        if (!this.gdef.onlyGraph) {
            Paint gridColor = this.gdef.getColor(ElementsNames.grid);
            Paint xaxisColor = this.gdef.getColor(ElementsNames.xaxis);
            Paint yaxisColor = this.gdef.getColor(ElementsNames.yaxis);
            Paint arrowColor = this.gdef.getColor(ElementsNames.arrow);
            BasicStroke stroke = new BasicStroke(1.0f);
            this.worker.drawLine(this.im.xorigin + this.im.xsize, this.im.yorigin, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin - 4, this.im.yorigin, this.im.xorigin + this.im.xsize + 4, this.im.yorigin, xaxisColor, stroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin + 4, this.im.xorigin, this.im.yorigin - this.im.ysize - 4, yaxisColor, stroke);
            double[] Xarrow_x = new double[]{this.im.xorigin + this.im.xsize + 4, this.im.xorigin + this.im.xsize + 9, this.im.xorigin + this.im.xsize + 4};
            double[] Xarrow_y = new double[]{this.im.yorigin - 3, this.im.yorigin + 0, this.im.yorigin + 3};
            this.worker.fillPolygon(Xarrow_x, (double)this.im.yorigin + 3.0, Xarrow_y, arrowColor);
            double[] Yarrow_x = new double[]{this.im.xorigin - 3, this.im.xorigin, this.im.xorigin + 3};
            double[] Yarrow_y = new double[]{this.im.yorigin - this.im.ysize - 4, this.im.yorigin - this.im.ysize - 9, this.im.yorigin - this.im.ysize - 4};
            this.worker.fillPolygon(Yarrow_x, (double)(this.im.yorigin - this.im.ysize) - 4.0, Yarrow_y, arrowColor);
        }
    }

    private void drawBackground() throws IOException {
        this.worker.fillRect(0, 0, this.im.xgif, this.im.ygif, this.gdef.getColor(ElementsNames.back));
        if (this.gdef.backgroundImage != null) {
            this.worker.loadImage(this.gdef.backgroundImage, 0, 0, this.im.xgif, this.im.ygif);
        }
        if (this.gdef.canvasImage != null) {
            this.worker.loadImage(this.gdef.canvasImage, this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xsize, this.im.ysize);
        }
        this.worker.fillRect(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xsize, this.im.ysize, this.gdef.getColor(ElementsNames.canvas));
    }

    private void createImageWorker() {
        this.worker.resize(this.im.xgif, this.im.ygif);
    }

    private void placeLegends() {
        if (!this.gdef.noLegend && !this.gdef.onlyGraph) {
            int border = (int)(this.getFontCharWidth(RrdGraphConstants.FontTag.LEGEND) * 2.0);
            LegendComposer lc = new LegendComposer(this, border, this.im.ygif, this.im.xgif - 2 * border);
            this.im.ygif = lc.placeComments() + 6;
        }
    }

    private void initializeLimits() {
        this.im.xsize = this.gdef.width;
        this.im.ysize = this.gdef.height;
        this.im.unitslength = this.gdef.unitsLength;
        this.im.xorigin = this.gdef.onlyGraph ? 0 : (int)(10.0 + (double)this.im.unitslength * this.getFontCharWidth(RrdGraphConstants.FontTag.UNIT));
        if (!this.gdef.onlyGraph && this.gdef.verticalLabel != null) {
            this.im.xorigin = (int)((double)this.im.xorigin + this.getFontHeight(FONTTAG_UNIT));
        }
        this.im.yorigin = this.gdef.onlyGraph ? this.im.ysize : 12 + this.im.ysize;
        if (!this.gdef.onlyGraph && this.gdef.title != null) {
            this.im.yorigin = (int)((double)this.im.yorigin + (this.getFontHeight(FONTTAG_TITLE) + 6.0));
        }
        if (this.gdef.onlyGraph) {
            this.im.xgif = this.im.xsize;
            this.im.ygif = this.im.yorigin;
        } else {
            this.im.xgif = 16 + this.im.xsize + this.im.xorigin;
            this.im.ygif = this.im.yorigin + (int)(2.0 * this.getFontHeight(FONTTAG_DEFAULT));
        }
    }

    private void removeOutOfRangeRules() {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (plotElement instanceof HRule) {
                ((HRule)plotElement).setLegendVisibility(this.im.minval, this.im.maxval, this.gdef.forceRulesLegend);
                continue;
            }
            if (!(plotElement instanceof VRule)) continue;
            ((VRule)plotElement).setLegendVisibility(this.im.start, this.im.end, this.gdef.forceRulesLegend);
        }
    }

    private void removeOutOfRangeSpans() {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (plotElement instanceof HSpan) {
                ((HSpan)plotElement).setLegendVisibility(this.im.minval, this.im.maxval, this.gdef.forceRulesLegend);
                continue;
            }
            if (!(plotElement instanceof VSpan)) continue;
            ((VSpan)plotElement).setLegendVisibility(this.im.start, this.im.end, this.gdef.forceRulesLegend);
        }
    }

    private void expandValueRange() {
        this.im.ygridstep = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.gridStep : Double.NaN;
        int n = this.im.ylabfact = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.labelFactor : 0;
        if (!this.gdef.rigid && !this.gdef.logarithmic) {
            if (Double.isNaN(this.im.ygridstep)) {
                if (this.gdef.altYMrtg) {
                    double scaled_max;
                    double scaled_min;
                    this.im.decimals = Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                    this.im.quadrant = 0;
                    if (this.im.minval < 0.0) {
                        this.im.quadrant = 2;
                        if (this.im.maxval <= 0.0) {
                            this.im.quadrant = 4;
                        }
                    }
                    switch (this.im.quadrant) {
                        case 2: {
                            this.im.scaledstep = Math.ceil(50.0 * Math.pow(10.0, -this.im.decimals) * Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaled_min = -2.0 * this.im.scaledstep;
                            scaled_max = 2.0 * this.im.scaledstep;
                            break;
                        }
                        case 4: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * Math.abs(this.im.minval)) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaled_min = -4.0 * this.im.scaledstep;
                            scaled_max = 0.0;
                            break;
                        }
                        default: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * this.im.maxval) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaled_min = 0.0;
                            scaled_max = 4.0 * this.im.scaledstep;
                        }
                    }
                    this.im.minval = scaled_min;
                    this.im.maxval = scaled_max;
                } else if (this.gdef.altAutoscale || this.gdef.altAutoscaleMin && this.gdef.altAutoscaleMax) {
                    double delt = this.im.maxval - this.im.minval;
                    double adj = delt * 0.1;
                    double fact = 2.0 * Math.pow(10.0, Math.floor(Math.log10(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval)))) - 2.0);
                    if (delt < fact) {
                        adj = (fact - delt) * 0.55;
                    }
                    this.im.minval -= adj;
                    this.im.maxval += adj;
                } else if (this.gdef.altAutoscaleMin) {
                    double adj = (this.im.maxval - this.im.minval) * 0.1;
                    this.im.minval -= adj;
                } else if (this.gdef.altAutoscaleMax) {
                    double adj = (this.im.maxval - this.im.minval) * 0.1;
                    this.im.maxval += adj;
                } else {
                    double scaled_min = this.im.minval / this.im.magfact;
                    double scaled_max = this.im.maxval / this.im.magfact;
                    int i = 1;
                    while (SENSIBLE_VALUES[i] > 0.0) {
                        if (SENSIBLE_VALUES[i - 1] >= scaled_min && SENSIBLE_VALUES[i] <= scaled_min) {
                            this.im.minval = SENSIBLE_VALUES[i] * this.im.magfact;
                        }
                        if (-SENSIBLE_VALUES[i - 1] <= scaled_min && -SENSIBLE_VALUES[i] >= scaled_min) {
                            this.im.minval = -SENSIBLE_VALUES[i - 1] * this.im.magfact;
                        }
                        if (SENSIBLE_VALUES[i - 1] >= scaled_max && SENSIBLE_VALUES[i] <= scaled_max) {
                            this.im.maxval = SENSIBLE_VALUES[i - 1] * this.im.magfact;
                        }
                        if (-SENSIBLE_VALUES[i - 1] <= scaled_max && -SENSIBLE_VALUES[i] >= scaled_max) {
                            this.im.maxval = -SENSIBLE_VALUES[i] * this.im.magfact;
                        }
                        ++i;
                    }
                }
            } else {
                this.im.minval = (double)this.im.ylabfact * this.im.ygridstep * Math.floor(this.im.minval / ((double)this.im.ylabfact * this.im.ygridstep));
                this.im.maxval = (double)this.im.ylabfact * this.im.ygridstep * Math.ceil(this.im.maxval / ((double)this.im.ylabfact * this.im.ygridstep));
            }
        }
    }

    private void identifySiUnit() {
        this.im.unitsexponent = this.gdef.unitsExponent;
        this.im.base = this.gdef.base;
        if (!this.gdef.logarithmic) {
            double digits = this.im.unitsexponent != Integer.MAX_VALUE ? Math.floor((double)this.im.unitsexponent / 3.0) : Math.floor(Math.log(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval))) / Math.log(this.im.base));
            this.im.magfact = Math.pow(this.im.base, digits);
            this.im.symbol = digits + 8.0 < (double)SYMBOLS.length && digits + 8.0 >= 0.0 ? SYMBOLS[(int)digits + 8] : (char)63;
        }
    }

    private void findMinMaxValues() {
        double minval = Double.NaN;
        double maxval = Double.NaN;
        for (PlotElement pe : this.gdef.plotElements) {
            if (!(pe instanceof SourcedPlotElement)) continue;
            minval = Util.min(((SourcedPlotElement)pe).getMinValue(), minval);
            maxval = Util.max(((SourcedPlotElement)pe).getMaxValue(), maxval);
        }
        if (Double.isNaN(minval)) {
            minval = 0.0;
        }
        if (Double.isNaN(maxval)) {
            maxval = 1.0;
        }
        this.im.minval = this.gdef.minValue;
        this.im.maxval = this.gdef.maxValue;
        if (Double.isNaN(this.im.minval) || !this.gdef.logarithmic && !this.gdef.rigid && this.im.minval > minval) {
            this.im.minval = minval;
        }
        if (Double.isNaN(this.im.maxval) || !this.gdef.rigid && this.im.maxval < maxval) {
            this.im.maxval = this.gdef.logarithmic ? maxval * 1.1 : maxval;
        }
        if (this.im.minval > this.im.maxval) {
            this.im.minval = 0.99 * this.im.maxval;
        }
        if (Math.abs(this.im.minval - this.im.maxval) < 1.0E-7) {
            this.im.maxval *= 1.01;
            if (!this.gdef.logarithmic) {
                this.im.minval *= 0.99;
            }
            if (this.im.maxval == 0.0) {
                this.im.maxval = 1.0;
            }
        }
    }

    private void calculatePlotValues() {
        for (PlotElement pe : this.gdef.plotElements) {
            if (!(pe instanceof SourcedPlotElement)) continue;
            ((SourcedPlotElement)pe).assignValues(this.dproc);
        }
    }

    private void resolveTextElements() {
        ValueScaler valueScaler = new ValueScaler(this.gdef.base);
        for (CommentText comment : this.gdef.comments) {
            comment.resolveText(this.gdef.locale, this.dproc, valueScaler);
        }
    }

    private void fetchData() throws IOException {
        this.dproc = new DataProcessor(this.gdef.startTime, this.gdef.endTime);
        this.dproc.setPixelCount(this.im.xsize);
        if (this.gdef.poolUsed) {
            this.dproc.setPoolUsed(this.gdef.poolUsed);
            this.dproc.setPool(this.gdef.getPool());
        }
        this.dproc.setTimeZone(this.gdef.tz);
        if (this.gdef.step > 0L) {
            this.dproc.setStep(this.gdef.step);
            this.dproc.setFetchRequestResolution(this.gdef.step);
        }
        for (Source src : this.gdef.sources) {
            src.requestData(this.dproc);
        }
        this.dproc.processData();
        this.im.start = this.gdef.startTime;
        this.im.end = this.gdef.endTime;
    }

    private boolean lazyCheck() throws IOException {
        if (!this.gdef.lazy || !Util.fileExists(this.gdef.filename)) {
            return false;
        }
        long secPerPixel = (this.gdef.endTime - this.gdef.startTime) / (long)this.gdef.width;
        long elapsed = Util.getTimestamp() - Util.getLastModifiedTime(this.gdef.filename);
        return elapsed <= secPerPixel;
    }

    private void drawLegend() {
        if (!this.gdef.onlyGraph && !this.gdef.noLegend) {
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            int ascent = (int)this.worker.getFontAscent(this.gdef.getFont(FONTTAG_LEGEND));
            int box = (int)this.getBox();
            int boxSpace = (int)this.getBoxSpace();
            for (CommentText c : this.gdef.comments) {
                if (!c.isValidGraphElement()) continue;
                int x = c.x;
                int y = c.y + ascent;
                if (c instanceof LegendText) {
                    this.worker.fillRect(x, y - box, box, box, this.gdef.getColor(ElementsNames.frame));
                    this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, this.gdef.getColor(ElementsNames.canvas));
                    this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, this.gdef.getColor(ElementsNames.back));
                    this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, ((LegendText)c).legendColor);
                    this.worker.drawString(c.resolvedText, x + boxSpace, y, this.gdef.getFont(FONTTAG_LEGEND), this.gdef.getColor(ElementsNames.font));
                    continue;
                }
                this.worker.drawString(c.resolvedText, x, y, this.gdef.getFont(FONTTAG_LEGEND), this.gdef.getColor(ElementsNames.font));
            }
            this.worker.setTextAntiAliasing(false);
        }
    }

    double getFontHeight(RrdGraphConstants.FontTag fonttag) {
        return this.worker.getFontHeight(this.gdef.getFont(fonttag));
    }

    double getFontCharWidth(RrdGraphConstants.FontTag fonttag) {
        return this.worker.getStringWidth("a", this.gdef.getFont(fonttag));
    }

    @Deprecated
    double getSmallFontHeight() {
        return this.getFontHeight(FONTTAG_LEGEND);
    }

    double getTitleFontHeight() {
        return this.getFontHeight(FONTTAG_TITLE);
    }

    double getInterlegendSpace() {
        return this.getFontCharWidth(FONTTAG_LEGEND) * 2.0;
    }

    double getLeading() {
        return this.getFontHeight(FONTTAG_LEGEND) * 1.2;
    }

    double getSmallLeading() {
        return this.getFontHeight(FONTTAG_LEGEND) * 0.7;
    }

    double getBoxSpace() {
        return Math.ceil(this.getFontHeight(FONTTAG_LEGEND) * 1.2);
    }

    private double getBox() {
        return this.getFontHeight(FONTTAG_LEGEND) * 0.9;
    }

    private double[] xtr(long[] timestamps) {
        double[] timestampsDev = new double[2 * timestamps.length - 1];
        int i = 0;
        int j = 0;
        while (i < timestamps.length) {
            timestampsDev[j] = this.mapper.xtr(timestamps[i]);
            if (i < timestamps.length - 1) {
                timestampsDev[j + 1] = timestampsDev[j];
            }
            ++i;
            j += 2;
        }
        return timestampsDev;
    }

    private double[] ytr(double[] values) {
        double[] valuesDev = new double[2 * values.length - 1];
        int i = 0;
        int j = 0;
        while (i < values.length) {
            valuesDev[j] = Double.isNaN(values[i]) ? Double.NaN : (double)this.mapper.ytr(values[i]);
            if (j > 0) {
                valuesDev[j - 1] = valuesDev[j];
            }
            ++i;
            j += 2;
        }
        return valuesDev;
    }

    public void render(Graphics g) {
        byte[] imageData = this.getRrdGraphInfo().getBytes();
        ImageIcon image = new ImageIcon(imageData);
        image.paintIcon(null, g, 0, 0);
    }
}

