"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addNotificationsMethods = addNotificationsMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addNotificationsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_CHANNEl] = createAction({
    url: {
      fmt: '/_plugins/_notifications/configs/<%=id%>',
      req: {
        id: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_CHANNElS] = createAction({
    url: {
      fmt: '/_plugins/_notifications/channels'
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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