function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import moment from 'moment-timezone';
import { METRIC_TYPE } from './';
export class ApplicationUsage {
  constructor() {
    _defineProperty(this, "currentUsage", void 0);
  }

  start() {
    // Count any clicks and assign it to the current app
    if (window) window.addEventListener('click', () => this.currentUsage && this.currentUsage.numberOfClicks++);
  }

  appChanged(appId) {
    const currentUsage = this.currentUsage;

    if (appId) {
      this.currentUsage = {
        type: METRIC_TYPE.APPLICATION_USAGE,
        appId,
        startTime: moment(),
        numberOfClicks: 0
      };
    } else {
      this.currentUsage = void 0;
    }

    return currentUsage;
  }

}