/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.Vertx;
import java.util.List;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.core.Context.class)
public class Context {
    public static final TypeArg<Context> __TYPE_ARG = new TypeArg(obj -> new Context((io.vertx.core.Context)obj), Context::getDelegate);
    private final io.vertx.core.Context delegate;

    public Context(io.vertx.core.Context delegate) {
        this.delegate = delegate;
    }

    public Context(Object delegate) {
        this.delegate = (io.vertx.core.Context)delegate;
    }

    Context() {
        this.delegate = null;
    }

    public io.vertx.core.Context getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context that = (Context)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static boolean isOnWorkerThread() {
        boolean ret = io.vertx.core.Context.isOnWorkerThread();
        return ret;
    }

    public static boolean isOnEventLoopThread() {
        boolean ret = io.vertx.core.Context.isOnEventLoopThread();
        return ret;
    }

    public static boolean isOnVertxThread() {
        boolean ret = io.vertx.core.Context.isOnVertxThread();
        return ret;
    }

    private void __runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public void runOnContext(Runnable action) {
        this.__runOnContext((Handler<Void>)((Handler)ignored -> action.run()));
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(final Uni<T> blockingCodeHandler, boolean ordered) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(new Handler<Promise<T>>(){

            public void handle(Promise<T> event) {
                blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
            }
        }, ordered, resultHandler));
    }

    public <T> T executeBlockingAndAwait(Uni<T> blockingCodeHandler, boolean ordered) {
        return (T)this.executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
    }

    public <T> void executeBlockingAndForget(Uni<T> blockingCodeHandler, boolean ordered) {
        this.executeBlocking(blockingCodeHandler, ordered).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(final Uni<T> blockingCodeHandler) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(new Handler<Promise<T>>(){

            public void handle(Promise<T> event) {
                blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
            }
        }, resultHandler));
    }

    public <T> T executeBlockingAndAwait(Uni<T> blockingCodeHandler) {
        return (T)this.executeBlocking(blockingCodeHandler).await().indefinitely();
    }

    public <T> void executeBlockingAndForget(Uni<T> blockingCodeHandler) {
        this.executeBlocking(blockingCodeHandler).subscribe().with(UniHelper.NOOP);
    }

    public String deploymentID() {
        String ret = this.delegate.deploymentID();
        return ret;
    }

    public JsonObject config() {
        JsonObject ret = this.delegate.config();
        return ret;
    }

    public List<String> processArgs() {
        List ret = this.delegate.processArgs();
        return ret;
    }

    public boolean isEventLoopContext() {
        boolean ret = this.delegate.isEventLoopContext();
        return ret;
    }

    public boolean isWorkerContext() {
        boolean ret = this.delegate.isWorkerContext();
        return ret;
    }

    public <T> T get(Object key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public void put(Object key, Object value) {
        this.delegate.put(key, value);
    }

    public boolean remove(Object key) {
        boolean ret = this.delegate.remove(key);
        return ret;
    }

    public <T> T getLocal(Object key) {
        Object ret = this.delegate.getLocal(key);
        return (T)ret;
    }

    public void putLocal(Object key, Object value) {
        this.delegate.putLocal(key, value);
    }

    public boolean removeLocal(Object key) {
        boolean ret = this.delegate.removeLocal(key);
        return ret;
    }

    public Vertx owner() {
        Vertx ret = Vertx.newInstance(this.delegate.owner());
        return ret;
    }

    public int getInstanceCount() {
        int ret = this.delegate.getInstanceCount();
        return ret;
    }

    @Fluent
    private Context __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Context exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    public static Context newInstance(io.vertx.core.Context arg) {
        return arg != null ? new Context(arg) : null;
    }
}

