/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.StringPermission;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.quarkus.vertx.http.runtime.security.RolesAllowedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.SupplierImpl;
import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class HttpSecurityRecorder {
    private static final Logger log = Logger.getLogger(HttpSecurityRecorder.class);
    protected static final Consumer<Throwable> NOOP_CALLBACK = new Consumer<Throwable>(){

        @Override
        public void accept(Throwable throwable) {
        }
    };
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    final HttpBuildTimeConfig buildTimeConfig;
    static volatile String encryptionKey;

    public HttpSecurityRecorder(RuntimeValue<HttpConfiguration> httpConfiguration, HttpBuildTimeConfig buildTimeConfig) {
        this.httpConfiguration = httpConfiguration;
        this.buildTimeConfig = buildTimeConfig;
    }

    public Handler<RoutingContext> authenticationMechanismHandler(boolean proactiveAuthentication) {
        return new HttpAuthenticationHandler(proactiveAuthentication);
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (HttpAuthorizer)CDI.current().select(HttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public BeanContainerListener initPermissions(final HttpBuildTimeConfig buildTimeConfig, final Map<String, Supplier<HttpSecurityPolicy>> policies) {
        return new BeanContainerListener(){

            public void created(BeanContainer container) {
                ((PathMatchingHttpSecurityPolicy)container.beanInstance(PathMatchingHttpSecurityPolicy.class, new Annotation[0])).init(buildTimeConfig.auth.permissions, policies, buildTimeConfig.rootPath);
            }
        };
    }

    public Supplier<FormAuthenticationMechanism> setupFormAuth() {
        return new Supplier<FormAuthenticationMechanism>(){

            @Override
            public FormAuthenticationMechanism get() {
                String key;
                if (!((HttpConfiguration)HttpSecurityRecorder.this.httpConfiguration.getValue()).encryptionKey.isPresent()) {
                    if (encryptionKey != null) {
                        key = encryptionKey;
                    } else {
                        byte[] data = new byte[32];
                        new SecureRandom().nextBytes(data);
                        key = encryptionKey = Base64.getEncoder().encodeToString(data);
                        log.warn((Object)("Encryption key was not specified for persistent FORM auth, using temporary key " + key));
                    }
                } else {
                    key = ((HttpConfiguration)HttpSecurityRecorder.this.httpConfiguration.getValue()).encryptionKey.get();
                }
                FormAuthConfig form = HttpSecurityRecorder.this.buildTimeConfig.auth.form;
                PersistentLoginManager loginManager = new PersistentLoginManager(key, form.cookieName, form.timeout.toMillis(), form.newCookieInterval.toMillis(), form.httpOnlyCookie, form.cookieSameSite.name(), form.cookiePath.orElse(null));
                String loginPage = HttpSecurityRecorder.startWithSlash(form.loginPage.orElse(null));
                String errorPage = HttpSecurityRecorder.startWithSlash(form.errorPage.orElse(null));
                String landingPage = HttpSecurityRecorder.startWithSlash(form.landingPage.orElse(null));
                String postLocation = HttpSecurityRecorder.startWithSlash(form.postLocation);
                String usernameParameter = form.usernameParameter;
                String passwordParameter = form.passwordParameter;
                String locationCookie = form.locationCookie;
                String cookiePath = form.cookiePath.orElse(null);
                boolean redirectAfterLogin = form.redirectAfterLogin;
                return new FormAuthenticationMechanism(loginPage, postLocation, usernameParameter, passwordParameter, errorPage, landingPage, redirectAfterLogin, locationCookie, form.cookieSameSite.name(), cookiePath, loginManager);
            }
        };
    }

    private static String startWithSlash(String page) {
        if (page == null) {
            return null;
        }
        return page.startsWith("/") ? page : "/" + page;
    }

    public Supplier<?> setupBasicAuth(final HttpBuildTimeConfig buildTimeConfig) {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return new BasicAuthenticationMechanism((String)buildTimeConfig.auth.realm.orElse(null), buildTimeConfig.auth.form.enabled);
            }
        };
    }

    public Supplier<?> setupMtlsClientAuth() {
        return new Supplier<MtlsAuthenticationMechanism>(){

            @Override
            public MtlsAuthenticationMechanism get() {
                return new MtlsAuthenticationMechanism();
            }
        };
    }

    public Handler<RoutingContext> formAuthPostHandler() {
        return new Handler<RoutingContext>(){

            public void handle(final RoutingContext event) {
                Uni user = (Uni)event.get("io.quarkus.vertx.http.deferred-identity");
                user.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                    public void onSubscribe(UniSubscription uniSubscription) {
                    }

                    public void onItem(SecurityIdentity securityIdentity) {
                        event.next();
                    }

                    public void onFailure(Throwable throwable) {
                        event.fail(throwable);
                    }
                });
            }
        };
    }

    public BiFunction<String, String[], Permission> stringPermissionCreator() {
        return StringPermission::new;
    }

    public BiFunction<String, String[], Permission> customPermissionCreator(final String clazz, final boolean acceptsActions) {
        return new BiFunction<String, String[], Permission>(){

            @Override
            public Permission apply(String name, String[] actions) {
                try {
                    if (acceptsActions) {
                        return (Permission)HttpSecurityRecorder.loadClass(clazz).getConstructors()[0].newInstance(name, actions);
                    }
                    return (Permission)HttpSecurityRecorder.loadClass(clazz).getConstructors()[0].newInstance(name);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("Failed to create Permission - class '%s', name '%s', actions '%s'", clazz, name, Arrays.toString(actions)), e);
                }
            }
        };
    }

    public Supplier<HttpSecurityPolicy> createRolesAllowedPolicy(List<String> rolesAllowed, Map<String, List<String>> roleToPermissionsStr, BiFunction<String, String[], Permission> permissionCreator) {
        Map<String, Set<Permission>> roleToPermissions = HttpSecurityRecorder.createPermissions(roleToPermissionsStr, permissionCreator);
        return new SupplierImpl<HttpSecurityPolicy>(new RolesAllowedHttpSecurityPolicy(rolesAllowed, roleToPermissions));
    }

    private static Map<String, Set<Permission>> createPermissions(Map<String, List<String>> roleToPermissions, BiFunction<String, String[], Permission> permissionCreator) {
        HashMap result = new HashMap();
        for (Map.Entry<String, List<String>> e : roleToPermissions.entrySet()) {
            HashMap<String, PermissionToActions> cache = new HashMap<String, PermissionToActions>();
            String role = e.getKey();
            for (String permissionToAction : e.getValue()) {
                HttpSecurityRecorder.addPermissionToAction(cache, role, permissionToAction);
            }
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (PermissionToActions permission : cache.values()) {
                permissions.add(permission.create(permissionCreator));
            }
            result.put(role, Set.copyOf(permissions));
        }
        return Map.copyOf(result);
    }

    private static void addPermissionToAction(Map<String, PermissionToActions> cache, String role, String permissionToAction) {
        String action;
        String permissionName;
        if (permissionToAction.contains(":")) {
            String[] permToActions = permissionToAction.split(":");
            if (permToActions.length != 2) {
                throw new ConfigurationException(String.format("Invalid permission format '%s', please use exactly one permission to action separator", permissionToAction));
            }
            permissionName = permToActions[0].trim();
            action = permToActions[1].trim();
        } else {
            permissionName = permissionToAction.trim();
            action = null;
        }
        if (permissionName.isEmpty()) {
            throw new ConfigurationException(String.format("Invalid permission name '%s' for role '%s'", permissionToAction, role));
        }
        cache.computeIfAbsent(permissionName, new Function<String, PermissionToActions>(){

            @Override
            public PermissionToActions apply(String s) {
                return new PermissionToActions(s);
            }
        }).addAction(action);
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class '" + className + "' for creating permission", e);
        }
    }

    private static final class PermissionToActions {
        private final String permissionName;
        private final Set<String> actions;

        private PermissionToActions(String permissionName) {
            this.permissionName = permissionName;
            this.actions = new HashSet<String>();
        }

        private void addAction(String action) {
            if (action != null) {
                this.actions.add(action);
            }
        }

        private Permission create(BiFunction<String, String[], Permission> permissionCreator) {
            return permissionCreator.apply(this.permissionName, this.actions.toArray(new String[0]));
        }
    }

    public static abstract class AbstractAuthenticationHandler
    implements Handler<RoutingContext> {
        volatile HttpAuthenticator authenticator;
        final boolean proactiveAuthentication;

        public AbstractAuthenticationHandler(boolean proactiveAuthentication) {
            this.proactiveAuthentication = proactiveAuthentication;
        }

        public void handle(final RoutingContext event) {
            if (this.authenticator == null) {
                this.authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
            }
            event.put(HttpAuthenticator.class.getName(), (Object)this.authenticator);
            this.setPathMatchingPolicy(event);
            if (this.proactiveAuthentication) {
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new DefaultAuthFailureHandler(){

                    @Override
                    protected void proceed(Throwable throwable) {
                        if (!event.failed()) {
                            event.fail(throwable);
                        }
                    }
                });
            } else {
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new DefaultAuthFailureHandler(){

                    @Override
                    protected void proceed(Throwable throwable) {
                        event.end();
                    }
                });
            }
            if (this.proactiveAuthentication) {
                final Uni potentialUser = this.authenticator.attemptAuthentication(event).memoize().indefinitely();
                potentialUser.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                    public void onSubscribe(UniSubscription subscription) {
                    }

                    public void onItem(SecurityIdentity identity) {
                        if (event.response().ended()) {
                            return;
                        }
                        if (identity == null) {
                            final Uni anon = authenticator.getIdentityProviderManager().authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
                            anon.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                                public void onSubscribe(UniSubscription subscription) {
                                }

                                public void onItem(SecurityIdentity item) {
                                    event.put("io.quarkus.vertx.http.deferred-identity", (Object)anon);
                                    event.setUser((User)new QuarkusHttpUser(item));
                                    event.next();
                                }

                                public void onFailure(Throwable failure) {
                                    BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                                    if (handler != null) {
                                        handler.accept(event, failure);
                                    }
                                }
                            });
                        } else {
                            event.setUser((User)new QuarkusHttpUser(identity));
                            event.put("io.quarkus.vertx.http.deferred-identity", (Object)potentialUser);
                            event.next();
                        }
                    }

                    public void onFailure(Throwable failure) {
                        BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                        if (handler != null) {
                            handler.accept(event, failure);
                        }
                    }
                });
            } else {
                Uni lazyUser = Uni.createFrom().nullItem().flatMap(n -> this.authenticator.attemptAuthentication(event)).memoize().indefinitely().flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                        if (securityIdentity == null) {
                            return authenticator.getIdentityProviderManager().authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
                        }
                        return Uni.createFrom().item((Object)securityIdentity);
                    }
                }).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<SecurityIdentity, Throwable, Boolean>(){

                    public void accept(SecurityIdentity identity, Throwable throwable, Boolean aBoolean) {
                        BiConsumer handler;
                        if (identity != null) {
                            event.setUser((User)new QuarkusHttpUser(identity));
                        } else if (throwable != null && (handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler")) != null) {
                            handler.accept(event, throwable);
                        }
                    }
                }).memoize().indefinitely();
                event.put("io.quarkus.vertx.http.deferred-identity", (Object)lazyUser);
                event.next();
            }
        }

        protected abstract void setPathMatchingPolicy(RoutingContext var1);
    }

    static class HttpAuthenticationHandler
    extends AbstractAuthenticationHandler {
        volatile PathMatchingHttpSecurityPolicy pathMatchingPolicy;

        public HttpAuthenticationHandler(boolean proactiveAuthentication) {
            super(proactiveAuthentication);
        }

        @Override
        protected void setPathMatchingPolicy(RoutingContext event) {
            if (this.pathMatchingPolicy == null) {
                Instance pathMatchingPolicyInstance = CDI.current().select(PathMatchingHttpSecurityPolicy.class, new Annotation[0]);
                PathMatchingHttpSecurityPolicy pathMatchingHttpSecurityPolicy = this.pathMatchingPolicy = pathMatchingPolicyInstance.isResolvable() ? (PathMatchingHttpSecurityPolicy)pathMatchingPolicyInstance.get() : null;
            }
            if (this.pathMatchingPolicy != null) {
                event.put(AbstractPathMatchingHttpSecurityPolicy.class.getName(), (Object)this.pathMatchingPolicy);
            }
        }
    }

    public static abstract class DefaultAuthFailureHandler
    implements BiConsumer<RoutingContext, Throwable> {
        protected DefaultAuthFailureHandler() {
        }

        @Override
        public void accept(final RoutingContext event, Throwable throwable) {
            if (event.response().ended()) {
                return;
            }
            if ((throwable = DefaultAuthFailureHandler.extractRootCause(throwable)) instanceof AuthenticationFailedException) {
                final AuthenticationFailedException authenticationFailedException = (AuthenticationFailedException)throwable;
                DefaultAuthFailureHandler.getAuthenticator(event).sendChallenge(event).subscribe().with((Consumer)new Consumer<Boolean>(){

                    @Override
                    public void accept(Boolean aBoolean) {
                        if (!event.response().ended()) {
                            this.proceed((Throwable)authenticationFailedException);
                        }
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    @Override
                    public void accept(Throwable throwable) {
                        event.fail(throwable);
                    }
                });
            } else if (throwable instanceof AuthenticationCompletionException) {
                log.debug((Object)"Authentication has failed, returning HTTP status 401");
                event.response().setStatusCode(401);
                this.proceed(throwable);
            } else if (throwable instanceof AuthenticationRedirectException) {
                AuthenticationRedirectException redirectEx = (AuthenticationRedirectException)throwable;
                event.response().setStatusCode(redirectEx.getCode());
                event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)redirectEx.getRedirectUri());
                event.response().headers().set(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
                event.response().headers().set("Pragma", "no-cache");
                this.proceed(throwable);
            } else {
                event.fail(throwable);
            }
        }

        protected abstract void proceed(Throwable var1);

        private static HttpAuthenticator getAuthenticator(RoutingContext event) {
            return (HttpAuthenticator)event.get(HttpAuthenticator.class.getName());
        }

        public static Throwable extractRootCause(Throwable throwable) {
            while (throwable instanceof CompletionException && throwable.getCause() != null || throwable instanceof CompositeException) {
                if (throwable instanceof CompositeException) {
                    throwable = (Throwable)((CompositeException)throwable).getCauses().get(0);
                    continue;
                }
                throwable = throwable.getCause();
            }
            return throwable;
        }
    }
}

