/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.crypto.CekManagementProvider;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.models.KeycloakSession;

public class RsaCekManagementProvider
implements CekManagementProvider {
    private final KeycloakSession session;
    private final String jweAlgorithmName;

    public RsaCekManagementProvider(KeycloakSession session, String jweAlgorithmName) {
        this.session = session;
        this.jweAlgorithmName = jweAlgorithmName;
    }

    public JWEAlgorithmProvider jweAlgorithmProvider() {
        if ("RSA1_5".equals(this.jweAlgorithmName) || "RSA-OAEP".equals(this.jweAlgorithmName) || "RSA-OAEP-256".equals(this.jweAlgorithmName)) {
            return (JWEAlgorithmProvider)CryptoIntegration.getProvider().getAlgorithmProvider(JWEAlgorithmProvider.class, this.jweAlgorithmName);
        }
        return null;
    }
}

