/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

public class OpenApiProcessor {
    private OpenApiProcessor() {
    }

    public static OpenAPI bootstrap(IndexView index) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfig openApiConfig = OpenApiConfig.fromConfig(config);
        return OpenApiProcessor.bootstrap(openApiConfig, index);
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index) {
        ClassLoader defaultClassLoader = ClassLoaderUtil.getDefaultClassLoader();
        return OpenApiProcessor.bootstrap(config, index, defaultClassLoader);
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index, OpenApiStaticFile ... staticFiles) {
        ClassLoader defaultClassLoader = ClassLoaderUtil.getDefaultClassLoader();
        return OpenApiProcessor.bootstrap(config, index, defaultClassLoader, staticFiles);
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index, ClassLoader classLoader) {
        List<OpenApiStaticFile> staticfiles = OpenApiProcessor.loadOpenApiStaticFiles(classLoader);
        return OpenApiProcessor.bootstrap(config, index, classLoader, staticfiles.toArray(new OpenApiStaticFile[0]));
    }

    public static OpenAPI bootstrap(OpenApiConfig config, IndexView index, ClassLoader classLoader, OpenApiStaticFile ... staticFiles) {
        OpenApiDocument.INSTANCE.reset();
        if (config != null) {
            OpenApiDocument.INSTANCE.config(config);
        }
        if (staticFiles != null && staticFiles.length > 0) {
            for (OpenApiStaticFile staticFile : staticFiles) {
                OpenApiDocument.INSTANCE.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile(config, staticFile));
            }
        }
        if (config != null && index != null) {
            OpenApiDocument.INSTANCE.modelFromAnnotations(OpenApiProcessor.modelFromAnnotations(config, classLoader, index));
        }
        if (config != null && classLoader != null) {
            OpenApiDocument.INSTANCE.modelFromReader(OpenApiProcessor.modelFromReader(config, classLoader));
            OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter(config, classLoader));
        }
        OpenApiDocument.INSTANCE.initialize();
        OpenAPI openAPI = OpenApiDocument.INSTANCE.get();
        OpenApiDocument.INSTANCE.reset();
        return openAPI;
    }

    public static OpenAPI modelFromStaticFile(OpenApiConfig config, OpenApiStaticFile staticFile) {
        return OpenApiProcessor.modelFromStaticFile(staticFile, config != null ? config.getMaximumStaticFileSize() : null);
    }

    public static OpenAPI modelFromStaticFile(OpenApiStaticFile staticFile) {
        return OpenApiProcessor.modelFromStaticFile(staticFile, null);
    }

    private static OpenAPI modelFromStaticFile(OpenApiStaticFile staticFile, Integer maxStaticFileSize) {
        if (staticFile == null) {
            return null;
        }
        try {
            return OpenApiParser.parse(staticFile.getContent(), staticFile.getFormat(), maxStaticFileSize);
        }
        catch (IOException e) {
            throw new OpenApiRuntimeException(e);
        }
    }

    public static OpenAPI modelFromAnnotations(OpenApiConfig config, IndexView index) {
        return OpenApiProcessor.modelFromAnnotations(config, ClassLoaderUtil.getDefaultClassLoader(), index);
    }

    public static OpenAPI modelFromAnnotations(OpenApiConfig config, ClassLoader loader, IndexView index) {
        if (config.scanDisable()) {
            return null;
        }
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(config, loader, index);
        return scanner.scan(new String[0]);
    }

    public static OpenAPI modelFromReader(OpenApiConfig config, ClassLoader loader) {
        String readerClassName = config.modelReader();
        if (readerClassName == null) {
            return null;
        }
        try {
            Class<?> c = loader.loadClass(readerClassName);
            OASModelReader reader = (OASModelReader)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return reader.buildModel();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new OpenApiRuntimeException(e);
        }
    }

    public static OASFilter getFilter(OpenApiConfig config, ClassLoader loader) {
        String filterClassName = config.filter();
        if (filterClassName == null) {
            return null;
        }
        try {
            Class<?> c = loader.loadClass(filterClassName);
            return (OASFilter)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new OpenApiRuntimeException(e);
        }
    }

    private static List<OpenApiStaticFile> loadOpenApiStaticFiles(ClassLoader classLoader) {
        ArrayList<OpenApiStaticFile> apiStaticFiles = new ArrayList<OpenApiStaticFile>();
        OpenApiProcessor.loadOpenApiStaticFile(apiStaticFiles, classLoader, "/META-INF/openapi.yaml", Format.YAML);
        OpenApiProcessor.loadOpenApiStaticFile(apiStaticFiles, classLoader, "/WEB-INF/classes/META-INF/openapi.yaml", Format.YAML);
        OpenApiProcessor.loadOpenApiStaticFile(apiStaticFiles, classLoader, "/META-INF/openapi.yml", Format.YAML);
        OpenApiProcessor.loadOpenApiStaticFile(apiStaticFiles, classLoader, "/WEB-INF/classes/META-INF/openapi.yml", Format.YAML);
        OpenApiProcessor.loadOpenApiStaticFile(apiStaticFiles, classLoader, "/META-INF/openapi.json", Format.JSON);
        OpenApiProcessor.loadOpenApiStaticFile(apiStaticFiles, classLoader, "/WEB-INF/classes/META-INF/openapi.json", Format.JSON);
        return apiStaticFiles;
    }

    private static List<OpenApiStaticFile> loadOpenApiStaticFile(List<OpenApiStaticFile> apiStaticFiles, ClassLoader classLoader, String path, Format format) {
        InputStream staticStream = classLoader.getResourceAsStream(path);
        if (staticStream != null) {
            apiStaticFiles.add(new OpenApiStaticFile(staticStream, format));
        }
        return apiStaticFiles;
    }
}

