/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import java.sql.SQLException;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.AbstractPrecondition;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtil;
import liquibase.util.StringUtil;

public class ColumnExistsPrecondition
extends AbstractPrecondition {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        if (this.canCheckFast(database)) {
            this.checkFast(database, changeLog);
        } else {
            this.checkUsingSnapshot(database, changeLog, changeSet);
        }
    }

    private void checkUsingSnapshot(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        Column example = new Column();
        if (StringUtil.trimToNull(this.getTableName()) != null) {
            example.setRelation(new Table().setName(database.correctObjectName(this.getTableName(), Table.class)).setSchema(new Schema(this.getCatalogName(), this.getSchemaName())));
        }
        example.setName(database.correctObjectName(this.getColumnName(), Column.class));
        try {
            if (!SnapshotGeneratorFactory.getInstance().has(example, database)) {
                throw new PreconditionFailedException("Column '" + database.escapeColumnName(this.catalogName, this.schemaName, this.getTableName(), this.getColumnName()) + "' does not exist", changeLog, this);
            }
        }
        catch (LiquibaseException e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
    }

    private boolean canCheckFast(Database database) {
        if (this.getCatalogName() != null) {
            return false;
        }
        if (!(database.getConnection() instanceof JdbcConnection)) {
            return false;
        }
        if (this.getColumnName() == null) {
            return false;
        }
        if (!this.getColumnName().matches("(?i)[a-z][a-z_0-9]*")) {
            return false;
        }
        return this.getSchemaName() != null || database.getDefaultSchemaName() != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFast(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        block22: {
            block23: {
                statement = null;
                try {
                    statement = ((JdbcConnection)database.getConnection()).createStatement();
                    schemaName = this.getSchemaName();
                    if (schemaName == null) {
                        schemaName = database.getDefaultSchemaName();
                    }
                    tableName = this.getTableName();
                    columnName = this.getColumnName();
                    if (!(database instanceof PostgresDatabase)) break block22;
                    sql = "SELECT 1 FROM pg_attribute a WHERE EXISTS (SELECT 1 FROM pg_class JOIN pg_catalog.pg_namespace ns ON ns.oid = pg_class.relnamespace WHERE lower(ns.nspname)='" + schemaName.toLowerCase() + "' AND lower(relname) = lower('" + tableName + "') AND pg_class.oid = a.attrelid) AND lower(a.attname) = lower('" + columnName + "');";
                    try {
                        block24: {
                            rs = statement.executeQuery(sql);
                            var9_13 = null;
                            try {
                                if (rs.next()) {
                                    if (rs == null) break block23;
                                    if (var9_13 == null) break block24;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var10_15) {
                                var9_13 = var10_15;
                                throw var10_15;
                            }
                            catch (Throwable var11_16) {
                                if (rs == null) throw var11_16;
                                if (var9_13 == null) {
                                    rs.close();
                                    throw var11_16;
                                }
                                try {
                                    rs.close();
                                    throw var11_16;
                                }
                                catch (Throwable var12_17) {
                                    var9_13.addSuppressed(var12_17);
                                    throw var11_16;
                                }
                            }
                            try {
                                rs.close();
                            }
                            catch (Throwable var10_14) {
                                var9_13.addSuppressed(var10_14);
                            }
                            break block23;
                        }
                        rs.close();
                    }
                    catch (SQLException e) {
                        throw new PreconditionErrorException(e, changeLog, this);
                    }
                }
                catch (DatabaseException e) {
                    try {
                        throw new PreconditionErrorException(e, changeLog, this);
                    }
                    catch (Throwable var13_18) {
                        JdbcUtil.closeStatement(statement);
                        throw var13_18;
                    }
                }
            }
            JdbcUtil.closeStatement(statement);
            return;
lbl-1000:
            // 1 sources

            {
                throw new PreconditionFailedException(String.format("Column %s.%s.%s does not exist", new Object[]{schemaName, tableName, columnName}), changeLog, this);
            }
        }
        sql = database instanceof FirebirdDatabase != false ? String.format("select t.%s from %s t where 0=1", new Object[]{database.escapeColumnNameList(columnName), database.escapeObjectName(tableName, Table.class)}) : String.format("select t.%s from %s.%s t where 0=1", new Object[]{database.escapeColumnNameList(columnName), database.escapeObjectName(schemaName, Schema.class), database.escapeObjectName(tableName, Table.class)});
        try {
            statement.executeQuery(sql).close();
        }
        catch (SQLException e) {
            throw new PreconditionFailedException(String.format("Column %s.%s.%s does not exist", new Object[]{schemaName, tableName, columnName}), changeLog, this);
        }
        JdbcUtil.closeStatement(statement);
    }

    @Override
    public String getName() {
        return "columnExists";
    }
}

