/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.Collections;
import java.util.List;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LockException;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;

public class LockServiceCommandStep
extends AbstractCommandStep
implements CleanUpCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"lockServiceCommandStep"};
    private LockService lockService;

    @Override
    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(Database.class);
    }

    @Override
    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(LockService.class);
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        this.lockService = LockServiceFactory.getInstance().getLockService(database);
        this.lockService.waitForLock();
        commandScope.provideDependency(LockService.class, this.lockService);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (commandDefinition.getPipeline().size() == 1) {
            commandDefinition.setInternal(true);
        }
    }

    @Override
    public void cleanUp(CommandResultsBuilder resultsBuilder) {
        try {
            this.lockService.releaseLock();
        }
        catch (LockException e) {
            Scope.getCurrentScope().getLog(this.getClass()).severe(Liquibase.MSG_COULD_NOT_RELEASE_LOCK, e);
        }
    }
}

