/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;

public class SslConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<SslConfiguration> {
    private boolean enabled = false;
    private String keyStoreFileName;
    private String keyStoreType;
    private char[] keyStorePassword;
    private char[] keyStoreCertificatePassword;
    private String keyAlias;
    private String trustStorePath;
    private String trustStoreFileName;
    private String trustStoreType;
    private char[] trustStorePassword;
    private SSLContext sslContext;
    private String sniHostName;
    private String protocol;
    private Collection<String> ciphers;
    private String provider;

    protected SslConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public SslConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this.enable();
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this.enable();
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this.enable();
    }

    @Deprecated
    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        return this.enable();
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this.enable();
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this.enable();
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this.enable();
    }

    @Deprecated
    public SslConfigurationBuilder trustStorePath(String trustStorePath) {
        Log.HOTROD.deprecatedConfigurationProperty("infinispan.client.hotrod.trust_store_path");
        this.trustStorePath = trustStorePath;
        return this.enable();
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this.enable();
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this.enable();
    }

    public SslConfigurationBuilder sniHostName(String sniHostName) {
        this.sniHostName = sniHostName;
        return this.enable();
    }

    public SslConfigurationBuilder provider(String provider) {
        this.provider = provider;
        return this.enable();
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this.enable();
    }

    public SslConfigurationBuilder ciphers(String ... ciphers) {
        this.ciphers = Arrays.asList(ciphers);
        return this.enable();
    }

    public void validate() {
        if (this.enabled) {
            if (this.sslContext == null) {
                if (this.keyStoreFileName != null && this.keyStorePassword == null) {
                    throw Log.HOTROD.missingKeyStorePassword(this.keyStoreFileName);
                }
                if (this.trustStoreFileName == null && this.trustStorePath == null) {
                    throw Log.HOTROD.noSSLTrustManagerConfiguration();
                }
                if (this.trustStoreFileName != null && this.trustStorePath != null) {
                    throw Log.HOTROD.trustStoreFileAndPathExclusive();
                }
                if (this.trustStoreFileName != null && this.trustStorePassword == null && !"pem".equalsIgnoreCase(this.trustStoreType)) {
                    throw Log.HOTROD.missingTrustStorePassword(this.trustStoreFileName);
                }
            } else if (this.keyStoreFileName != null || this.trustStoreFileName != null) {
                throw Log.HOTROD.xorSSLContext();
            }
        }
    }

    public SslConfiguration create() {
        return new SslConfiguration(this.enabled, this.keyStoreFileName, this.keyStoreType, this.keyStorePassword, this.keyStoreCertificatePassword, this.keyAlias, this.sslContext, this.trustStoreFileName, this.trustStorePath, this.trustStoreType, this.trustStorePassword, this.sniHostName, this.provider, this.protocol, this.ciphers);
    }

    public SslConfigurationBuilder read(SslConfiguration template, Combine combine) {
        this.enabled = template.enabled();
        this.keyStoreFileName = template.keyStoreFileName();
        this.keyStoreType = template.keyStoreType();
        this.keyStorePassword = template.keyStorePassword();
        this.keyStoreCertificatePassword = template.keyStoreCertificatePassword();
        this.keyAlias = template.keyAlias();
        this.sslContext = template.sslContext();
        this.trustStoreFileName = template.trustStoreFileName();
        this.trustStorePath = template.trustStorePath();
        this.trustStoreType = template.trustStoreType();
        this.trustStorePassword = template.trustStorePassword();
        this.sniHostName = template.sniHostName();
        this.provider = template.provider();
        this.protocol = template.protocol();
        this.ciphers = template.ciphers() != null ? new ArrayList<String>(template.ciphers()) : null;
        return this;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties((Map)properties);
        if (typed.containsKey((Object)"infinispan.client.hotrod.key_store_file_name")) {
            this.keyStoreFileName(typed.getProperty("infinispan.client.hotrod.key_store_file_name", this.keyStoreFileName, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.key_store_type")) {
            this.keyStoreType(typed.getProperty("infinispan.client.hotrod.key_store_type", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.key_store_password")) {
            this.keyStorePassword(typed.getProperty("infinispan.client.hotrod.key_store_password", null, true).toCharArray());
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.key_store_certificate_password")) {
            this.keyStoreCertificatePassword(typed.getProperty("infinispan.client.hotrod.key_store_certificate_password", null, true).toCharArray());
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.key_alias")) {
            this.keyAlias(typed.getProperty("infinispan.client.hotrod.key_alias", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.trust_store_file_name")) {
            this.trustStoreFileName(typed.getProperty("infinispan.client.hotrod.trust_store_file_name", this.trustStoreFileName, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.trust_store_path")) {
            this.trustStorePath(typed.getProperty("infinispan.client.hotrod.trust_store_path", this.trustStorePath, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.trust_store_type")) {
            this.trustStoreType(typed.getProperty("infinispan.client.hotrod.trust_store_type", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.trust_store_password")) {
            this.trustStorePassword(typed.getProperty("infinispan.client.hotrod.trust_store_password", null, true).toCharArray());
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.ssl_protocol")) {
            this.protocol(typed.getProperty("infinispan.client.hotrod.ssl_protocol", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.ssl_provider")) {
            this.provider(typed.getProperty("infinispan.client.hotrod.ssl_provider", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.ssl_ciphers")) {
            this.ciphers(typed.getProperty("infinispan.client.hotrod.ssl_ciphers", null, true).split(" "));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.sni_host_name")) {
            this.sniHostName(typed.getProperty("infinispan.client.hotrod.sni_host_name", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.ssl_context")) {
            this.sslContext((SSLContext)typed.get((Object)"infinispan.client.hotrod.ssl_context"));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.use_ssl")) {
            this.enabled(typed.getBooleanProperty("infinispan.client.hotrod.use_ssl", this.enabled, true));
        }
        return this.builder.getBuilder();
    }
}

