/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NIOControlPacket;
import oracle.net.ns.NIODataDescriptorPacket;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetworkCompressionCodec;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SecurityInformationImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpsNTAdapter;

public class SessionAtts
implements SQLnetDef,
Diagnosable {
    private static final String CLASS_NAME = SessionAtts.class.getName();
    private static final Predicate<String> IS_PASSWORD = Pattern.compile(".*password.*", 2).asPredicate().and(string -> !"oracle.jdbc.passwordAuthentication".equalsIgnoreCase((String)string));
    private static final Predicate<String> IS_VALID_CONNECTION_ID_PREFIX = Pattern.compile(String.format("[A-z0-9,_]{%d}", 8)).asPredicate();
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    private int sdu;
    private int tdu;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled = false;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect = false;
    protected String connectData;
    public boolean anoActive;
    protected boolean isLargeSDU = false;
    protected int negotiatedSDU = -1;
    protected boolean redirecting = false;
    protected boolean isJavaNetNIO = false;
    private final Diagnosable diagnosable;
    SocketChannel socketChannel;
    public NIONSDataChannel dataChannel;
    NIOMarkerPacket markerPacket;
    NIODataDescriptorPacket ddPacket;
    NIOControlPacket controlPacket;
    NTAdapter.NetworkAdapterType networkType;
    public ByteBuffer readBuffer = null;
    public ByteBuffer payloadDataBufferForRead = null;
    ByteBuffer payloadBufferForRead = null;
    ByteBuffer headerBufferForRead = null;
    public ByteBuffer writeBuffer = null;
    public ByteBuffer payloadDataBufferForWrite = null;
    ByteBuffer payloadBufferForWrite = null;
    ByteBuffer headerBufferForWrite = null;
    boolean useNativeBuffers = false;
    boolean needToReleaseMSGQBuffer = false;
    private final Properties netProperties = new Properties();
    String networkCompression;
    ArrayList<String> networkCompressionLevelsArray;
    int networkCompressionThreshold;
    String negotiatedNetworkCompression;
    boolean networkCompressionEnabled;
    int negotiatedNetworkCompressionScheme;
    NetworkCompressionCodec compressionCodec;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    boolean needsToBeClosed;
    boolean isPollAndCheckEnabled;
    static int DEFAULT_POLL_AND_CHECK_TIME_MILLIS = 60000;
    final Monitor ntOutputStreamMonitor = Monitor.newInstance();
    private final String uniqueConnectionId;
    private String netConnectionId;
    private String netConnectionIdPrefix;
    private SecurityInformation securityInformation;
    String traceId;

    public SessionAtts(NSProtocol nsp, int sdu, int tdu, boolean useNIO, boolean _useNativeBuffers, Diagnosable diagnosable) {
        this.sdu = sdu;
        this.tdu = tdu;
        this.ns = nsp;
        this.diagnosable = diagnosable;
        this.securityInformation = new SecurityInformationImpl();
        this.anoActive = false;
        this.connected = false;
        this.netConnectionId = this.uniqueConnectionId = this.createUniqueConnectionId();
        if (useNIO) {
            this.dataChannel = new NIONSDataChannel(this);
            this.markerPacket = new NIOMarkerPacket(this);
            this.ddPacket = new NIODataDescriptorPacket(this);
            this.controlPacket = new NIOControlPacket(this);
            this.useNativeBuffers = _useNativeBuffers;
            this.isJavaNetNIO = true;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    void setNetProperty(String propertyKey, String value) {
        this.netProperties.setProperty(propertyKey, value);
    }

    public String getNetProperty(String propertyKey) {
        return this.netProperties.getProperty(propertyKey);
    }

    public String getNetConnectionId() {
        return this.netConnectionId;
    }

    private String createUniqueConnectionId() {
        try {
            UUID uuid = UUID.randomUUID();
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            return Base64.getEncoder().encodeToString(bb.array());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate ConnectionID to establish Connection", e);
        }
    }

    void setNetConnectionIdPrefix(String prefix) {
        if (!this.isValidNetConnectionIdPrefix(prefix)) {
            throw new IllegalArgumentException("Invalid ConnectionId prefix : " + prefix);
        }
        this.netConnectionIdPrefix = prefix;
        this.netConnectionId = prefix == null ? this.uniqueConnectionId : this.netConnectionIdPrefix + this.uniqueConnectionId;
    }

    private boolean isValidNetConnectionIdPrefix(String prefix) {
        return prefix == null || IS_VALID_CONNECTION_ID_PREFIX.test(prefix);
    }

    public boolean isTwoFactorAuthenticationDone() {
        return this.ano != null && this.ano.isTwoFactorAuthenticationDone();
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getNetProperties() {
        return (Properties)this.netProperties.clone();
    }

    public SecurityInformation getSecurityInformation() {
        return this.securityInformation;
    }

    public boolean isNetworkCompressionEnabled() {
        return this.networkCompressionEnabled;
    }

    void initializeNetProperties(@Blind(value=PropertiesBlinder.class) Properties nsProperties) throws NetException, IOException {
        nsProperties.stringPropertyNames().stream().filter(IS_PASSWORD.negate()).forEach(key -> this.netProperties.put(key, nsProperties.get(key)));
        this.setNetProperty("oracle.jdbc.negotiatedCompressionStatus", "" + this.networkCompressionEnabled);
        this.setNetProperty("oracle.jdbc.negotiatedSDU", "" + this.getSDU());
        this.setNetProperty("oracle.jdbc.negotiatedTDU", "" + this.getTDU());
        this.setNetProperty("oracle.jdbc.connectedNetworkAddress", this.cOption.addr);
        this.setNetProperty("oracle.net.CONNECT_TIMEOUT", "" + this.cOption.transportConnectTimeout);
        this.setNetProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", "" + this.cOption.connectTimeout);
        this.setNetProperty("oracle.jdbc.isOOBEnabled", "" + this.isExpediatedAttentionEnabled());
        if (this.nt.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS) {
            this.setNetProperty("oracle.jdbc.negotiatedCipherSuite", (String)this.nt.getOption(105));
        }
        if (this.ano != null) {
            if (this.isChecksumActive) {
                this.setNetProperty("oracle.jdbc.negotiatedChecksumAlgorithm", this.ano.getDataIntegrityName());
            }
            if (this.isEncryptionActive) {
                this.setNetProperty("oracle.jdbc.negotiatedEncryptionAlgorithm", this.ano.getEncryptionName());
            }
            if (!this.ano.getAuthenticationAdaptorName().equals("")) {
                this.setNetProperty("oracle.jdbc.negotiatedAuthenticationAdaptor", this.ano.getAuthenticationAdaptorName());
            }
        }
        SecurityInformationImpl securityInfoImpl = (SecurityInformationImpl)this.securityInformation;
        if (this.getNTAdapter().getNetworkAdapterType().equals((Object)NTAdapter.NetworkAdapterType.TCPS)) {
            TcpsNTAdapter tcpsNTAdapter = (TcpsNTAdapter)this.getNTAdapter();
            securityInfoImpl.setDNMatchStatus(tcpsNTAdapter.getDNMatchStatus());
            securityInfoImpl.setServerDN(tcpsNTAdapter.getOption(103).toString());
            securityInfoImpl.setTLSCipherSuite((String)tcpsNTAdapter.getOption(105));
            securityInfoImpl.setTLSVersion(tcpsNTAdapter.getNegotiatedTLSVersion());
        }
        if (this.isChecksumActive || this.isEncryptionActive) {
            securityInfoImpl.setEncryptionLevel(this.profile.getEncryptionLevel());
            securityInfoImpl.setChecksumLevel(this.profile.getDataIntegrityLevel());
            securityInfoImpl.setEncryptionAlgorithm(this.ano.getEncryptionName());
            securityInfoImpl.setChecksummingAlgorithm(this.ano.getDataIntegrityName());
            securityInfoImpl.setNativeEncryptionEnabled(true);
            securityInfoImpl.setStrongCryptoUsed(!this.profile.useWeakCrypto());
        }
        if (this.ano.getAuthenticationAdaptorName() != null) {
            switch (this.ano.getAuthenticationAdaptorName()) {
                case "KERBEROS5": {
                    securityInfoImpl.setAuthenticationAdaptor(SecurityInformation.AuthenticationAdaptorType.KERBEROS);
                    break;
                }
                case "RADIUS": {
                    securityInfoImpl.setAuthenticationAdaptor(SecurityInformation.AuthenticationAdaptorType.RADIUS);
                    break;
                }
                case "TCPS": {
                    securityInfoImpl.setAuthenticationAdaptor(SecurityInformation.AuthenticationAdaptorType.TCPS);
                }
            }
        }
        if (this.netProperties.containsKey("oracle.jdbc.tokenAuthentication") || "OCI_TOKEN".equalsIgnoreCase(this.netProperties.getProperty("oracle.jdbc.passwordAuthentication")) || "AZURE_TOKEN".equalsIgnoreCase(this.netProperties.getProperty("oracle.jdbc.passwordAuthentication"))) {
            securityInfoImpl.setAuthenticationAdaptor(SecurityInformation.AuthenticationAdaptorType.OAUTH);
        }
    }

    protected void initializeBuffer() throws IOException {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            this.initializeBufferForMSGQ();
        } else {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).setBufferSize(this.getSDU());
            }
            if (this.useNativeBuffers) {
                this.setWriteBuffer(ByteBuffer.allocateDirect(this.sdu));
                this.setReadBuffer(ByteBuffer.allocateDirect(this.sdu));
            } else {
                this.setWriteBuffer(ByteBuffer.allocate(this.sdu));
                this.setReadBuffer(ByteBuffer.allocate(this.sdu));
            }
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeBuffer", "Buffers are initialized. WriteBuffer={0}, ReadBuffer={1}, NetworkType={2}. ", (String)null, null, (Object)this.readBuffer, (Object)this.writeBuffer, (Object)this.networkType);
    }

    private void initializeBufferForMSGQ() {
        if (this.writeBuffer != null) {
            MQLNTAdapter.getBufferManager().release(this.writeBuffer);
        }
        this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
        ((MQLNTAdapter)this.nt).setNegotiatedSDUAndTDU(this.sdu, this.tdu);
    }

    void resetWriteBuffersForMSGQ() {
        this.writeBuffer = null;
    }

    void setWriteBuffer(ByteBuffer buffer) {
        this.writeBuffer = buffer;
        this.sliceWriteBuffers();
    }

    void setReadBuffer(ByteBuffer buffer) {
        this.readBuffer = buffer;
        this.sliceReadBuffers();
    }

    void releaseWriteBuffer() {
        if (this.writeBuffer == null) {
            return;
        }
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            MQLNTAdapter.getBufferManager().release(this.writeBuffer);
        }
        this.writeBuffer = null;
    }

    void sliceWriteBuffers() {
        this.writeBuffer.clear();
        this.writeBuffer.limit(8);
        this.headerBufferForWrite = this.writeBuffer.slice();
        this.writeBuffer.position(8);
        this.writeBuffer.limit(this.sdu);
        this.payloadBufferForWrite = this.writeBuffer.slice();
        this.writeBuffer.position(10);
        this.payloadDataBufferForWrite = this.writeBuffer.slice();
        this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
        this.payloadDataBufferForWrite.order(this.byteOrder);
        this.writeBuffer.rewind();
    }

    void sliceReadBuffers() {
        this.readBuffer.position(0);
        this.headerBufferForRead = this.readBuffer.slice();
        if (this.readBuffer.limit() >= 8) {
            this.readBuffer.position(8);
            this.payloadBufferForRead = this.readBuffer.slice();
        }
        if (this.readBuffer.limit() >= 10) {
            this.readBuffer.position(10);
            this.payloadDataBufferForRead = this.readBuffer.slice();
            this.payloadDataBufferForRead.order(this.byteOrder);
            this.payloadBufferForRead.rewind();
        }
        this.readBuffer.rewind();
    }

    public void prepareWriteBuffer() {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            if (this.writeBuffer != null) {
                this.sliceWriteBuffers();
            } else {
                this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
            }
        } else {
            this.payloadDataBufferForWrite.clear();
            this.payloadBufferForWrite.clear();
            this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
            this.payloadBufferForWrite.limit(this.payloadBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder newByteOrder) {
        this.byteOrder = newByteOrder;
    }

    public void setSDU(int sdu) {
        this.sdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (sdu <= 0 ? 65518 : (sdu > 65518 ? 65518 : (sdu < 512 ? 512 : sdu))) : (sdu <= 0 ? 8192 : (sdu > 0x200000 ? 0x200000 : (sdu < 512 ? 512 : sdu)));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int tdu) {
        this.tdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (tdu <= 0 ? 65518 : (tdu > 65518 ? 65518 : (tdu < 255 ? 255 : tdu))) : (tdu <= 0 ? 0x200000 : (tdu > 0x200000 ? 0x200000 : (tdu < 255 ? 255 : tdu)));
    }

    public int getTDU() {
        return this.tdu;
    }

    void setNegotiatedSDUAndTDU(int sdu, int tdu) throws IOException {
        this.setTDU(tdu);
        this.setSDU(sdu);
        this.negotiatedSDU = this.sdu;
        this.initializeBuffer();
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    void renegotiateSSLSession() throws IOException {
        ((TcpsNTAdapter)this.nt).renegotiateSession();
        if (this.isJavaNetNIO) {
            this.socketChannel = this.nt.getSocketChannel();
        } else {
            this.ntInputStream = this.nt.getInputStream();
            this.ntOutputStream = this.nt.getOutputStream();
        }
    }

    public String toString() {
        String ls = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Session Attributes: ").append(ls);
        stringBuilder.append("sdu=").append(this.sdu).append(", tdu=").append(this.tdu).append(ls);
        if (this.nt != null) {
            stringBuilder.append("nt: ").append(this.nt).append(ls);
        }
        if (this.ntInputStream != null) {
            stringBuilder.append("ntInputStream=").append(this.ntInputStream).append(ls);
        }
        if (this.ntOutputStream != null) {
            stringBuilder.append("ntOutputStream=").append(this.ntOutputStream).append(ls);
        }
        if (this.profile != null) {
            stringBuilder.append("client profile=").append(this.profile).append(ls);
        }
        if (this.cOption != null) {
            stringBuilder.append("connection options=").append(this.cOption).append(ls);
        }
        stringBuilder.append("onBreakReset=").append(this.onBreakReset);
        stringBuilder.append(", dataEOF=").append(this.dataEOF);
        stringBuilder.append(", negotiatedOptions=0x").append(Integer.toHexString(this.negotiatedOptions));
        stringBuilder.append(", connected=").append(this.connected);
        return stringBuilder.toString();
    }

    public void turnEncryptionOn(NIONSDataChannel dataChannel) throws NetException {
        if (dataChannel == null) {
            throw new NetException(18900);
        }
        this.dataChannel = dataChannel;
        this.anoActive = true;
    }

    public int getANOFlags() {
        int flags = 1;
        if (this.ano != null) {
            flags = this.ano.getNAFlags();
        }
        return flags;
    }

    public void setNegotiatedOptions(int value) {
        this.negotiatedOptions = value;
    }

    public int getNegotiatedOptions() {
        return this.negotiatedOptions;
    }

    public ConnOption getcOption() {
        return this.cOption;
    }

    void setConnectData(String value) {
        this.connectData = value;
    }

    String getConnectData() {
        return this.connectData;
    }

    final boolean isExpediatedAttentionEnabled() {
        return (this.negotiatedOptions & 0x400) == 1024;
    }

    final boolean isAttentionProcessingEnabled() {
        return (this.negotiatedOptions & 0x800) != 2048;
    }
}

