/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.OracleStatement;

class T2CLongRawAccessor
extends LongRawAccessor {
    T2CLongRawAccessor(OracleStatement stmt, int column_pos, int max_len, short form, int external_type, boolean isOutBind) throws SQLException {
        super(stmt, column_pos, max_len, form, external_type, isOutBind, false);
    }

    T2CLongRawAccessor(OracleStatement stmt, int column_pos, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, column_pos, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
    }

    @Override
    byte[] getBytesInternal(int currentRow) throws SQLException {
        if (this.statement.isFetchStreams) {
            assert (!this.isNull(currentRow));
            int len = this.getLength(currentRow);
            long off = this.getOffset(currentRow);
            return this.rowData.get(off, len);
        }
        return super.getBytesInternal(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        if (this.statement.isFetchStreams) {
            if (this.isNull(currentRow)) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset(currentRow), this.getLength(currentRow)));
            try {
                InputStream inputStream = this.statement.connection.conversion.ConvertStream(is, 2);
                return inputStream;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return super.getAsciiStream(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        if (this.statement.isFetchStreams) {
            if (this.isNull(currentRow)) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset(currentRow), this.getLength(currentRow)));
            try {
                InputStream inputStream = this.statement.connection.conversion.ConvertStream(is, 3);
                return inputStream;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return super.getUnicodeStream(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        if (this.statement.isFetchStreams) {
            if (this.isNull(currentRow)) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset(currentRow), this.getLength(currentRow)));
            try {
                Reader reader = this.statement.connection.conversion.ConvertCharacterStream(is, 8, this.formOfUse);
                return reader;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return super.getCharacterStream(currentRow);
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        if (this.statement.isFetchStreams) {
            if (this.isNull(currentRow)) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.rowData.get(this.getOffset(currentRow), this.getLength(currentRow)));
            return is;
        }
        return super.getBinaryStream(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyStreamDataIntoDBA(int currentRow) throws SQLException {
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        ByteArrayOutputStream outs = null;
        byte[] b = null;
        try {
            outs = new ByteArrayOutputStream(1024);
            byte[] buffer = this.statement.connection.getByteBuffer(32768);
            try {
                int length;
                while ((length = this.stream.read(buffer, 0, 32768)) != -1) {
                    outs.write(buffer, 0, length);
                }
                this.statement.connection.cacheBuffer(buffer);
            }
            catch (IOException e) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
            }
            b = outs.toByteArray();
        }
        finally {
            try {
                if (outs != null) {
                    outs.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (b == null || b.length == 0) {
            this.setLengthAndNull(currentRow, 0);
        } else {
            this.setOffset(currentRow);
            this.setLengthAndNull(currentRow, b.length);
            this.rowData.put(b);
        }
    }

    @Override
    Accessor copyForDefine(OracleStatement dest) {
        LongRawAccessor a = (LongRawAccessor)super.copyForDefine(dest);
        try {
            a.stream = dest.connection.driverExtension.createInputStream(dest, this.columnPosition, a);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return a;
    }
}

