/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.ROWID;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    private static final String CLASS_NAME = OracleResultSetMetaData.class.getName();
    PhysicalConnection connection;
    OracleStatement statement;
    int offsetOfFirstUserColumn;
    Object acProxy;

    public OracleResultSetMetaData() {
    }

    OracleResultSetMetaData(PhysicalConnection conn, OracleStatement stmt, int offset) throws SQLException {
        this.connection = conn;
        this.statement = stmt;
        stmt.describe();
        stmt.computeOffsetOfFirstUserColumn();
        stmt.computeNumberOfUserColumns();
        this.offsetOfFirstUserColumn = offset;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.statement.getNumberOfUserColumns();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    int getValidColumnIndex(int column) throws SQLException {
        if (column <= 0 || column > this.statement.getNumberOfUserColumns()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex").fillInStackTrace();
        }
        int index = column + this.offsetOfFirstUserColumn;
        return index;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type == 1 || type == 12 || type == -1 || type == -15 || type == -9 || type == 2005 || type == 2011 || type == 2009;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type != -4 && type != -1 && type != 2004 && type != 2005 && type != -13 && type != 2011 && type != 2016 && type != 2002 && type != 2008 && type != 2007 && type != 2003 && type != 2006 && type != -10 && type != 2012;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        int l_type = this.getColumnType(column);
        return l_type == 2 || l_type == 6;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].nullable ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        switch (type) {
            case 2: {
                int _precision = this.getPrecision(column);
                int _scale = this.getDescription()[index].scale;
                if (_precision != 0 && _scale == -127) {
                    _precision = (int)((double)_precision / 3.32193);
                    _scale = 1;
                } else {
                    if (_precision == 0) {
                        _precision = 38;
                    }
                    if (_scale == -127) {
                        _scale = 0;
                    }
                }
                int width = _precision + (_scale != 0 ? 1 : 0) + 1;
                return width;
            }
            case 1: 
            case 96: {
                Accessor desc = this.getDescription()[index];
                if (this.statement.connection.protocolId == 3) {
                    return desc.describeMaxLengthChars;
                }
                if (desc.describeMaxLengthChars <= 0) break;
                if (desc.definedColumnSize > 0) {
                    return Math.min(desc.describeMaxLengthChars, desc.definedColumnSize);
                }
                return desc.describeMaxLengthChars;
            }
        }
        return this.getDescription()[index].describeMaxLength;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.statement.getDescriptionWithNames()[index].columnName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        switch (type) {
            case 112: 
            case 113: 
            case 119: {
                return -1;
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                Accessor desc = this.getDescription()[index];
                if (this.statement.connection.protocolId == 3) {
                    return desc.describeMaxLengthChars;
                }
                if (desc.describeMaxLengthChars > 0) {
                    if (desc.definedColumnSize > 0) {
                        return Math.min(desc.describeMaxLengthChars, desc.definedColumnSize);
                    }
                    return desc.describeMaxLengthChars;
                }
                return desc.describeMaxLength;
            }
        }
        return this.getDescription()[index].precision;
    }

    @Override
    public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].securityAttribute;
    }

    @Override
    public int getScale(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int _scale = this.getDescription()[index].scale;
        return _scale == -127 && this.statement.connection.j2ee13Compliant ? 0 : _scale;
    }

    @Override
    public boolean isVariableScale(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int _scale = this.getDescription()[index].scale;
        return _scale == -127;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getColumnType", "Rset Column Type={0}. ", (String)null, (Throwable)null, (Object)type);
        switch (type) {
            case 96: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return -15;
                }
                return 1;
            }
            case 1: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return -9;
                }
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[index].precision != 0 && this.getDescription()[index].scale == -127) {
                    return 6;
                }
                return 2;
            }
            case 100: {
                return 100;
            }
            case 101: {
                return 101;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: 
            case 208: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return this.connection.mapDateToTimestamp ? 93 : 91;
            }
            case 180: {
                return 93;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 119: {
                return 2016;
            }
            case 112: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return 2011;
                }
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                TypeDescriptor descriptor = TypeDescriptor.getTypeDescriptor(this.getDescription()[index].describeTypeName, this.connection);
                if (descriptor != null) {
                    return descriptor.getTypeCode();
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60).fillInStackTrace();
            }
            case 111: {
                return 2006;
            }
            case 182: {
                return -103;
            }
            case 183: {
                return -104;
            }
            case 252: {
                return 16;
            }
        }
        return 1111;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getColumnTypeName", "Rset Column Type={0}. ", (String)null, (Throwable)null, (Object)type);
        switch (type) {
            case 96: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return "NCHAR";
                }
                return "CHAR";
            }
            case 1: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return "NVARCHAR2";
                }
                return "VARCHAR2";
            }
            case 8: {
                return "LONG";
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[index].precision != 0 && this.getDescription()[index].scale == -127) {
                    return "FLOAT";
                }
                return "NUMBER";
            }
            case 100: {
                return "BINARY_FLOAT";
            }
            case 101: {
                return "BINARY_DOUBLE";
            }
            case 23: {
                return "RAW";
            }
            case 24: {
                return "LONG RAW";
            }
            case 104: 
            case 208: {
                return "ROWID";
            }
            case 102: {
                return "REFCURSOR";
            }
            case 12: {
                return "DATE";
            }
            case 180: {
                return "TIMESTAMP";
            }
            case 181: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 231: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case 113: {
                return "BLOB";
            }
            case 119: {
                return "JSON";
            }
            case 112: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return "NCLOB";
                }
                return "CLOB";
            }
            case 114: {
                return "BFILE";
            }
            case 109: {
                OracleTypeADT otype = (OracleTypeADT)this.getDescription()[index].describeOtype;
                return otype.getFullName();
            }
            case 111: {
                OracleTypeADT otype = (OracleTypeADT)this.getDescription()[index].describeOtype;
                return otype.getFullName();
            }
            case 182: {
                return "INTERVALYM";
            }
            case 183: {
                return "INTERVALDS";
            }
            case 252: {
                return "BOOLEAN";
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.getDescription()[index].describeType;
        switch (type) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return String.class.getName();
            }
            case 2: 
            case 6: {
                if (this.getDescription()[index].precision != 0 && this.getDescription()[index].scale == -127) {
                    return Double.class.getName();
                }
                return BigDecimal.class.getName();
            }
            case 23: 
            case 24: {
                return byte[].class.getName();
            }
            case 12: {
                return Timestamp.class.getName();
            }
            case 180: {
                if (this.statement.connection.j2ee13Compliant) {
                    return Timestamp.class.getName();
                }
                return TIMESTAMP.class.getName();
            }
            case 181: {
                return TIMESTAMPTZ.class.getName();
            }
            case 231: {
                return TIMESTAMPLTZ.class.getName();
            }
            case 182: {
                return INTERVALYM.class.getName();
            }
            case 183: {
                return INTERVALDS.class.getName();
            }
            case 104: 
            case 208: {
                return ROWID.class.getName();
            }
            case 113: {
                return OracleBlob.class.getName();
            }
            case 112: {
                if (this.getDescription()[index].formOfUse == 2) {
                    return OracleNClob.class.getName();
                }
                return OracleClob.class.getName();
            }
            case 114: {
                return OracleBfile.class.getName();
            }
            case 102: {
                return OracleResultSet.class.getName();
            }
            case 109: {
                switch (this.getColumnType(column)) {
                    case 2003: {
                        return OracleArray.class.getName();
                    }
                    case 2007: {
                        return OracleOpaque.class.getName();
                    }
                    case 2008: {
                        Class<?> c;
                        OracleNamedType ntype = (OracleNamedType)this.getDescription()[index].describeOtype;
                        Map<String, Class<?>> map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (c = map.get(ntype.getFullName())) != null) {
                            return c.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, ntype.getSchemaName(), ntype.getSimpleName());
                    }
                    case 2002: {
                        Class<?> c;
                        Map<String, Class<?>> map = this.connection.getTypeMap();
                        if (map != null && (c = map.get(((OracleNamedType)this.getDescription()[index].describeOtype).getFullName())) != null) {
                            return c.getName();
                        }
                        return OracleStruct.class.getName();
                    }
                    case 2009: {
                        return SQLXML.class.getName();
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
            case 111: {
                return OracleRef.class.getName();
            }
            case 101: {
                return Double.class.getName();
            }
            case 100: {
                return Float.class.getName();
            }
            case 252: {
                return Boolean.class.getName();
            }
        }
        return Object.class.getName();
    }

    @Override
    public boolean isNCHAR(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].formOfUse == 2;
    }

    @Override
    public boolean isColumnInvisible(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].isColumnInvisible();
    }

    @Override
    public boolean isColumnJSON(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].isColumnJSON();
    }

    @Override
    public String getDomainName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].domainName;
    }

    @Override
    public String getDomainSchema(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.getDescription()[index].domainSchema;
    }

    Accessor[] getDescription() throws SQLException {
        return this.statement.getDescription();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }
}

