/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobSegmentSubscriber;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

@Deprecated
public class OracleClob
extends DatumWithConnection
implements oracle.jdbc.internal.OracleClob {
    private static final String CLASS_NAME = OracleClob.class.getName();
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    public static final int OLD_WRONG_DURATION_SESSION = 1;
    public static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize = -1;
    private short csform;
    boolean isFree = false;
    boolean fromObject = false;
    long cachedLengthOfClobInChars = -1L;
    private OracleLargeObject.PrefetchData<char[]> prefetchData;
    boolean activePrefetch = false;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    transient CharacterSet dilCharacterSet = null;
    protected Object acProxy;
    private volatile boolean isPublishing = false;
    private final ReentrantLock publishingLock = new ReentrantLock();
    private final Condition publishingCondition = this.publishingLock.newCondition();

    public OracleClob() {
    }

    public OracleClob(OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public OracleClob(OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        this.fromObject = fromObject;
    }

    public void setCsform(short csform) {
        this.csform = csform;
    }

    public short getCsform() {
        return this.csform;
    }

    public void setFromobject(boolean fromObject) {
        this.fromObject = fromObject;
    }

    public OracleClob(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        if (lob_descriptor != null) {
            this.csform = CLOB.getFormOfUseFromLocator(lob_descriptor);
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "OracleClob", "csform={0}. ", (String)null, (Throwable)null, (Object)this.csform);
        OracleClob.assertNotNull(conn);
        this.setPhysicalConnectionOf(conn);
        this.dbaccess = ((oracle.jdbc.internal.OracleConnection)conn).createClobDBAccess();
        this.dbaccess.incrementTempLobReferenceCount(lob_descriptor);
        if (lob_descriptor != null && !this.isTemporaryInternal(this.dbaccess)) {
            ((oracle.jdbc.internal.OracleConnection)conn).addLargeObject(this);
        }
    }

    public OracleClob(OracleConnection conn, byte[] lob_descriptor, short csform) throws SQLException {
        this(conn, lob_descriptor);
        short tmp_csform = CLOB.getFormOfUseFromLocator(lob_descriptor);
        if (tmp_csform != -1) {
            if (csform != tmp_csform) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184).fillInStackTrace();
            }
            this.csform = tmp_csform;
        } else {
            this.csform = csform;
        }
    }

    @Override
    public boolean isNCLOB() {
        return this.csform == 2;
    }

    @Override
    public long length() throws SQLException {
        this.awaitPublishing();
        return this.lengthInternal();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        long ret = this.activePrefetch && this.cachedLengthOfClobInChars != -1L ? this.cachedLengthOfClobInChars : (this.canReadBasicLobDataInLocator() ? (long)this.dilGetChars().length : this.getDBAccess().length(this));
        return ret;
    }

    @Override
    public final CompletionStage<Long> lengthInternalAsync() {
        if (this.isFree) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        try {
            if (this.activePrefetch && this.cachedLengthOfClobInChars != -1L) {
                return CompletableFuture.completedFuture(this.cachedLengthOfClobInChars);
            }
            if (this.canReadBasicLobDataInLocator()) {
                return CompletableFuture.completedFuture(Long.valueOf(this.dilGetChars().length));
            }
            return this.getDBAccess().lengthAsync(this);
        }
        catch (SQLException sqlException) {
            return CompletableFuture.failedStage(sqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (length < 0 || pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String ret = this.getSubStringLocal(pos, length);
        if (ret == null) {
            char[] charBuffer = this.getDBAccess().getCharBufferSync(length);
            try {
                int readLength = this.getChars(pos, length, charBuffer);
                ret = readLength > 0 ? new String(charBuffer, 0, readLength) : new String();
            }
            finally {
                this.getDBAccess().cacheBufferSync(charBuffer);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubStringLocal(long pos, int length) throws SQLException {
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetSubString(pos, length);
        }
        if (length == 0 || this.activePrefetch && (this.cachedLengthOfClobInChars == 0L || this.cachedLengthOfClobInChars > 0L && pos - 1L >= this.cachedLengthOfClobInChars)) {
            return new String();
        }
        if (this.prefetchData != null && this.prefetchData.length() > 0 && this.cachedLengthOfClobInChars == (long)this.prefetchData.length() && pos + (long)length - 1L <= this.cachedLengthOfClobInChars) {
            char[] charBuffer = this.getDBAccess().getCharBufferSync(length);
            try {
                this.prefetchData.copy((int)(pos - 1L), charBuffer, 0, length);
                String string = new String(charBuffer, 0, length);
                return string;
            }
            finally {
                this.getDBAccess().cacheBufferSync(charBuffer);
            }
        }
        return null;
    }

    @Override
    public final Flow.Publisher<String> publisherOracle(final long startPosition, final ErrorSet continueOnErrorSet) throws SQLException {
        if (!this.getDBAccess().isAsyncClobGetSupported()) {
            throw new SQLFeatureNotSupportedException("Asynchronous publishing is not supported by " + this.getInternalConnection().getProtocolType() + " connections.");
        }
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (startPosition < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
        }
        Pipeline.requireSupportedErrorSet(continueOnErrorSet);
        this.lockBeforePublishing();
        Executor executor = this.getInternalConnection().getAsyncExecutor();
        Phaser joinPhaser = this.getInternalConnection().getJoinPhaser();
        return new PhasedPublisher<String>(executor, joinPhaser, this::unlockAfterPublishing){
            volatile long position;
            {
                super(executor, joinPhaser, terminalAction);
                this.position = startPosition;
            }

            @Override
            protected void requestNext(BiConsumer<String, Throwable> callback) {
                CompletionStageUtil.callOnComplete(OracleClob.this.getBufferSizeAsync(), (bufferSize, error) -> CompletionStageUtil.callOnComplete(error == null ? OracleClob.this.getSubStringAsync(this.position, (int)bufferSize, continueOnErrorSet).thenApply(nextString -> {
                    this.position += (long)nextString.length();
                    return nextString.isEmpty() ? null : nextString;
                }) : CompletableFuture.failedFuture(error), callback));
            }
        };
    }

    private final CompletionStage<String> getSubStringAsync(long pos, int length, ErrorSet continueOnErrorSet) {
        ClobDBAccess dbAccess;
        if (this.isFree) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        if (length < 0 || pos < 1L) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace());
        }
        try {
            String subString = this.getSubStringLocal(pos, length);
            if (subString != null) {
                return CompletableFuture.completedStage(subString);
            }
            dbAccess = this.getDBAccess();
        }
        catch (SQLException localFailure) {
            return CompletableFuture.failedStage(localFailure);
        }
        char[] charBuffer = dbAccess.getCharBufferSync(length);
        return this.getCharsAsync(pos, length, charBuffer, continueOnErrorSet).handle((readLength, error) -> {
            try {
                if (error == null) {
                    String string = readLength > 0 ? new String(charBuffer, 0, (int)readLength) : new String();
                    return string;
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new CompletionException((Throwable)error);
            }
            finally {
                dbAccess.cacheBufferSync(charBuffer);
            }
        });
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(1L);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.awaitPublishing();
        return this.getAsciiStream(false);
    }

    public InputStream getAsciiStream(boolean isInternal) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetAsciiStream(1L);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L, isInternal);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleClob)this, searchstr, start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleClob)this, (oracle.jdbc.internal.OracleClob)searchstr, start);
    }

    @Override
    public int getChars(long pos, int length, char[] buffer) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().getChars(this, pos, length, buffer);
    }

    private final CompletionStage<Integer> getCharsAsync(long pos, int length, char[] buffer, ErrorSet continueOnErrorSet) {
        ClobDBAccess dbAccess;
        if (this.isFree) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        try {
            dbAccess = this.getDBAccess();
        }
        catch (SQLException getAccessFailure) {
            return CompletableFuture.failedStage(getAccessFailure);
        }
        return dbAccess.getCharsAsync(this, pos, length, buffer, continueOnErrorSet);
    }

    @Override
    @Deprecated
    public Writer getCharacterOutputStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setCharacterStream(1L);
    }

    @Override
    @Deprecated
    public OutputStream getAsciiOutputStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setAsciiStream(1L);
    }

    @Override
    public byte[] getLocator() {
        return this.getBytes();
    }

    @Override
    public void setLocator(byte[] locator) {
        super.setBytes(locator);
    }

    @Override
    public int putChars(long pos, char[] chars) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putChars(this, pos, chars, 0, chars != null ? chars.length : 0);
    }

    public int putChars(long pos, char[] chars, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putChars(this, pos, chars, 0, length);
    }

    @Override
    public int putChars(long pos, char[] chars, int offset, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putChars(this, pos, chars, offset, length);
    }

    @Override
    public final Flow.Subscriber<String> subscriberOracle(long startPosition, ErrorSet continueOnErrorSet) throws SQLException {
        return this.subscriberOracle(startPosition, LobSegmentSubscriber.NO_OUTCOME_SUBSCRIBER, continueOnErrorSet);
    }

    @Override
    public final Flow.Subscriber<String> subscriberOracle(final long startPosition, Flow.Subscriber<Long> outcomeSubscriber, final ErrorSet continueOnErrorSet) throws SQLException {
        if (!this.getDBAccess().isAsyncClobPutSupported()) {
            throw new SQLFeatureNotSupportedException("Asynchronous subscriber is not supported by " + this.getInternalConnection().getProtocolType() + " connections.");
        }
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (startPosition < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
        }
        Objects.requireNonNull(outcomeSubscriber);
        Pipeline.requireSupportedErrorSet(continueOnErrorSet);
        this.lockBeforePublishing();
        Executor executor = this.getInternalConnection().getAsyncExecutor();
        Phaser joinPhaser = this.getInternalConnection().getJoinPhaser();
        joinPhaser.register();
        return CompletionStageUtil.newFutureSubscriber(this.getBufferSizeAsync().thenApply(bufferSize -> {
            final char[] buffer = new char[bufferSize.intValue()];
            return new LobSegmentSubscriber<String>(LobSegmentSubscriber.LobSegmentBuffer.newCharacterBuffer(buffer), outcomeSubscriber, () -> {
                try {
                    this.unlockAfterPublishing();
                }
                finally {
                    joinPhaser.arriveAndDeregister();
                }
            }, executor, joinPhaser){
                volatile long clobPosition;
                {
                    super(buffer2, outcomeSubscriber, terminalAction, userCodeExecutor, joinPhaser);
                    this.clobPosition = startPosition;
                }

                @Override
                CompletionStage<Void> flushBufferAsync(int length) {
                    return OracleClob.this.putAllCharsAsync(this.clobPosition, buffer, 0, length, continueOnErrorSet).whenComplete((nil, err) -> {
                        if (err == null) {
                            this.clobPosition += (long)length;
                        } else {
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "flushBufferAsync", "OracleClob subscriber write failed at position={0}. ", (String)null, err, (Object)this.clobPosition);
                        }
                    });
                }
            };
        }));
    }

    private final CompletionStage<Void> putAllCharsAsync(long pos, char[] chars, int offset, int length, ErrorSet continueOnErrorSet) {
        return this.putCharsAsync(pos, chars, offset, length, continueOnErrorSet).thenCompose(writtenCharCount -> {
            if (writtenCharCount == length) {
                return CompletableFuture.completedStage(null);
            }
            long nextPos = pos + (long)writtenCharCount.intValue();
            int nextOffset = offset + writtenCharCount;
            int nextLength = length - writtenCharCount;
            return this.putAllCharsAsync(nextPos, chars, nextOffset, nextLength, continueOnErrorSet);
        });
    }

    private final CompletionStage<Integer> putCharsAsync(long pos, char[] chars, int offset, int length, ErrorSet continueOnErrorSet) {
        ClobDBAccess dbAccess;
        if (this.isFree) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        try {
            dbAccess = this.getDBAccess();
        }
        catch (SQLException getAccessFailure) {
            return CompletableFuture.failedStage(getAccessFailure);
        }
        return dbAccess.putCharsAsync(this, pos, chars, offset, length, continueOnErrorSet);
    }

    @Override
    @Deprecated
    public int putString(long pos, String str) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setString(pos, str);
    }

    @Override
    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    @Override
    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return OracleClob.computeBufferSize(this.getChunkSize());
    }

    private CompletionStage<Integer> getBufferSizeAsync() {
        if (this.isFree) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        if (this.dbChunkSize > 0) {
            return CompletableFuture.completedStage(OracleClob.computeBufferSize(this.dbChunkSize));
        }
        try {
            CompletableFuture<Integer> bufferSizeFuture = new CompletableFuture<Integer>();
            this.getDBAccess().getChunkSizeAsync(this, (size, error) -> {
                if (error == null) {
                    this.dbChunkSize = size;
                    bufferSizeFuture.complete(OracleClob.computeBufferSize(this.dbChunkSize));
                } else {
                    bufferSizeFuture.completeExceptionally((Throwable)error);
                }
            });
            return bufferSizeFuture;
        }
        catch (Exception exception) {
            return CompletableFuture.failedStage(exception);
        }
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        boolean ret = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return ret;
    }

    @Override
    @Deprecated
    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, false);
    }

    @Override
    @Deprecated
    public Writer getCharacterOutputStream(long pos) throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), pos, false);
    }

    @Override
    public InputStream getAsciiStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                pos = 1L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetAsciiStream(pos);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), pos);
    }

    @Override
    public Reader getCharacterStream(long pos) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                pos = 1L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(pos);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), pos);
    }

    @Override
    @Deprecated
    public void trim(long newlen) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.truncate(newlen);
    }

    @Override
    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.freeTemporaryInternal(this.getDBAccess());
    }

    private void freeTemporaryInternal(ClobDBAccess myDBAccess) throws SQLException {
        int refCnt = myDBAccess.decrementTempLobReferenceCount(this.shareBytes());
        if (refCnt == 0) {
            myDBAccess.freeTemporary(this, this, this.fromObject);
        }
    }

    @Override
    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isTemporaryInternal(this.getDBAccess());
    }

    private boolean isTemporaryInternal(ClobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isTemporary(this);
    }

    @Override
    public short getDuration() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().getDuration(this);
    }

    @Override
    public void open(LargeObjectAccessMode mode) throws SQLException {
        this.awaitPublishing();
        this.open(mode.getCode());
    }

    public void open(int mode) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.getDBAccess().open(this, mode);
    }

    @Override
    public void close() throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.closeInternal(this.getDBAccess());
    }

    private void closeInternal(ClobDBAccess myDBAccess) throws SQLException {
        myDBAccess.close(this);
    }

    @Override
    public boolean isOpen() throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isOpenInternal(this.getDBAccess());
    }

    private boolean isOpenInternal(ClobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isOpen(this);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1").fillInStackTrace();
        }
        int ret = 0;
        if (str != null && str.length() != 0) {
            ret = this.putChars(pos, str.toCharArray());
        }
        return ret;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1").fillInStackTrace();
        }
        if (offset < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0").fillInStackTrace();
        }
        if (offset + len > str.length()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ").fillInStackTrace();
        }
        int ret = 0;
        if (str != null && str.length() != 0) {
            ret = this.putChars(pos, str.toCharArray(), offset, len);
        }
        return ret;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, true);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), pos, true);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (len < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0").fillInStackTrace();
        }
        this.getDBAccess().trim(this, len);
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public String stringValue() throws SQLException {
        Reader r = this.getCharacterStream();
        int size = this.getBufferSize();
        int length = 0;
        StringWriter w = new StringWriter(size);
        char[] buffer = new char[size];
        try {
            while ((length = r.read(buffer)) != -1) {
                w.write(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        catch (IndexOutOfBoundsException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        return w.getBuffer().substring(0);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new CLOB[arraySize];
    }

    @Override
    public ClobDBAccess getDBAccess() throws SQLException {
        oracle.jdbc.internal.OracleConnection connPhys = this.getPhysicalConnection();
        if (connPhys != null && connPhys.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98).fillInStackTrace();
            }
            this.dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        return this.dbaccess;
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return super.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long _cachedLengthOfClobInChars) {
        this.cachedLengthOfClobInChars = _cachedLengthOfClobInChars;
    }

    @Override
    public final void setChunkSize(int _dbChunkSize) {
        this.dbChunkSize = _dbChunkSize;
    }

    @Override
    public final void setPrefetchData(OracleLargeObject.PrefetchData<char[]> prefetchData) {
        this.prefetchData = prefetchData;
    }

    @Override
    public final OracleLargeObject.PrefetchData<char[]> getPrefetchData() {
        return this.prefetchData;
    }

    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        if (this.activePrefetch && !_activePrefetch) {
            this.clearCachedData();
        }
        this.activePrefetch = _activePrefetch;
    }

    @Override
    public final void clearCachedData() {
        this.cachedLengthOfClobInChars = -1L;
        this.prefetchData = null;
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }

    int dilGetCharSetId() throws SQLException {
        byte msb = this.shareBytes()[32];
        byte lsb = this.shareBytes()[33];
        int result = (msb & 0xFF) << 8 | lsb & 0xFF;
        return result;
    }

    boolean isMigratedAL16UTF16LE() {
        int kol_field4 = this.shareBytes()[7] & 0xFF;
        return (kol_field4 & 0x40) == 64;
    }

    boolean isVariableWidth() {
        int lvar;
        int kol_field3 = this.shareBytes()[6] & 0xFF;
        return (kol_field3 & (lvar = 128)) == lvar;
    }

    void dilGetCharacterSet() throws SQLException {
        if (this.dilCharacterSet == null) {
            if (this.isMigratedAL16UTF16LE()) {
                this.dilCharacterSet = CharacterSet.make(2002);
            } else if (this.isVariableWidth()) {
                this.dilCharacterSet = CharacterSet.make(2000);
            } else {
                int id = this.dilGetCharSetId();
                this.dilCharacterSet = CharacterSet.make(id);
            }
        }
    }

    int dilLength() {
        return this.shareBytes().length - 86 - 16;
    }

    char[] dilGetChars() throws SQLException {
        int dilByteLength = this.dilLength();
        byte[] dilBytes = new byte[dilByteLength];
        System.arraycopy(this.shareBytes(), 102, dilBytes, 0, dilByteLength);
        String dilString = this.dilCharacterSet.toStringWithReplacement(dilBytes, 0, dilByteLength);
        char[] dilChars = dilString.toCharArray();
        return dilChars;
    }

    InputStream dilGetAsciiStream(long pos) throws SQLException {
        byte[] dilBytes;
        char[] dilChars = this.dilGetChars();
        if (pos - 1L > (long)dilChars.length) {
            byte[] dilBytes2 = new byte[]{};
            return new ByteArrayInputStream(dilBytes2);
        }
        if (this.dilGetCharSetId() == 1) {
            dilBytes = new byte[dilChars.length];
            for (int i = 0; i < dilChars.length; ++i) {
                dilBytes[i] = (byte)dilChars[i];
            }
        } else {
            CharacterSet asciiCharSet = CharacterSet.make(1);
            dilBytes = asciiCharSet.convertWithReplacement(new String(dilChars));
        }
        return new ByteArrayInputStream(dilBytes);
    }

    Reader dilGetCharacterStream(long pos) throws SQLException {
        char[] dilChars = this.dilGetChars();
        int lobLen = dilChars.length;
        if (pos - 1L > (long)lobLen) {
            char[] dilNilChar = new char[]{};
            return new CharArrayReader(dilNilChar);
        }
        return new CharArrayReader(dilChars, (int)(pos - 1L), Integer.MAX_VALUE);
    }

    String dilGetSubString(long pos, int length) throws SQLException {
        char[] dilChars = this.dilGetChars();
        if ((int)pos > dilChars.length) {
            return "";
        }
        int lengthAvailable = (int)Math.min((long)length, (long)dilChars.length - (pos - 1L));
        if (lengthAvailable == 0) {
            return "";
        }
        return new String(dilChars, (int)(pos - 1L), lengthAvailable);
    }

    Reader dilGetCharacterStream(long pos, long length) throws SQLException {
        if (pos < 1L || length < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        char[] dilChars = this.dilGetChars();
        long lobLen = dilChars.length;
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        return new CharArrayReader(dilChars, (int)(pos - 1L), (int)length);
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        byte[] loc = this.shareBytes();
        if (loc == null || loc.length < 102) {
            return false;
        }
        if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
            return false;
        }
        int kol_field3 = loc[6] & 0xFF;
        int kol_field4 = loc[7] & 0xFF;
        boolean hasDILBit = (kol_field3 & 8) == 8;
        boolean hasLocalBit = (kol_field4 & 0xFFFFFF80) == -128;
        boolean hasKdfBit = false;
        if (hasDILBit && !hasLocalBit) {
            int kdf_field = loc[88] & 0xFF;
            hasKdfBit = (kdf_field & 8) == 8;
        }
        boolean hasDILData = hasDILBit && !hasLocalBit && hasKdfBit;
        boolean canUseDILData = false;
        if (hasDILData) {
            this.dilGetCharacterSet();
            canUseDILData = !this.dilCharacterSet.isUnknown();
        }
        return canUseDILData;
    }

    @Override
    public void freeLOB() throws SQLException {
        this.freeInternal();
    }

    @Override
    public void free() throws SQLException {
        this.awaitPublishing();
        this.freeInternal();
    }

    private void freeInternal() throws SQLException {
        if (this.isFree) {
            return;
        }
        if (this.isOpen()) {
            this.close();
        }
        this.freeLocal();
    }

    @Override
    public final Flow.Publisher<Void> freeAsyncOracle() throws SQLException {
        if (this.isFree) {
            return CompletionStageUtil.newNoItemPublisher(CompletionStageUtil.VOID_COMPLETED_FUTURE, this.getInternalConnection().getJoinPhaser());
        }
        this.lockBeforePublishing();
        return CompletionStageUtil.newNoItemPublisher(this.getDBAccess().isOpenAsync(this).thenCompose(isOpen -> isOpen != false ? this.dbaccess.closeAsync(this) : CompletionStageUtil.VOID_COMPLETED_FUTURE).thenRun(() -> {
            try {
                this.freeLocal();
            }
            catch (SQLException sqlException) {
                throw new CompletionException(sqlException);
            }
        }), this.getInternalConnection().getJoinPhaser());
    }

    private void freeLocal() throws SQLException {
        if (this.isTemporary()) {
            this.freeTemporary();
        }
        this.getPhysicalConnection().removeLargeObject(this);
        this.isFree = true;
        this.dbaccess = null;
        this.prefetchData = null;
    }

    @Override
    public boolean isFree() {
        return this.isFree;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                pos = 1L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(pos, length);
        }
        long lobLen = this.length();
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        return this.getDBAccess().newReader(this, this.getChunkSize(), pos, length);
    }

    @Override
    public void setBytes(byte[] locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        this.awaitPublishing();
        return null;
    }

    @Override
    public SQLXML toSQLXML(String schemaURL) throws SQLException {
        this.awaitPublishing();
        return null;
    }

    private final void lockBeforePublishing() throws SQLException {
        this.publishingLock.lock();
        this.awaitPublishing();
        try {
            this.isPublishing = true;
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private final void awaitPublishing() throws SQLException {
        this.publishingLock.lock();
        try {
            while (this.isPublishing) {
                this.publishingCondition.await();
            }
        }
        catch (InterruptedException interrupt) {
            throw new SQLException(interrupt);
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private final void unlockAfterPublishing() {
        this.publishingLock.lock();
        try {
            this.isPublishing = false;
            this.publishingCondition.signalAll();
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private static int computeBufferSize(int chunkSize) {
        if (chunkSize >= 32768 || chunkSize <= 0) {
            return 32768;
        }
        return 32768 / chunkSize * chunkSize;
    }
}

