/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;
import javax.security.auth.DestroyFailedException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;

class OpaquePrivateKey {
    private final OpaqueString opaqueEncoding;
    private static final byte[] BEGIN_PRIVATE_KEY_UTF8 = "-----BEGIN PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
    private static final byte[] END_PRIVATE_KEY_UTF8 = "-----END PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LINE_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpaquePrivateKey fromPemFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        byte[] pemBytes = Files.readAllBytes(path);
        try {
            OpaquePrivateKey opaquePrivateKey;
            int beginTagOffset = OpaquePrivateKey.findTag(pemBytes, 0, BEGIN_PRIVATE_KEY_UTF8);
            if (beginTagOffset == -1) {
                throw DatabaseError.formatSqlException(null, 1727, null, null, path, new String(BEGIN_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            int payloadOffset = beginTagOffset + BEGIN_PRIVATE_KEY_UTF8.length + LINE_SEPARATOR.length;
            int endTagOffset = OpaquePrivateKey.findTag(pemBytes, payloadOffset, END_PRIVATE_KEY_UTF8);
            if (endTagOffset == -1) {
                throw DatabaseError.formatSqlException(null, 1727, null, null, path, new String(END_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            byte[] base64Key = Arrays.copyOfRange(pemBytes, payloadOffset, endTagOffset);
            try {
                opaquePrivateKey = new OpaquePrivateKey(OpaquePrivateKey.decodeBase64Key(base64Key));
            }
            catch (Throwable throwable) {
                Arrays.fill(base64Key, (byte)0);
                throw throwable;
            }
            Arrays.fill(base64Key, (byte)0);
            return opaquePrivateKey;
        }
        finally {
            Arrays.fill(pemBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString decodeBase64Key(byte[] base64Key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedKey = Base64.getMimeDecoder().decode(base64Key);
        try {
            OpaqueString opaqueString;
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            try {
                opaqueString = OpaquePrivateKey.encodeKey(privateKey);
            }
            catch (Throwable throwable) {
                OpaquePrivateKey.tryDestroyKey(privateKey);
                throw throwable;
            }
            OpaquePrivateKey.tryDestroyKey(privateKey);
            return opaqueString;
        }
        finally {
            Arrays.fill(encodedKey, (byte)0);
        }
    }

    private OpaquePrivateKey(@Blind OpaqueString opaqueEncoding) {
        this.opaqueEncoding = opaqueEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    public static OpaqueString encodeKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encoded = KeyFactory.getInstance("RSA").getKeySpec(privateKey, PKCS8EncodedKeySpec.class).getEncoded();
        try {
            char[] encodedChars = new char[encoded.length];
            for (int i = 0; i < encoded.length; ++i) {
                encodedChars[i] = (char)encoded[i];
            }
            OpaqueString opaqueString = OpaqueString.newOpaqueString(encodedChars);
            return opaqueString;
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private PrivateKey decodeKey(OpaqueString opaqueString) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] encodedChars = opaqueString.getChars();
        try {
            PrivateKey privateKey;
            byte[] encoded = new byte[encodedChars.length];
            try {
                for (int i = 0; i < encodedChars.length; ++i) {
                    encoded[i] = (byte)encodedChars[i];
                }
                privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            catch (Throwable throwable) {
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            Arrays.fill(encoded, (byte)0);
            return privateKey;
        }
        finally {
            Arrays.fill(encodedChars, '\u0000');
        }
    }

    private static void tryDestroyKey(PrivateKey privateKey) {
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    private static int findTag(byte[] pemBytes, int offset, byte[] tag) {
        while (offset < pemBytes.length) {
            if (OpaquePrivateKey.arrayEquals(pemBytes, offset, tag)) {
                return offset;
            }
            int lineEnd = OpaquePrivateKey.arrayIndexOf(pemBytes, offset, LINE_SEPARATOR);
            if (lineEnd == -1) break;
            offset = lineEnd + 1;
        }
        return -1;
    }

    private static boolean arrayEquals(byte[] a, int aOffset, byte[] b) {
        if (aOffset + b.length > a.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i + aOffset] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static int arrayIndexOf(byte[] array, int arrayOffset, byte[] match) {
        for (int i = arrayOffset; i < array.length; ++i) {
            if (!OpaquePrivateKey.arrayEquals(array, i, match)) continue;
            return i;
        }
        return -1;
    }

    @Blind
    static OpaquePrivateKey fromPrivateKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        OpaqueString encodedKey = OpaquePrivateKey.encodeKey(privateKey);
        return new OpaquePrivateKey(encodedKey);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof OpaquePrivateKey && Objects.equals(this.opaqueEncoding, ((OpaquePrivateKey)object).opaqueEncoding);
    }

    public int hashCode() {
        return Objects.hash(this.opaqueEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    <T, E extends Throwable> T map(ThrowingFunction<PrivateKey, T, E> mapper) throws E, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey deobfuscatedKey = this.decodeKey(this.opaqueEncoding);
        try {
            T t = mapper.applyOrThrow(deobfuscatedKey);
            return t;
        }
        finally {
            OpaquePrivateKey.tryDestroyKey(deobfuscatedKey);
        }
    }

    static interface ThrowingFunction<T, R, E extends Throwable>
    extends Function<T, R> {
        public R applyOrThrow(T var1) throws E;

        @Override
        default public R apply(T input) {
            try {
                return this.applyOrThrow(input);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
    }
}

