/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventStoreProviderFactory;
import org.keycloak.events.jpa.JpaEventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.storage.datastore.PeriodicEventInvalidation;

public class JpaEventStoreProviderFactory
implements EventStoreProviderFactory,
InvalidationHandler {
    public static final String ID = "jpa";
    private int maxDetailLength;
    private int maxFieldLength;

    public EventStoreProvider create(KeycloakSession session) {
        JpaConnectionProvider connection = (JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class);
        return new JpaEventStoreProvider(session, connection.getEntityManager(), this.maxDetailLength, this.maxFieldLength);
    }

    public void init(Config.Scope config) {
        this.maxDetailLength = config.getInt("max-detail-length", Integer.valueOf(-1));
        this.maxFieldLength = config.getInt("max-field-length", Integer.valueOf(-1));
        if (this.maxDetailLength != -1 && this.maxDetailLength < 3) {
            throw new IllegalArgumentException("max-detail-length cannot be less that 3.");
        }
        if (this.maxFieldLength != -1 && this.maxFieldLength < 3) {
            throw new IllegalArgumentException("max-field-length cannot be less that 3.");
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... params) {
        if (type == PeriodicEventInvalidation.JPA_EVENT_STORE) {
            ((JpaEventStoreProvider)session.getProvider(EventStoreProvider.class)).clearExpiredAdminEvents();
        }
    }
}

