/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.storage.CrudOperations;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.file.FileCriteriaBuilder;
import org.keycloak.models.map.storage.file.FileMapStorageProviderFactory;
import org.keycloak.models.map.storage.file.common.MapEntityContext;
import org.keycloak.models.map.storage.file.common.WritingMechanism;
import org.keycloak.models.map.storage.file.yaml.PathWriter;
import org.keycloak.models.map.storage.file.yaml.YamlParser;
import org.keycloak.models.map.storage.file.yaml.YamlWritingMechanism;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.emitter.Emitter;

public abstract class FileCrudOperations<V extends AbstractEntity & UpdatableEntity, M>
implements CrudOperations<V, M>,
HasRealmId {
    private static final Logger LOG = Logger.getLogger(FileCrudOperations.class);
    private String defaultRealmId;
    private final Class<V> entityClass;
    private final Function<String, Path> dataDirectoryFunc;
    private final Function<V, String[]> suggestedPath;
    private final boolean isExpirableEntity;
    private final Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<String, V, M>> fieldPredicates;
    private static final Map<Class<?>, Map<SearchableModelField<?>, MapModelCriteriaBuilder.UpdatePredicatesFunc<?, ?, ?>>> ENTITY_FIELD_PREDICATES = new HashMap();
    public static final String SEARCHABLE_FIELD_REALM_ID_FIELD_NAME = ClientModel.SearchableFields.REALM_ID.getName();
    public static final String FILE_SUFFIX = ".yaml";
    public static final DumpSettings DUMP_SETTINGS = DumpSettings.builder().setIndent(4).setIndicatorIndent(2).setIndentWithIndicator(false).build();
    private static final Pattern RESERVED_CHARACTERS = Pattern.compile("[%<:>\"/\\\\|?*=]");
    public static final String ID_COMPONENT_SEPARATOR = ":";
    private static final String ESCAPING_CHARACTER = "=";
    private static final Pattern ID_COMPONENT_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(":") + "+");

    public FileCrudOperations(Class<V> entityClass, Function<String, Path> dataDirectoryFunc, Function<V, String[]> suggestedPath, boolean isExpirableEntity) {
        this.entityClass = entityClass;
        this.dataDirectoryFunc = dataDirectoryFunc;
        this.suggestedPath = suggestedPath;
        this.isExpirableEntity = isExpirableEntity;
        this.fieldPredicates = new IdentityHashMap<SearchableModelField<M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<String, MapModelCriteriaBuilder.UpdatePredicatesFunc<String, V, M>, M>>(FileCrudOperations.getPredicates(entityClass));
        this.fieldPredicates.keySet().stream().filter(f -> Objects.equals(SEARCHABLE_FIELD_REALM_ID_FIELD_NAME, f.getName())).findAny().ifPresent(key -> this.fieldPredicates.replace((SearchableModelField<M>)key, (builder, op, params) -> builder));
    }

    public static <V extends AbstractEntity & UpdatableEntity, M> Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<String, V, M>> getPredicates(Class<V> entityClass) {
        return ENTITY_FIELD_PREDICATES.computeIfAbsent(entityClass, n -> {
            IdentityHashMap fieldPredicates = new IdentityHashMap(MapFieldPredicates.getPredicates((Class)ModelEntityUtil.getModelType((Class)entityClass)));
            fieldPredicates.keySet().stream().filter(f -> Objects.equals(SEARCHABLE_FIELD_REALM_ID_FIELD_NAME, f.getName())).findAny().ifPresent(key -> fieldPredicates.replace(key, (builder, op, params) -> builder));
            return fieldPredicates;
        });
    }

    protected Path getPathForEscapedId(String[] escapedIdPathArray) {
        Path parentDirectory;
        Path targetPath = parentDirectory = this.getDataDirectory();
        for (String path : escapedIdPathArray) {
            if (!(targetPath = targetPath.resolve(path).normalize()).getParent().equals(parentDirectory)) {
                LOG.warnf("Path traversal detected: %s", (Object)Arrays.toString(escapedIdPathArray));
                return null;
            }
            parentDirectory = targetPath;
        }
        return targetPath.resolveSibling(targetPath.getFileName() + FILE_SUFFIX);
    }

    protected Path getPathForEscapedId(String escapedId) {
        if (escapedId == null) {
            throw new IllegalStateException("Invalid ID to escape");
        }
        String[] escapedIdArray = ID_COMPONENT_SEPARATOR_PATTERN.split(escapedId);
        return this.getPathForEscapedId(escapedIdArray);
    }

    private static String[] escapeId(String[] idArray) {
        if (idArray == null || idArray.length == 0 || idArray.length == 1 && idArray[0] == null) {
            return null;
        }
        return (String[])Stream.of(idArray).map(FileCrudOperations::escapeId).toArray(String[]::new);
    }

    private static String escapeId(String id) {
        Objects.requireNonNull(id, "ID must be non-null");
        StringBuilder idEscaped = new StringBuilder();
        Matcher m = RESERVED_CHARACTERS.matcher(id);
        while (m.find()) {
            m.appendReplacement(idEscaped, String.format("=%02x", m.group().charAt(0)));
        }
        m.appendTail(idEscaped);
        Path pId = Path.of(idEscaped.toString(), new String[0]);
        return pId.toString();
    }

    public static boolean canParseFile(Path p) {
        String fn = p.getFileName().toString();
        try {
            return Files.isRegularFile(p, new LinkOption[0]) && Files.size(p) > 0L && !fn.startsWith(".") && fn.endsWith(FILE_SUFFIX) && Files.isReadable(p);
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected V parse(Path fileName) {
        this.getLastModifiedTime(fileName);
        AbstractEntity parsedObject = (AbstractEntity)YamlParser.parse(fileName, new MapEntityContext<V>(this.entityClass));
        if (parsedObject == null) {
            LOG.debugf("Could not parse %s%s", (Object)fileName, StackUtil.getShortStackTrace());
            return null;
        }
        String fileNameStr = fileName.getFileName().toString();
        String idFromFilename = fileNameStr.substring(0, fileNameStr.length() - FILE_SUFFIX.length());
        String escapedId = this.determineKeyFromValue(parsedObject, idFromFilename);
        if (escapedId == null) {
            LOG.tracef("Determined ID from filename: %s%s", (Object)idFromFilename);
            escapedId = idFromFilename;
        } else if (!escapedId.endsWith(idFromFilename)) {
            LOG.warnf("Id \"%s\" does not conform with filename \"%s\", expected: %s", (Object)escapedId, (Object)fileNameStr, (Object)FileCrudOperations.escapeId(escapedId));
        }
        parsedObject.setId(escapedId);
        ((UpdatableEntity)parsedObject).clearUpdatedFlag();
        return (V)parsedObject;
    }

    public V create(V value) {
        String escapedId = value.getId();
        this.writeYamlContents(this.getPathForEscapedId(escapedId), value);
        return value;
    }

    public String determineKeyFromValue(V value, String lastIdComponentIfUnset) {
        CharSequence[] proposedId = this.suggestedPath.apply(value);
        if (proposedId == null || proposedId.length == 0) {
            return lastIdComponentIfUnset;
        }
        if (proposedId[proposedId.length - 1] == null) {
            proposedId[proposedId.length - 1] = lastIdComponentIfUnset;
        }
        CharSequence[] escapedProposedId = FileCrudOperations.escapeId((String[])proposedId);
        String res = String.join((CharSequence)ID_COMPONENT_SEPARATOR, escapedProposedId);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("determineKeyFromValue: got %s (%s) for %s", (Object)res, (Object)(res == null ? null : String.join((CharSequence)" [/] ", proposedId)), value);
        }
        return res;
    }

    public String determineKeyFromValue(V value) {
        boolean randomId;
        String[] proposedId = this.suggestedPath.apply(value);
        if (proposedId == null || proposedId.length == 0) {
            randomId = value.getId() == null;
            proposedId = new String[]{value.getId() == null ? StringKeyConverter.StringKey.INSTANCE.yieldNewUniqueKey() : value.getId()};
        } else if (proposedId[proposedId.length - 1] == null) {
            randomId = true;
            proposedId[proposedId.length - 1] = StringKeyConverter.StringKey.INSTANCE.yieldNewUniqueKey();
        } else {
            randomId = false;
        }
        CharSequence[] escapedProposedId = FileCrudOperations.escapeId(proposedId);
        Path sp = this.getPathForEscapedId((String[])escapedProposedId);
        Path parentDir = sp.getParent();
        if (!Files.isDirectory(parentDir, new LinkOption[0])) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Directory does not exist and cannot be created: " + parentDir, ex);
            }
        }
        for (int counter = 0; counter < 100; ++counter) {
            LOG.tracef("Attempting to create file %s", (Object)sp, StackUtil.getShortStackTrace());
            try {
                String res = String.join((CharSequence)ID_COMPONENT_SEPARATOR, escapedProposedId);
                this.touch(res, sp);
                LOG.tracef("determineKeyFromValue: got %s for created %s", (Object)res, value);
                return res;
            }
            catch (FileAlreadyExistsException ex) {
                if (!randomId) {
                    throw new ModelDuplicateException("File " + sp + " already exists!");
                }
                String lastComponent = StringKeyConverter.StringKey.INSTANCE.yieldNewUniqueKey();
                escapedProposedId[escapedProposedId.length - 1] = lastComponent;
                sp = this.getPathForEscapedId((String[])escapedProposedId);
                continue;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not create file " + sp, ex);
            }
        }
        return null;
    }

    public V read(String key) {
        return (V)((AbstractEntity)Optional.ofNullable(key).map(this::getPathForEscapedId).filter(Files::isReadable).map(this::parse).orElse(null));
    }

    public MapModelCriteriaBuilder<String, V, M> createCriteriaBuilder() {
        return new MapModelCriteriaBuilder((StringKeyConverter)StringKeyConverter.StringKey.INSTANCE, this.fieldPredicates);
    }

    public Stream<V> read(QueryParameters<M> queryParameters) {
        List paths;
        FileCriteriaBuilder cb = (FileCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(FileCriteriaBuilder.criteria());
        String realmId = (String)cb.getSingleRestrictionArgument(SEARCHABLE_FIELD_REALM_ID_FIELD_NAME);
        this.setRealmId(realmId);
        Path dataDirectory = this.getDataDirectory();
        if (!Files.isDirectory(dataDirectory, new LinkOption[0])) {
            return Stream.empty();
        }
        try (Stream<Path> dirStream = Files.walk(dataDirectory, this.entityClass == MapRealmEntity.class ? 1 : 3, new FileVisitOption[0]);){
            paths = dirStream.collect(Collectors.toList());
        }
        catch (IOException | UncheckedIOException ex) {
            LOG.warnf((Throwable)ex, "Error listing %s", (Object)dataDirectory);
            return Stream.empty();
        }
        Stream<AbstractEntity> res = paths.stream().filter(FileCrudOperations::canParseFile).map(this::parse).filter(x$0 -> Objects.nonNull(x$0));
        MapModelCriteriaBuilder mcb = (MapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        Predicate keyFilter = mcb.getKeyFilter();
        Predicate<Object> entityFilter = this.isExpirableEntity ? mcb.getEntityFilter().and(ExpirationUtils::isNotExpired) : mcb.getEntityFilter();
        res = res.filter(e -> keyFilter.test(e.getId()) && entityFilter.test(e));
        if (!queryParameters.getOrderBy().isEmpty()) {
            res = res.sorted(MapFieldPredicates.getComparator(queryParameters.getOrderBy().stream()));
        }
        return StreamsUtil.paginatedStream(res, (Integer)queryParameters.getOffset(), (Integer)queryParameters.getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V update(V value) {
        String escapedId = value.getId();
        Path sp = this.getPathForEscapedId(escapedId);
        if (sp == null) {
            throw new IllegalArgumentException("Invalid path: " + escapedId);
        }
        this.checkIsSafeToModify(sp);
        Class<FileMapStorageProviderFactory> clazz = FileMapStorageProviderFactory.class;
        synchronized (FileMapStorageProviderFactory.class) {
            this.writeYamlContents(sp, value);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return value;
        }
    }

    public boolean delete(String key) {
        return Optional.ofNullable(key).map(this::getPathForEscapedId).map(this::removeIfExists).orElse(false);
    }

    public long delete(QueryParameters<M> queryParameters) {
        return this.read(queryParameters).map(rec$ -> ((AbstractEntity)rec$).getId()).map(this::delete).filter(a -> a).count();
    }

    public long getCount(QueryParameters<M> queryParameters) {
        return this.read(queryParameters).count();
    }

    public String getRealmId() {
        return this.defaultRealmId;
    }

    public void setRealmId(String realmId) {
        this.defaultRealmId = realmId;
    }

    private Path getDataDirectory() {
        return this.dataDirectoryFunc.apply(this.defaultRealmId == null ? null : FileCrudOperations.escapeId(this.defaultRealmId));
    }

    private void writeYamlContents(Path sp, V value) {
        Path tempSp = sp.resolveSibling("." + this.getTxId() + "-" + sp.getFileName());
        try (PathWriter w = new PathWriter(tempSp);){
            Emitter emitter = new Emitter(DUMP_SETTINGS, (StreamDataWriter)w);
            try (YamlWritingMechanism mech = new YamlWritingMechanism(arg_0 -> ((Emitter)emitter).emit(arg_0));){
                new MapEntityContext<V>(this.entityClass).writeValue(value, (WritingMechanism)mech);
            }
            this.registerRenameOnCommit(tempSp, sp);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot write " + sp, ex);
        }
    }

    protected abstract void touch(String var1, Path var2) throws IOException;

    protected abstract boolean removeIfExists(Path var1);

    protected abstract void registerRenameOnCommit(Path var1, Path var2);

    protected abstract String getTxId();

    protected abstract FileTime getLastModifiedTime(Path var1);

    protected abstract void checkIsSafeToModify(Path var1);
}

