/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.io.PrintWriter;
import picocli.CommandLine;

public class ShortErrorMessageHandler
implements CommandLine.IParameterExceptionHandler {
    public int handleParseException(CommandLine.ParameterException ex, String[] args) {
        CommandLine cmd = ex.getCommandLine();
        PrintWriter writer = cmd.getErr();
        Object errorMessage = ex.getMessage();
        if (ex instanceof CommandLine.UnmatchedArgumentException) {
            String original;
            CommandLine.UnmatchedArgumentException uae = (CommandLine.UnmatchedArgumentException)ex;
            String[] unmatched = this.getUnmatchedPartsByOptionSeparator(uae, "=");
            if (unmatched[0].equals(original = (String)uae.getUnmatched().get(0))) {
                unmatched = this.getUnmatchedPartsByOptionSeparator(uae, " ");
            }
            errorMessage = "Unknown option: '" + unmatched[0] + "'";
        }
        writer.println(cmd.getColorScheme().errorText((String)errorMessage));
        CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)writer);
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        writer.printf("Try '%s --help' for more information on the available options.%n", spec.qualifiedName());
        return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : spec.exitCodeOnInvalidInput();
    }

    private String[] getUnmatchedPartsByOptionSeparator(CommandLine.UnmatchedArgumentException uae, String separator) {
        return ((String)uae.getUnmatched().get(0)).split(separator);
    }
}

