/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.CaseStatementDiscriminatorMappingImpl;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.results.Builders;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.FromClauseAccessImpl;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.LegacyFetchResolver;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public class DomainResultCreationStateImpl
implements DomainResultCreationState,
SqlAstCreationState,
SqlAstProcessingState,
SqlExpressionResolver {
    private static final String DISCRIMINATOR_ALIAS = "clazz_";
    private final String stateIdentifier;
    private final FromClauseAccessImpl fromClauseAccess;
    private final JdbcValuesMetadata jdbcResultsMetadata;
    private final Consumer<SqlSelection> sqlSelectionConsumer;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final Map<SqlExpressionResolver.ColumnReferenceKey, ResultSetMappingSqlSelection> sqlSelectionMap = new HashMap<SqlExpressionResolver.ColumnReferenceKey, ResultSetMappingSqlSelection>();
    private boolean allowPositionalSelections = true;
    private final SqlAliasBaseManager sqlAliasBaseManager;
    private final LegacyFetchResolverImpl legacyFetchResolver;
    private final SessionFactoryImplementor sessionFactory;
    private final Stack<Function> fetchBuilderResolverStack = new StandardStack<Function<Object, Object>>(Function.class, fetchableName -> null);
    private final Stack<Map.Entry> relativePathStack = new StandardStack<Map.Entry>(Map.Entry.class);
    private Map<String, LockMode> registeredLockModes;
    private boolean processingKeyFetches = false;
    private boolean resolvingCircularFetch;
    private ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide;
    private FetchParent nestingFetchParent;

    public DomainResultCreationStateImpl(String stateIdentifier, JdbcValuesMetadata jdbcResultsMetadata, Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders, Consumer<SqlSelection> sqlSelectionConsumer, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        this.stateIdentifier = stateIdentifier;
        this.jdbcResultsMetadata = jdbcResultsMetadata;
        this.sqlSelectionConsumer = sqlSelectionConsumer;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.fromClauseAccess = new FromClauseAccessImpl();
        this.sqlAliasBaseManager = new SqlAliasBaseManager();
        this.legacyFetchResolver = new LegacyFetchResolverImpl(legacyFetchBuilders);
        this.sessionFactory = sessionFactory;
    }

    public LegacyFetchResolver getLegacyFetchResolver() {
        return this.legacyFetchResolver;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public int getNumberOfProcessedSelections() {
        return this.sqlSelectionMap.size();
    }

    public boolean arePositionalSelectionsAllowed() {
        return this.allowPositionalSelections;
    }

    public void disallowPositionalSelections() {
        if (ResultsLogger.DEBUG_ENABLED) {
            ResultsLogger.RESULTS_LOGGER.debugf("Disallowing positional selections : %s", (Object)this.stateIdentifier);
        }
        this.allowPositionalSelections = false;
    }

    public JdbcValuesMetadata getJdbcResultsMetadata() {
        return this.jdbcResultsMetadata;
    }

    public Map.Entry<String, NavigablePath> getCurrentRelativePath() {
        return this.relativePathStack.getCurrent();
    }

    public void pushExplicitFetchMementoResolver(Function<String, FetchBuilder> resolver) {
        this.fetchBuilderResolverStack.push(resolver);
    }

    public Function<String, FetchBuilder> getCurrentExplicitFetchMementoResolver() {
        return this.fetchBuilderResolverStack.getCurrent();
    }

    public Function<String, FetchBuilder> popExplicitFetchMementoResolver() {
        return this.fetchBuilderResolverStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withExplicitFetchMementoResolver(Function<String, FetchBuilder> resolver, Runnable runnable) {
        this.pushExplicitFetchMementoResolver(resolver);
        try {
            runnable.run();
        }
        finally {
            Function<String, FetchBuilder> popped = this.popExplicitFetchMementoResolver();
            assert (popped == resolver);
        }
    }

    @Override
    public FromClauseAccessImpl getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    @Override
    public DomainResultCreationStateImpl getSqlAstCreationState() {
        return this;
    }

    @Override
    public SqlAliasBaseManager getSqlAliasBaseManager() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public boolean forceIdentifierSelection() {
        return true;
    }

    @Override
    public boolean registerVisitedAssociationKey(AssociationKey associationKey) {
        return false;
    }

    @Override
    public boolean isAssociationKeyVisited(AssociationKey associationKey) {
        return false;
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        TableGroup parentTableGroup;
        TableGroup tableGroup = this.fromClauseAccess.findTableGroup(navigablePath);
        if (tableGroup != null) {
            return tableGroup.getModelPart();
        }
        if (navigablePath.getParent() != null && (parentTableGroup = this.fromClauseAccess.findTableGroup(navigablePath.getParent())) != null) {
            return parentTableGroup.getModelPart().findSubPart(navigablePath.getLocalName(), null);
        }
        return null;
    }

    @Override
    public DomainResultCreationStateImpl getSqlExpressionResolver() {
        return this.getCurrentProcessingState();
    }

    @Override
    public void registerLockMode(String identificationVariable, LockMode explicitLockMode) {
        if (this.registeredLockModes == null) {
            this.registeredLockModes = new HashMap<String, LockMode>();
        }
        this.registeredLockModes.put(identificationVariable, explicitLockMode);
    }

    public Map<String, LockMode> getRegisteredLockModes() {
        return this.registeredLockModes;
    }

    @Override
    public DomainResultCreationStateImpl getCurrentProcessingState() {
        return this;
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.getSessionFactory();
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public Expression resolveSqlExpression(SqlExpressionResolver.ColumnReferenceKey key, Function<SqlAstProcessingState, Expression> creator) {
        ResultSetMappingSqlSelection existing = this.sqlSelectionMap.get(key);
        if (existing != null) {
            return existing;
        }
        Expression created = creator.apply(this);
        if (created instanceof ResultSetMappingSqlSelection) {
            this.sqlSelectionMap.put(key, (ResultSetMappingSqlSelection)created);
            this.sqlSelectionConsumer.accept((ResultSetMappingSqlSelection)created);
        } else {
            if (created instanceof ColumnReference) {
                int valuesArrayPosition;
                ColumnReference columnReference = (ColumnReference)created;
                String selectableName = columnReference.getSelectableName();
                if (this.nestingFetchParent != null) {
                    valuesArrayPosition = this.nestingFetchParent.getReferencedMappingType().getSelectableIndex(selectableName);
                } else {
                    int jdbcPosition = this.jdbcResultsMetadata.resolveColumnPosition(selectableName);
                    valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
                }
                ResultSetMappingSqlSelection sqlSelection = new ResultSetMappingSqlSelection(valuesArrayPosition, columnReference.getJdbcMapping());
                this.sqlSelectionMap.put(key, sqlSelection);
                this.sqlSelectionConsumer.accept(sqlSelection);
                return sqlSelection;
            }
            if (created instanceof CaseStatementDiscriminatorMappingImpl.CaseStatementDiscriminatorExpression) {
                int valuesArrayPosition;
                if (this.nestingFetchParent != null) {
                    valuesArrayPosition = this.nestingFetchParent.getReferencedMappingType().getSelectableIndex(DISCRIMINATOR_ALIAS);
                } else {
                    int jdbcPosition = this.jdbcResultsMetadata.resolveColumnPosition(DISCRIMINATOR_ALIAS);
                    valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
                }
                ResultSetMappingSqlSelection sqlSelection = new ResultSetMappingSqlSelection(valuesArrayPosition, created.getExpressionType().getSingleJdbcMapping());
                this.sqlSelectionMap.put(key, sqlSelection);
                this.sqlSelectionConsumer.accept(sqlSelection);
                return sqlSelection;
            }
        }
        return created;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaType, FetchParent fetchParent, TypeConfiguration typeConfiguration) {
        if (expression == null) {
            throw new IllegalArgumentException("Expression cannot be null");
        }
        assert (expression instanceof ResultSetMappingSqlSelection);
        return (SqlSelection)((Object)expression);
    }

    @Override
    public ImmutableFetchList visitNestedFetches(FetchParent fetchParent) {
        FetchParent oldNestingFetchParent = this.nestingFetchParent;
        this.nestingFetchParent = fetchParent;
        ImmutableFetchList fetches = this.visitFetches(fetchParent);
        this.nestingFetchParent = oldNestingFetchParent;
        return fetches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch visitIdentifierFetch(EntityResultGraphNode fetchParent) {
        EntityValuedModelPart parentModelPart = fetchParent.getEntityValuedModelPart();
        EntityIdentifierMapping identifierMapping = parentModelPart.getEntityMappingType().getIdentifierMapping();
        String identifierAttributeName = ResultsHelper.attributeName(identifierMapping);
        Map.Entry oldEntry = this.relativePathStack.getCurrent();
        Object fullPath = identifierMapping instanceof NonAggregatedIdentifierMapping ? (oldEntry == null ? "" : (String)oldEntry.getKey()) : (oldEntry == null ? identifierAttributeName : (String)oldEntry.getKey() + "." + identifierAttributeName);
        Fetchable identifierFetchable = (Fetchable)((Object)identifierMapping);
        FetchBuilder explicitFetchBuilder = (FetchBuilder)this.fetchBuilderResolverStack.getCurrent().apply(fullPath);
        DynamicFetchBuilderLegacy fetchBuilderLegacy = explicitFetchBuilder == null ? this.legacyFetchResolver.resolve(this.fromClauseAccess.findTableGroup(fetchParent.getNavigablePath()).getPrimaryTableReference().getIdentificationVariable(), identifierAttributeName) : null;
        EntityIdentifierNavigablePath fetchPath = new EntityIdentifierNavigablePath(fetchParent.getNavigablePath(), identifierAttributeName);
        boolean processingKeyFetches = this.processingKeyFetches;
        this.processingKeyFetches = true;
        if (identifierMapping instanceof CompositeIdentifierMapping) {
            this.relativePathStack.push(new AbstractMap.SimpleEntry<String, EntityIdentifierNavigablePath>((String)fullPath, fetchPath));
        }
        try {
            FetchBuilder fetchBuilder = explicitFetchBuilder != null ? explicitFetchBuilder : (fetchBuilderLegacy == null ? Builders.implicitFetchBuilder(fetchPath, identifierFetchable, this) : fetchBuilderLegacy);
            Fetch fetch = fetchBuilder.buildFetch(fetchParent, fetchPath, this.jdbcResultsMetadata, (s, s2) -> {
                throw new UnsupportedOperationException();
            }, this);
            return fetch;
        }
        finally {
            this.processingKeyFetches = processingKeyFetches;
            if (identifierMapping instanceof CompositeIdentifierMapping) {
                this.relativePathStack.pop();
            }
        }
    }

    @Override
    public ImmutableFetchList visitFetches(FetchParent fetchParent) {
        FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(fetchableContainer);
        Consumer<Fetchable> fetchableConsumer = this.createFetchableConsumer(fetchParent, fetches);
        fetchableContainer.visitKeyFetchables(fetchableConsumer, null);
        fetchableContainer.visitFetchables(fetchableConsumer, null);
        return fetches.build();
    }

    private Consumer<Fetchable> createFetchableConsumer(FetchParent fetchParent, ImmutableFetchList.Builder fetches) {
        return fetchable -> {
            AbstractMap.SimpleEntry<Object, NavigablePath> currentEntry;
            if (!fetchable.isSelectable()) {
                return;
            }
            String fetchableName = fetchable.getFetchableName();
            if (this.relativePathStack.isEmpty()) {
                currentEntry = new AbstractMap.SimpleEntry<String, NavigablePath>(this.getRelativePath("", (Fetchable)fetchable), new NavigablePath(fetchableName));
            } else {
                Map.Entry oldEntry = this.relativePathStack.getCurrent();
                String key = (String)oldEntry.getKey();
                currentEntry = new AbstractMap.SimpleEntry<String, NavigablePath>(this.getRelativePath(key, (Fetchable)fetchable), ((NavigablePath)oldEntry.getValue()).append(fetchableName));
            }
            String fullPath = (String)currentEntry.getKey();
            FetchBuilder explicitFetchBuilder = (FetchBuilder)this.fetchBuilderResolverStack.getCurrent().apply(fullPath);
            DynamicFetchBuilderLegacy fetchBuilderLegacy = explicitFetchBuilder == null ? this.legacyFetchResolver.resolve(this.fromClauseAccess.findTableGroup(fetchParent.getNavigablePath()).getPrimaryTableReference().getIdentificationVariable(), fetchableName) : null;
            if (fetchable instanceof Association && fetchable.getMappedFetchOptions().getTiming() == FetchTiming.DELAYED) {
                Association association = (Association)fetchable;
                ForeignKeyDescriptor foreignKeyDescriptor = association.getForeignKeyDescriptor();
                String partName = ResultsHelper.attributeName(foreignKeyDescriptor.getSide(association.getSideNature().inverse()).getModelPart());
                if (explicitFetchBuilder == null && fetchBuilderLegacy == null && partName != null) {
                    currentEntry = new AbstractMap.SimpleEntry<CallSite, NavigablePath>((CallSite)((Object)((String)currentEntry.getKey() + "." + partName)), ((NavigablePath)currentEntry.getValue()).append(partName));
                    explicitFetchBuilder = (FetchBuilder)this.fetchBuilderResolverStack.getCurrent().apply(currentEntry.getKey());
                    if (explicitFetchBuilder == null) {
                        fetchBuilderLegacy = this.legacyFetchResolver.resolve(this.fromClauseAccess.findTableGroup(fetchParent.getNavigablePath()).getPrimaryTableReference().getIdentificationVariable(), fetchableName);
                    }
                }
            }
            this.relativePathStack.push(currentEntry);
            try {
                NavigablePath fetchPath = fetchParent.resolveNavigablePath((Fetchable)fetchable);
                FetchBuilder fetchBuilder = explicitFetchBuilder != null ? explicitFetchBuilder : (fetchBuilderLegacy == null ? Builders.implicitFetchBuilder(fetchPath, fetchable, this) : fetchBuilderLegacy);
                Fetch fetch = fetchBuilder.buildFetch(fetchParent, fetchPath, this.jdbcResultsMetadata, (s, s2) -> {
                    throw new UnsupportedOperationException();
                }, this);
                fetches.add(fetch);
            }
            finally {
                this.relativePathStack.pop();
            }
        };
    }

    private String getRelativePath(String oldEntry, Fetchable fetchable) {
        if (fetchable instanceof AttributeMapping || fetchable instanceof SingleAttributeIdentifierMapping || fetchable instanceof BasicValuedCollectionPart) {
            if (!oldEntry.equals("")) {
                return oldEntry + "." + fetchable.getFetchableName();
            }
            return fetchable.getFetchableName();
        }
        return oldEntry;
    }

    @Override
    public boolean isResolvingCircularFetch() {
        return this.resolvingCircularFetch;
    }

    @Override
    public void setResolvingCircularFetch(boolean resolvingCircularFetch) {
        this.resolvingCircularFetch = resolvingCircularFetch;
    }

    @Override
    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart() {
        return this.currentlyResolvingForeignKeySide;
    }

    @Override
    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide) {
        this.currentlyResolvingForeignKeySide = currentlyResolvingForeignKeySide;
    }

    private static class LegacyFetchResolverImpl
    implements LegacyFetchResolver {
        private final Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders;

        public LegacyFetchResolverImpl(Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders) {
            this.legacyFetchBuilders = legacyFetchBuilders;
        }

        @Override
        public DynamicFetchBuilderLegacy resolve(String ownerTableAlias, String fetchedPartPath) {
            if (this.legacyFetchBuilders == null) {
                return null;
            }
            Map<String, DynamicFetchBuilderLegacy> fetchBuilders = this.legacyFetchBuilders.get(ownerTableAlias);
            if (fetchBuilders == null) {
                return null;
            }
            return fetchBuilders.get(fetchedPartPath);
        }
    }
}

