/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfigKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "", "name", "", "paths", "", "patterns", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPaths", "()Ljava/util/List;", "setPaths", "(Ljava/util/List;)V", "getPatterns", "setPatterns", "component1", "component2", "component3", "copy", "equals", "", "other", "getProfileScope", "Lcom/intellij/psi/search/scope/packageSet/PackageSet;", "projectPath", "Ljava/nio/file/Path;", "hashCode", "", "toString", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,305:1\n1549#2:306\n1620#2,3:307\n37#3,2:310\n*S KotlinDebug\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope\n*L\n84#1:306\n84#1:307,3\n106#1:310,2\n*E\n"})
public final class InspectScope {
    @NotNull
    private String name;
    @NotNull
    private List<String> paths;
    @NotNull
    private List<String> patterns;

    public InspectScope(@NotNull String name, @NotNull List<String> paths, @NotNull List<String> patterns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.name = name;
        this.paths = paths;
        this.patterns = patterns;
    }

    public /* synthetic */ InspectScope(String string, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(string, list2, list3);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final List<String> getPaths() {
        return this.paths;
    }

    public final void setPaths(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.paths = list2;
    }

    @NotNull
    public final List<String> getPatterns() {
        return this.patterns;
    }

    public final void setPatterns(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.patterns = list2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PackageSet getProfileScope(@NotNull Path projectPath) {
        PackageSet packageSet;
        Object $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        List sets = new ArrayList();
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        try {
            void $this$mapTo$iv$iv;
            $this$map$iv = this.patterns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(packageSetFactory.compile((String)it));
            }
            List compiledPatterns = (List)destination$iv$iv;
            sets.addAll(compiledPatterns);
        }
        catch (ParsingException e) {
            QodanaConfigKt.access$getLOG$p().debug("Cannot parse package set patterns");
        }
        if (!((Collection)this.paths).isEmpty()) {
            $this$map$iv = CollectionsKt.joinToString$default((Iterable)this.paths, null, null, null, (int)0, null, null, (int)63, null);
            AbstractPackageSet pathsSet2 = new AbstractPackageSet(this, projectPath, (String)$this$map$iv){
                @NotNull
                private final List<Path> absolutePaths;
                {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = $receiver.getPaths();
                    getProfileScope.pathsSet.1 var14_5 = this;
                    boolean $i$f$map = false;
                    void var6_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String[] stringArray = new String[]{it};
                        collection.add(Paths.get(((Object)$projectPath).toString(), stringArray));
                    }
                    var14_5.absolutePaths = (List)destination$iv$iv;
                }

                @NotNull
                public final List<Path> getAbsolutePaths() {
                    return this.absolutePaths;
                }

                public boolean contains(@NotNull VirtualFile file, @NotNull Project project2, @Nullable NamedScopesHolder holder) {
                    Object v0;
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                        Path path = Paths.get(file.getPath(), new String[0]);
                        Iterable $this$firstOrNull$iv = this.absolutePaths;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            Path it = (Path)element$iv;
                            boolean bl = false;
                            if (!FileUtil.isAncestor((Path)it, (Path)path, (boolean)false)) continue;
                            v0 = element$iv;
                            break block1;
                        }
                        v0 = null;
                    }
                    return v0 != null;
                }
            };
            sets.add(pathsSet2);
        }
        if (sets.isEmpty()) {
            packageSet = null;
        } else {
            Collection $this$toTypedArray$iv = sets;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PackageSet[] packageSetArray = thisCollection$iv.toArray(new PackageSet[0]);
            packageSet = UnionPackageSet.create((PackageSet[])Arrays.copyOf(packageSetArray, packageSetArray.length));
        }
        return packageSet;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<String> component2() {
        return this.paths;
    }

    @NotNull
    public final List<String> component3() {
        return this.patterns;
    }

    @NotNull
    public final InspectScope copy(@NotNull String name, @NotNull List<String> paths, @NotNull List<String> patterns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        return new InspectScope(name, paths, patterns);
    }

    public static /* synthetic */ InspectScope copy$default(InspectScope inspectScope, String string, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            string = inspectScope.name;
        }
        if ((n & 2) != 0) {
            list2 = inspectScope.paths;
        }
        if ((n & 4) != 0) {
            list3 = inspectScope.patterns;
        }
        return inspectScope.copy(string, list2, list3);
    }

    @NotNull
    public String toString() {
        return "InspectScope(name=" + this.name + ", paths=" + this.paths + ", patterns=" + this.patterns + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.paths).hashCode();
        result = result * 31 + ((Object)this.patterns).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InspectScope)) {
            return false;
        }
        InspectScope inspectScope = (InspectScope)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)inspectScope.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paths, inspectScope.paths)) {
            return false;
        }
        return Intrinsics.areEqual(this.patterns, inspectScope.patterns);
    }

    public InspectScope() {
        this(null, null, null, 7, null);
    }
}

