/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.streaming.IndexedResult;
import com.jetbrains.qodana.sarif.model.streaming.IndexedResultIterator;
import com.jetbrains.qodana.sarif.model.streaming.ResultIterator;
import com.jetbrains.qodana.sarif.model.streaming.StreamJsonRunsListTypeAdapter;
import com.jetbrains.qodana.sarif.model.streaming.StreamingFieldsExclusionStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SarifUtil {
    private SarifUtil() {
    }

    public static SarifReport readReport(Reader reader) {
        return SarifUtil.readReport(reader, true);
    }

    public static SarifReport readReport(Reader reader, boolean readResults) {
        GsonBuilder gsonBuilder = SarifUtil.createGsonBuilder();
        if (!readResults) {
            gsonBuilder.addDeserializationExclusionStrategy((ExclusionStrategy)new StreamingFieldsExclusionStrategy());
            gsonBuilder.registerTypeAdapterFactory(StreamJsonRunsListTypeAdapter.makeFactory());
        }
        return (SarifReport)gsonBuilder.create().fromJson(reader, SarifReport.class);
    }

    public static SarifReport readReport(Path path) throws IOException {
        return SarifUtil.readReport(path, true);
    }

    public static SarifReport readReport(Path path, boolean readResults) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            SarifReport sarifReport = SarifUtil.readReport(reader, readResults);
            return sarifReport;
        }
    }

    public static List<Result> readResultsFromObject(Object o) {
        Gson gson = SarifUtil.createGson();
        String json2 = gson.toJson(o);
        return (List)gson.fromJson(json2, new TypeToken<List<Result>>(){}.getType());
    }

    public static SarifReport emptyReport(String toolName) {
        Run run2 = new Run(new Tool(new ToolComponent(toolName))).withResults(new ArrayList<Result>());
        return new SarifReport().withRuns(List.of(run2));
    }

    public static void writeReport(Writer writer, SarifReport report2) {
        Gson gson = SarifUtil.createGson();
        gson.toJson((Object)report2, (Appendable)writer);
    }

    public static void writeReport(Path path, SarifReport report2) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            SarifUtil.writeReport(writer, report2);
        }
    }

    public static Gson createGson() {
        return SarifUtil.createGsonBuilder().create();
    }

    public static GsonBuilder createGsonBuilder() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(PropertyBag.class, (Object)new PropertyBag.PropertyBagTypeAdapter().nullSafe());
    }

    public static Iterator<Result> lazyReadResults(Reader reader, int runIndexInReport) {
        return new ResultIterator(reader, runIndexInReport);
    }

    public static Iterator<IndexedResult> lazyReadIndexedResults(Reader reader) {
        return new IndexedResultIterator(reader);
    }
}

