/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class JsonMappingsTableCellEditor
extends AbstractTableCellEditor {
    final TextFieldWithBrowseButton myComponent;
    final JPanel myWrapper;
    private final UserDefinedJsonSchemaConfiguration.Item myItem;
    private final Project myProject;
    private final TreeUpdater myTreeUpdater;

    JsonMappingsTableCellEditor(UserDefinedJsonSchemaConfiguration.Item item2, Project project2, TreeUpdater treeUpdater) {
        this.myItem = item2;
        this.myProject = project2;
        this.myTreeUpdater = treeUpdater;
        this.myComponent = new TextFieldWithBrowseButton(){

            protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor2, Disposable parent) {
            }
        };
        this.myWrapper = new JPanel();
        this.myWrapper.setBorder((Border)JBUI.Borders.empty((int)-3, (int)0));
        this.myWrapper.setLayout(new BorderLayout());
        JLabel label = new JLabel(item2.mappingKind.getPrefix().trim(), item2.mappingKind.getIcon(), 2);
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)1));
        this.myWrapper.add((Component)label, "Before");
        this.myWrapper.add((Component)this.myComponent, "Center");
        FileChooserDescriptor descriptor = JsonMappingsTableCellEditor.createDescriptor(item2);
        if (item2.isPattern()) {
            this.myComponent.getButton().setVisible(false);
        } else {
            this.myComponent.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, this.myProject){

                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    String relativePath;
                    if (chosenFile == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String string2 = (relativePath = VfsUtilCore.getRelativePath((VirtualFile)chosenFile, (VirtualFile)JsonMappingsTableCellEditor.this.myProject.getBaseDir())) != null ? relativePath : chosenFile.getPath();
                    if (string2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "chosenFile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/jsonSchema/settings/mappings/JsonMappingsTableCellEditor$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/jsonSchema/settings/mappings/JsonMappingsTableCellEditor$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "chosenFileToResultingText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "chosenFileToResultingText";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 1 -> new IllegalStateException(string2);
                    };
                }
            });
        }
        MyFileTextFieldImpl field = null;
        if (!(item2.isPattern() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
            LocalFsFinder finder = new LocalFsFinder();
            finder.setBaseDir(new File(this.myProject.getBaseDir().getPath()));
            field = new MyFileTextFieldImpl(finder, descriptor, this.myComponent.getTextField(), this.myProject, (Disposable)this.myComponent);
        }
        final MyFileTextFieldImpl finalField = field;
        this.myComponent.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(e.getKeyCode() != 10 || finalField != null && finalField.isPopupDisplayed())) {
                    JsonMappingsTableCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    @NotNull
    private static FileChooserDescriptor createDescriptor(UserDefinedJsonSchemaConfiguration.Item item2) {
        FileChooserDescriptor fileChooserDescriptor2 = item2.mappingKind == JsonMappingKind.File ? FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor() : FileChooserDescriptorFactory.createSingleFolderDescriptor();
        if (fileChooserDescriptor2 == null) {
            JsonMappingsTableCellEditor.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor2;
    }

    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column) {
        ((JTextField)this.myComponent.getChildComponent()).setText(this.myItem.getPath());
        return this.myWrapper;
    }

    public boolean stopCellEditing() {
        this.myItem.setPath(((JTextField)this.myComponent.getChildComponent()).getText());
        this.myTreeUpdater.updateTree(true);
        return super.stopCellEditing();
    }

    public Object getCellEditorValue() {
        return ((JTextField)this.myComponent.getChildComponent()).getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/settings/mappings/JsonMappingsTableCellEditor", "createDescriptor"));
    }

    private static class MyFileTextFieldImpl
    extends FileTextFieldImpl {
        private final JTextField myTextField;
        private final Project myProject;

        MyFileTextFieldImpl(LocalFsFinder finder, FileChooserDescriptor descriptor, JTextField textField, Project project2, Disposable parent) {
            super(textField, (FileLookup.Finder)finder, (FileLookup.LookupFilter)new LocalFsFinder.FileChooserFilter(descriptor, true), FileChooserFactoryImpl.getMacroMap(), parent);
            this.myTextField = textField;
            this.myProject = project2;
            this.myAutopopup = true;
        }

        protected void setTextToFile(FileLookup.LookupFile file) {
            String path2 = file.getAbsolutePath();
            VirtualFile ioFile = VfsUtil.findFileByIoFile((File)new File(path2), (boolean)false);
            if (ioFile == null) {
                this.myTextField.setText(path2);
                return;
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)ioFile, (VirtualFile)this.myProject.getBaseDir());
            this.myTextField.setText(relativePath != null ? relativePath : path2);
        }
    }
}

