/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.project.ProjectKt;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.CustomDictFileListener;
import com.intellij.spellchecker.DictionaryLevel;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.SpellCheckerManagerKt;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.RuntimeDictionaryProvider;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.grazie.GrazieSpellCheckerEngine;
import com.intellij.spellchecker.grazie.GrazieSuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.AppDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.ApplicationKt;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0007\u0018\u0000 F2\u00020\u0001:\u0001FB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003J/\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u001a2\b\u0010+\u001a\u0004\u0018\u00010\u0001J\u0018\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\bH\u0002J\b\u0010.\u001a\u00020\"H\u0016J\b\u0010/\u001a\u00020\"H\u0002J\u0010\u00100\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u00101\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0006\u00102\u001a\u00020\"J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\b042\u0006\u00105\u001a\u00020\bJ\u000e\u00106\u001a\u0002072\u0006\u0010#\u001a\u00020\bJ\u0010\u00108\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0015\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b;J\u000e\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020\bJ\u0018\u0010>\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\bH\u0002J\u0016\u0010@\u001a\u00020\"2\u000e\u0010A\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b04J\u0014\u0010B\u001a\u00020\"2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\b0DJ\b\u0010E\u001a\u00020\"H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR$\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0018\u001a\u0015\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u0019\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006G"}, d2={"Lcom/intellij/spellchecker/SpellCheckerManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "appDictionary", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "appDictionaryPath", "", "getAppDictionaryPath$intellij_spellchecker", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectDictionary", "Lcom/intellij/spellchecker/dictionary/ProjectDictionary;", "projectDictionaryPath", "getProjectDictionaryPath$intellij_spellchecker", "<set-?>", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "spellChecker", "getSpellChecker", "()Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "suggestionProvider", "Lcom/intellij/spellchecker/engine/SuggestionProvider;", "userDictionaryListenerEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/spellchecker/state/DictionaryStateListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "userDictionaryWords", "", "getUserDictionaryWords", "()Ljava/util/Set;", "acceptWordAsCorrect", "", "word", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dictionaryLevel", "Lcom/intellij/spellchecker/DictionaryLevel;", "acceptWordAsCorrect$intellij_spellchecker", "addUserDictionaryChangedListener", "listener", "parentDisposable", "addWordToDictionary", "dictionary", "dispose", "ensureSpellerIsLoaded", "fillEngineDictionary", "fireDictionaryChanged", "fullConfigurationReload", "getSuggestions", "", "text", "hasProblem", "", "initUserDictionaries", "loadDictionary", "path", "loadDictionary$intellij_spellchecker", "openDictionaryInEditor", "dictPath", "removeWordFromDictionary", "transformed", "updateBundledDictionaries", "removedDictionaries", "updateUserDictionary", "words", "", "waitForSpeller", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,475:1\n1#2:476\n29#3,3:477\n29#3,3:480\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager\n*L\n133#1:477,3\n212#1:480,3\n*E\n"})
public final class SpellCheckerManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private ProjectDictionary projectDictionary;
    @Nullable
    private EditableDictionary appDictionary;
    @NotNull
    private final String projectDictionaryPath;
    @NotNull
    private final String appDictionaryPath;
    @NotNull
    private final EventDispatcher<DictionaryStateListener> userDictionaryListenerEventDispatcher;
    @Nullable
    private SpellCheckerEngine spellChecker;
    @Nullable
    private SuggestionProvider suggestionProvider;
    private static final int MAX_METRICS = 1;
    @NotNull
    private static final String PROJECT_DICTIONARY_PATH;
    @NotNull
    private static final String CACHED_DICTIONARY_FILE = "spellchecker-dictionary.xml";

    public SpellCheckerManager(@NotNull Project project2) {
        VirtualFile projectStoreDir;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        EventDispatcher eventDispatcher = EventDispatcher.create(DictionaryStateListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(DictionaryStateListener::class.java)");
        this.userDictionaryListenerEventDispatcher = eventDispatcher;
        this.ensureSpellerIsLoaded();
        this.fullConfigurationReload();
        VirtualFile virtualFile2 = this.project.getBaseDir();
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            virtualFile = ProjectKt.getProjectStoreDirectory((VirtualFile)it);
        } else {
            virtualFile = null;
        }
        VirtualFile virtualFile3 = projectStoreDir = virtualFile;
        this.projectDictionaryPath = virtualFile3 == null ? "" : virtualFile3.getPath() + File.separator + PROJECT_DICTIONARY_PATH;
        this.appDictionaryPath = PathManager.getOptionsPath() + File.separator + CACHED_DICTIONARY_FILE;
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)new CustomDictFileListener(this.project, this), (Disposable)this);
        SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().addChangeListener(() -> SpellCheckerManager._init_$lambda$1(this), (Disposable)this);
        RuntimeDictionaryProvider.EP_NAME.addChangeListener(() -> SpellCheckerManager._init_$lambda$2(this), (Disposable)this);
        CustomDictionaryProvider.EP_NAME.addChangeListener(() -> SpellCheckerManager._init_$lambda$3(this), (Disposable)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getProjectDictionaryPath$intellij_spellchecker() {
        return this.projectDictionaryPath;
    }

    @NotNull
    public final String getAppDictionaryPath$intellij_spellchecker() {
        return this.appDictionaryPath;
    }

    @Nullable
    public final SpellCheckerEngine getSpellChecker() {
        return this.spellChecker;
    }

    private final void ensureSpellerIsLoaded() {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            if (ApplicationKt.getApplication().isReadAccessAllowed()) {
                this.waitForSpeller();
            } else {
                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>((Object)this){

                    public final void invoke() {
                        SpellCheckerManager.access$waitForSpeller((SpellCheckerManager)this.receiver);
                    }
                }));
            }
        }
    }

    private final void waitForSpeller() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpellCheckerManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ComponentManager $this$service$iv = (ComponentManager)this.this$0.getProject();
                        boolean $i$f$service = false;
                        Class<GrazieSpellCheckerEngine> serviceClass$iv = GrazieSpellCheckerEngine.class;
                        Object object3 = $this$service$iv.getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                        }
                        this.label = 1;
                        Object object4 = ((GrazieSpellCheckerEngine)object3).waitForSpeller((Continuation<? super Unit>)((Continuation)this));
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void fullConfigurationReload() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GrazieSpellCheckerEngine> serviceClass$iv = GrazieSpellCheckerEngine.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        GrazieSpellCheckerEngine spellChecker = (GrazieSpellCheckerEngine)object;
        this.spellChecker = spellChecker;
        this.suggestionProvider = new GrazieSuggestionProvider(spellChecker);
        this.fillEngineDictionary(spellChecker);
    }

    public final void updateBundledDictionaries(@NotNull List<String> removedDictionaries) {
        Intrinsics.checkNotNullParameter(removedDictionaries, (String)"removedDictionaries");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        for (BundledDictionaryProvider provider : SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().getExtensionList()) {
            String[] stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getBundledDictionaries(), (String)"provider.bundledDictionaries");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String dictionary = stringArray[i];
                if (spellChecker.isDictionaryLoad(dictionary)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)dictionary, (String)"dictionary");
                SpellCheckerManagerKt.access$loadBundledDictionary(provider, dictionary, spellChecker);
            }
        }
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(project)");
        SpellCheckerSettings settings = spellCheckerSettings;
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            Dictionary[] dictionaryArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getDictionaries(), (String)"provider.dictionaries");
            for (Dictionary dictionary : dictionaryArray) {
                boolean dictionaryShouldBeLoad = !settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName());
                boolean dictionaryIsLoad = spellChecker.isDictionaryLoad(dictionary.getName());
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    spellChecker.removeDictionary(dictionary.getName());
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                spellChecker.addDictionary(dictionary);
            }
        }
        if (settings.getCustomDictionariesPaths() != null) {
            for (String dictionary : settings.getCustomDictionariesPaths()) {
                if (spellChecker.isDictionaryLoad(dictionary)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)dictionary, (String)"dictionary");
                this.loadDictionary$intellij_spellchecker(dictionary);
            }
        }
        if (!removedDictionaries.isEmpty()) {
            Iterator<Object> iterator = removedDictionaries.iterator();
            while (iterator.hasNext()) {
                String name;
                String string2 = name = (String)iterator.next();
                Intrinsics.checkNotNull((Object)string2);
                spellChecker.removeDictionary(string2);
            }
        }
        Companion.restartInspections();
    }

    @NotNull
    public final Set<String> getUserDictionaryWords() {
        ProjectDictionary projectDictionary = this.projectDictionary;
        Intrinsics.checkNotNull((Object)projectDictionary);
        Set<String> set = projectDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"projectDictionary!!.editableWords");
        EditableDictionary editableDictionary = this.appDictionary;
        Intrinsics.checkNotNull((Object)editableDictionary);
        Set<String> set2 = editableDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"appDictionary!!.editableWords");
        return SetsKt.plus(set, (Iterable)set2);
    }

    private final void fillEngineDictionary(SpellCheckerEngine spellChecker) {
        spellChecker.reset();
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(project)");
        SpellCheckerSettings settings = spellCheckerSettings;
        SpellCheckerManagerKt.access$loadBundledDictionaries(spellChecker);
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            Dictionary[] dictionaryArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getDictionaries(), (String)"provider.dictionaries");
            for (Dictionary dictionary : dictionaryArray) {
                if (settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName())) continue;
                spellChecker.addDictionary(dictionary);
            }
        }
        if (settings.getCustomDictionariesPaths() != null) {
            for (String path2 : settings.getCustomDictionariesPaths()) {
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                this.loadDictionary$intellij_spellchecker(path2);
            }
        }
        this.initUserDictionaries(spellChecker);
    }

    private final void initUserDictionaries(SpellCheckerEngine spellChecker) {
        AppDictionaryState appDictionaryState = AppDictionaryState.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)appDictionaryState, (String)"getInstance()");
        AppDictionaryState appDictionaryState2 = appDictionaryState;
        appDictionaryState2.addAppDictListener(SpellCheckerManager::initUserDictionaries$lambda$4, this);
        if (appDictionaryState2.getDictionary() == null) {
            appDictionaryState2.setDictionary(new UserDictionary("cached"));
        }
        EditableDictionary editableDictionary = this.appDictionary = appDictionaryState2.getDictionary();
        Intrinsics.checkNotNull((Object)editableDictionary);
        spellChecker.addModifiableDictionary(editableDictionary);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectDictionaryState> serviceClass$iv = ProjectDictionaryState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ProjectDictionaryState dictionaryState = (ProjectDictionaryState)object;
        dictionaryState.addProjectDictListener(SpellCheckerManager::initUserDictionaries$lambda$5);
        ProjectDictionary projectDictionary = this.projectDictionary = dictionaryState.getProjectDictionary();
        Intrinsics.checkNotNull((Object)projectDictionary);
        projectDictionary.setActiveName(System.getProperty("user.name"));
        ProjectDictionary projectDictionary2 = this.projectDictionary;
        Intrinsics.checkNotNull((Object)projectDictionary2);
        spellChecker.addModifiableDictionary(projectDictionary2);
    }

    public final void loadDictionary$intellij_spellchecker(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        CustomDictionaryProvider dictionaryProvider = SpellCheckerManager.Companion.findApplicable(path2);
        if (dictionaryProvider == null) {
            SpellCheckerEngine spellCheckerEngine = this.spellChecker;
            Intrinsics.checkNotNull((Object)spellCheckerEngine);
            spellCheckerEngine.loadDictionary(new FileLoader(path2));
        } else {
            Dictionary dictionary = dictionaryProvider.get(path2);
            if (dictionary != null) {
                SpellCheckerEngine spellCheckerEngine = this.spellChecker;
                Intrinsics.checkNotNull((Object)spellCheckerEngine);
                spellCheckerEngine.addDictionary(dictionary);
            }
        }
    }

    public final boolean hasProblem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        return !spellCheckerEngine.isCorrect(word);
    }

    public final void acceptWordAsCorrect(@NotNull String word, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.acceptWordAsCorrect$intellij_spellchecker(word, null, project2, DictionaryLevel.PROJECT);
    }

    public final void acceptWordAsCorrect$intellij_spellchecker(@NotNull String word, @Nullable VirtualFile file, @NotNull Project project2, @NotNull DictionaryLevel dictionaryLevel) {
        EditableDictionary dictionary;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)dictionaryLevel), (String)"dictionaryLevel");
        if (DictionaryLevel.NOT_SPECIFIED == dictionaryLevel) {
            return;
        }
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        String string2 = spellCheckerEngine.getTransformation().transform(word);
        if (string2 == null) {
            return;
        }
        String transformed = string2;
        EditableDictionary editableDictionary = dictionary = DictionaryLevel.PROJECT == dictionaryLevel ? (EditableDictionary)this.projectDictionary : this.appDictionary;
        if (file != null) {
            WriteCommandAction.writeCommandAction((Project)project2).run(() -> SpellCheckerManager.acceptWordAsCorrect$lambda$6(project2, file, this, dictionary, transformed));
        }
        EditableDictionary editableDictionary2 = dictionary;
        Intrinsics.checkNotNull((Object)editableDictionary2);
        this.addWordToDictionary(editableDictionary2, transformed);
    }

    private final void addWordToDictionary(EditableDictionary dictionary, String word) {
        dictionary.addToDictionary(word);
        this.fireDictionaryChanged(dictionary);
    }

    private final void removeWordFromDictionary(EditableDictionary dictionary, String transformed) {
        dictionary.removeFromDictionary(transformed);
        this.fireDictionaryChanged(dictionary);
    }

    private final void fireDictionaryChanged(EditableDictionary dictionary) {
        ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(dictionary);
        Companion.restartInspections();
        SaveAndSyncHandler.scheduleProjectSave$default((SaveAndSyncHandler)SaveAndSyncHandler.Companion.getInstance(), (Project)this.project, (boolean)false, (int)2, null);
    }

    public final void updateUserDictionary(@NotNull Collection<String> words2) {
        Intrinsics.checkNotNullParameter(words2, (String)"words");
        List addedToProjectWords = CollectionsKt.minus((Iterable)words2, (Iterable)this.getUserDictionaryWords());
        ProjectDictionary projectDictionary = this.projectDictionary;
        Intrinsics.checkNotNull((Object)projectDictionary);
        ProjectDictionary projectDictionary2 = projectDictionary;
        for (String word : addedToProjectWords) {
            projectDictionary2.addToDictionary(word);
        }
        HashSet wordSet = CollectionsKt.toHashSet((Iterable)words2);
        Set<String> set = projectDictionary2.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"projectDictionary.editableWords");
        Set deletedFromProjectWords = SetsKt.minus(set, (Iterable)wordSet);
        for (String word : deletedFromProjectWords) {
            projectDictionary2.removeFromDictionary(word);
        }
        if (addedToProjectWords.size() + deletedFromProjectWords.size() > 0) {
            ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(projectDictionary2);
        }
        EditableDictionary editableDictionary = this.appDictionary;
        Intrinsics.checkNotNull((Object)editableDictionary);
        Set<String> set2 = editableDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"appDictionary!!.editableWords");
        Set deletedFromApplicationWords = SetsKt.minus(set2, (Iterable)wordSet);
        for (String word : deletedFromApplicationWords) {
            EditableDictionary editableDictionary2 = this.appDictionary;
            Intrinsics.checkNotNull((Object)editableDictionary2);
            editableDictionary2.removeFromDictionary(word);
        }
        if (!deletedFromApplicationWords.isEmpty()) {
            ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.appDictionary);
        }
        Companion.restartInspections();
    }

    @NotNull
    public final List<String> getSuggestions(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int correctionLimit = Registry.intValue((String)"spellchecker.corrections.limit", (int)5);
        SuggestionProvider suggestionProvider = this.suggestionProvider;
        Intrinsics.checkNotNull((Object)suggestionProvider);
        List<String> list = suggestionProvider.getSuggestions(text2, correctionLimit, 1);
        Intrinsics.checkNotNullExpressionValue(list, (String)"suggestionProvider!!.get\u2026ectionLimit, MAX_METRICS)");
        return list;
    }

    public void dispose() {
    }

    public final void openDictionaryInEditor(@NotNull String dictPath) {
        block1: {
            VirtualFile file;
            Intrinsics.checkNotNullParameter((Object)dictPath, (String)"dictPath");
            VirtualFile virtualFile = file = ((CharSequence)dictPath).length() == 0 ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(dictPath);
            if (file == null) {
                String title2 = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
                Object[] objectArray = new Object[]{dictPath};
                String message2 = SpellCheckerBundle.message("dictionary.not.found", objectArray);
                Messages.showMessageDialog((Project)this.project, (String)message2, (String)title2, (Icon)Messages.getWarningIcon());
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
            if (fileEditorManager == null) break block1;
            fileEditorManager.openFile(file, true);
        }
    }

    public final void addUserDictionaryChangedListener(@NotNull DictionaryStateListener listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.userDictionaryListenerEventDispatcher.addListener((EventListener)listener2);
        Disposable disposable = parentDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.register((Disposable)disposable, () -> SpellCheckerManager.addUserDictionaryChangedListener$lambda$7(this, listener2));
    }

    private static final void _init_$lambda$1(SpellCheckerManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SpellCheckerEngine spellCheckerEngine = this$0.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        this$0.fillEngineDictionary(spellCheckerEngine);
    }

    private static final void _init_$lambda$2(SpellCheckerManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SpellCheckerEngine spellCheckerEngine = this$0.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        this$0.fillEngineDictionary(spellCheckerEngine);
    }

    private static final void _init_$lambda$3(SpellCheckerManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SpellCheckerEngine spellCheckerEngine = this$0.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        this$0.fillEngineDictionary(spellCheckerEngine);
    }

    private static final void initUserDictionaries$lambda$4(EditableDictionary it) {
        Companion.restartInspections();
    }

    private static final void initUserDictionaries$lambda$5(EditableDictionary it) {
        Companion.restartInspections();
    }

    private static final void acceptWordAsCorrect$lambda$6(Project $project, VirtualFile $file, SpellCheckerManager this$0, EditableDictionary $dictionary, String $transformed) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$transformed, (String)"$transformed");
        VirtualFile[] virtualFileArray = new VirtualFile[]{$file};
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this$0, $dictionary, $transformed, virtualFileArray2){
            final /* synthetic */ SpellCheckerManager this$0;
            final /* synthetic */ EditableDictionary $dictionary;
            final /* synthetic */ String $transformed;
            {
                this.this$0 = $receiver;
                this.$dictionary = $dictionary;
                this.$transformed = $transformed;
                super($super_call_param$1);
            }

            public void undo() {
                EditableDictionary editableDictionary = this.$dictionary;
                Intrinsics.checkNotNull((Object)editableDictionary);
                SpellCheckerManager.access$removeWordFromDictionary(this.this$0, editableDictionary, this.$transformed);
            }

            public void redo() {
                EditableDictionary editableDictionary = this.$dictionary;
                Intrinsics.checkNotNull((Object)editableDictionary);
                SpellCheckerManager.access$addWordToDictionary(this.this$0, editableDictionary, this.$transformed);
            }
        });
    }

    private static final void addUserDictionaryChangedListener$lambda$7(SpellCheckerManager this$0, DictionaryStateListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.userDictionaryListenerEventDispatcher.removeListener((EventListener)$listener);
    }

    @JvmStatic
    @NotNull
    public static final SpellCheckerManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @NotNull
    public static final List<String> getBundledDictionaries() {
        return Companion.getBundledDictionaries();
    }

    @NotNull
    public static final List<Dictionary> getRuntimeDictionaries() {
        return Companion.getRuntimeDictionaries();
    }

    public static final /* synthetic */ void access$waitForSpeller(SpellCheckerManager $this) {
        $this.waitForSpeller();
    }

    public static final /* synthetic */ void access$removeWordFromDictionary(SpellCheckerManager $this, EditableDictionary dictionary, String transformed) {
        $this.removeWordFromDictionary(dictionary, transformed);
    }

    public static final /* synthetic */ void access$addWordToDictionary(SpellCheckerManager $this, EditableDictionary dictionary, String word) {
        $this.addWordToDictionary(dictionary, word);
    }

    static {
        String string2 = System.getProperty("user.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"user.name\")");
        PROJECT_DICTIONARY_PATH = "dictionaries" + File.separator + StringsKt.replace$default((String)string2, (char)'.', (char)'_', (boolean)false, (int)4, null) + ".xml";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spellchecker/SpellCheckerManager$Companion;", "", "()V", "CACHED_DICTIONARY_FILE", "", "MAX_METRICS", "", "PROJECT_DICTIONARY_PATH", "bundledDictionaries", "", "getBundledDictionaries$annotations", "getBundledDictionaries", "()Ljava/util/List;", "runtimeDictionaries", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "getRuntimeDictionaries$annotations", "getRuntimeDictionaries", "findApplicable", "Lcom/intellij/spellchecker/dictionary/CustomDictionaryProvider;", "path", "getInstance", "Lcom/intellij/spellchecker/SpellCheckerManager;", "project", "Lcom/intellij/openapi/project/Project;", "restartInspections", "", "intellij.spellchecker"})
    @SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,475:1\n29#2,3:476\n1373#3:479\n1461#3,5:480\n1373#3:485\n1461#3,5:486\n288#3,2:491\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager$Companion\n*L\n106#1:476,3\n110#1:479\n110#1:480,5\n114#1:485\n114#1:486,5\n128#1:491,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpellCheckerManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<SpellCheckerManager> serviceClass$iv = SpellCheckerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (SpellCheckerManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getBundledDictionaries() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().getExtensionList();
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BundledDictionaryProvider it = (BundledDictionaryProvider)element$iv$iv;
                boolean bl = false;
                String[] stringArray = it.getBundledDictionaries();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"it.bundledDictionaries");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])stringArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public static /* synthetic */ void getBundledDictionaries$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Dictionary> getRuntimeDictionaries() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = RuntimeDictionaryProvider.EP_NAME.getExtensionList();
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RuntimeDictionaryProvider it = (RuntimeDictionaryProvider)element$iv$iv;
                boolean bl = false;
                Dictionary[] dictionaryArray = it.getDictionaries();
                Intrinsics.checkNotNullExpressionValue((Object)dictionaryArray, (String)"it.dictionaries");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])dictionaryArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public static /* synthetic */ void getRuntimeDictionaries$annotations() {
        }

        public final void restartInspections() {
            ApplicationManager.getApplication().invokeLater(Companion::restartInspections$lambda$2);
        }

        private final CustomDictionaryProvider findApplicable(String path2) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = CustomDictionaryProvider.EP_NAME.getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CustomDictionaryProvider it = (CustomDictionaryProvider)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(path2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private static final void restartInspections$lambda$2() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
            for (Project project2 : projectArray) {
                if (!project2.isInitialized() || !project2.isOpen()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project2).restart();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

